/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.map.CustomDataHolder;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.fabric.MapDecorationRegistryImpl;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.CustomDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.SimpleDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4926;
import net.minecraft.class_5321;
import org.jetbrains.annotations.ApiStatus;

public class MapDecorationRegistry {
    public static final Codec<MapDecorationType<?, ?>> TYPE_CODEC = Codec.either(CustomDecorationType.CODEC, SimpleDecorationType.CODEC).xmap(either -> (MapDecorationType)either.map(s -> s, c -> c), type -> {
        if (type == null) {
            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
        }
        if (type instanceof CustomDecorationType) {
            CustomDecorationType c = (CustomDecorationType)type;
            return Either.left((Object)c);
        }
        return Either.right((Object)((SimpleDecorationType)type));
    });
    public static final Codec<MapDecorationType<?, ?>> TYPE_CODEC_BUGGY_2 = MapDecorationType.GENERIC_CODEC;
    public static final Codec<MapDecorationType<?, ?>> TYPE_CODEC_2 = new Codec<MapDecorationType<?, ?>>(){

        public <T> DataResult<T> encode(MapDecorationType<?, ?> input, DynamicOps<T> ops, T prefix) {
            if (input instanceof CustomDecorationType) {
                CustomDecorationType type = (CustomDecorationType)input;
                return CustomDecorationType.CODEC.encode((Object)type, ops, prefix);
            }
            return SimpleDecorationType.CODEC.encode((Object)((SimpleDecorationType)input), ops, prefix);
        }

        public <T> DataResult<Pair<MapDecorationType<?, ?>, T>> decode(DynamicOps<T> ops, T input) {
            DataResult first = CustomDecorationType.CODEC.decode(ops, input);
            if (first.result().isPresent()) {
                return first.map(v -> v.mapFirst(a -> a));
            }
            return SimpleDecorationType.CODEC.decode(ops, input).map(v -> v.mapFirst(a -> a));
        }
    };
    public static final Map<class_2960, CustomDataHolder<?>> CUSTOM_MAP_DATA_TYPES = new HashMap();
    public static final class_2960 GENERIC_STRUCTURE_ID = Moonlight.res("generic_structure");
    public static final Map<class_2960, Supplier<CustomDecorationType<?, ?>>> CODE_TYPES_FACTORIES = new HashMap();

    public static <T> void registerCustomMapSavedData(class_2960 name, Class<T> type, Function<class_2487, T> load, BiConsumer<class_2487, T> save, class_4926.class_4932<class_22, class_1297, T, Boolean> onItemUpdate, class_4926.class_4932<class_22, class_1799, T, class_2561> onItemTooltip) {
        if (CUSTOM_MAP_DATA_TYPES.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate custom map data registration " + name);
        }
        CUSTOM_MAP_DATA_TYPES.put(name, new CustomDataHolder<T>(name, load, save, onItemUpdate, onItemTooltip));
    }

    public static MapDecorationType<?, ?> getGenericStructure() {
        return MapDecorationRegistry.get(GENERIC_STRUCTURE_ID);
    }

    public static void register(class_2960 id, Supplier<CustomDecorationType<?, ?>> markerType) {
        CODE_TYPES_FACTORIES.put(id, markerType);
        MapDecorationRegistry.registerInternal(id, markerType::get);
    }

    public static void registerSimple(String modId, String name) {
        class_2960 id = new class_2960(modId, name);
        MapDecorationRegistry.register(id, () -> new CustomDecorationType(id, CustomMapDecoration::new));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerInternal(class_2960 id, Supplier<MapDecorationType<?, ?>> markerType) {
        void var1_1;
        MapDecorationRegistryImpl.registerInternal(id, var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        MapDecorationRegistryImpl.init();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_5321<class_2378<MapDecorationType<?, ?>>> getRegistryKey() {
        return MapDecorationRegistryImpl.getRegistryKey();
    }

    public static class_2378<MapDecorationType<?, ?>> getDataPackRegistry() {
        return Utils.hackyGetRegistryAccess().method_30530(MapDecorationRegistry.getRegistryKey());
    }

    public static Collection<MapDecorationType<?, ?>> getValues() {
        return MapDecorationRegistry.getDataPackRegistry().method_10220().toList();
    }

    public static Set<Map.Entry<class_5321<MapDecorationType<?, ?>>, MapDecorationType<?, ?>>> getEntries() {
        return MapDecorationRegistry.getDataPackRegistry().method_29722();
    }

    @Nullable
    public static class_2960 getID(MapDecorationType<?, ?> s) {
        return MapDecorationRegistry.getDataPackRegistry().method_10221(s);
    }

    @Nullable
    public static MapDecorationType<? extends CustomMapDecoration, ?> get(String id) {
        return MapDecorationRegistry.get(new class_2960(id));
    }

    public static MapDecorationType<?, ?> get(class_2960 id) {
        return (MapDecorationType)MapDecorationRegistry.getDataPackRegistry().method_10223(id);
    }

    public static Optional<MapDecorationType<?, ?>> getOptional(class_2960 id) {
        return MapDecorationRegistry.getDataPackRegistry().method_17966(id);
    }

    @Nullable
    @ApiStatus.Internal
    public static MapBlockMarker<?> readWorldMarker(class_2487 compound) {
        for (Map.Entry<class_5321<MapDecorationType<?, ?>>, MapDecorationType<?, ?>> e : MapDecorationRegistry.getEntries()) {
            String id = e.getKey().method_29177().toString();
            if (!compound.method_10545(id)) continue;
            return e.getValue().loadMarkerFromNBT(compound.method_10562(id));
        }
        return null;
    }

    @ApiStatus.Internal
    public static List<MapBlockMarker<?>> getMarkersFromWorld(class_1922 reader, class_2338 pos) {
        ArrayList list = new ArrayList();
        for (MapDecorationType<?, ?> type : MapDecorationRegistry.getValues()) {
            Object c = type.getWorldMarkerFromWorld(reader, pos);
            if (c == null) continue;
            list.add((MapBlockMarker<?>)c);
        }
        return list;
    }
}

