/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.VanillaSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.fabric.SoftFluidTankImpl;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1803;
import net.minecraft.class_1828;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;

public abstract class SoftFluidTank {
    public static final String POTION_TYPE_KEY = "Bottle";
    public static final int BOTTLE_COUNT = 1;
    public static final int BOWL_COUNT = 2;
    public static final int BUCKET_COUNT = 4;
    protected int count = 0;
    protected final int capacity;
    @Nullable
    protected class_2487 nbt = null;
    protected SoftFluid fluid = VanillaSoftFluids.EMPTY.get();
    protected int specialColor = 0;
    protected boolean needsColorRefresh = true;

    protected SoftFluidTank(int capacity) {
        this.capacity = capacity;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SoftFluidTank create(int capacity) {
        return SoftFluidTankImpl.create(capacity);
    }

    public boolean interactWithPlayer(class_1657 player, class_1268 hand, @Nullable class_1937 world, @Nullable class_2338 pos) {
        class_1799 handStack = player.method_5998(hand);
        class_1799 returnStack = this.interactWithItem(handStack, world, pos, false);
        if (returnStack != null) {
            Utils.swapItem(player, hand, returnStack);
            if (!handStack.method_7960()) {
                player.method_7259(class_3468.field_15372.method_14956((Object)handStack.method_7909()));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public class_1799 interactWithItem(class_1799 stack, @Nullable class_1937 world, @Nullable class_2338 pos, boolean simulate) {
        class_1799 returnStack = this.tryFillingItem(stack.method_7909(), world, pos, simulate);
        if (returnStack != null) {
            return returnStack;
        }
        returnStack = this.tryDrainItem(stack, world, pos, simulate);
        return returnStack;
    }

    public class_1799 tryDrainItem(class_1799 filledContainerStack, @Nullable class_1937 world, @Nullable class_2338 pos, boolean simulate) {
        return this.tryDrainItem(filledContainerStack, world, pos, simulate, true);
    }

    @Nullable
    public class_1799 tryDrainItem(class_1799 filledContainerStack, @Nullable class_1937 world, @Nullable class_2338 pos, boolean simulate, boolean playSound) {
        FluidContainerList.Category category;
        int amount;
        Optional<FluidContainerList.Category> optionalCategory;
        boolean hasCustomPot;
        class_1792 filledContainer = filledContainerStack.method_7909();
        SoftFluid s = SoftFluidRegistry.fromItem(filledContainer);
        if (s.isEmpty()) {
            return null;
        }
        class_2487 com = filledContainerStack.method_7969();
        class_2487 newCom = new class_2487();
        class_1842 potion = class_1844.method_8063((class_1799)filledContainerStack);
        boolean bl = hasCustomPot = com != null && com.method_10545("CustomPotionEffects");
        if (potion == class_1847.field_8991 && !hasCustomPot) {
            s = VanillaSoftFluids.WATER.get();
        } else if (potion != class_1847.field_8984 || hasCustomPot) {
            this.addPotionTag(filledContainer, newCom);
        }
        if (com != null) {
            for (String k : s.getNbtKeyFromItem()) {
                class_2520 c = com.method_10580(k);
                if (c == null) continue;
                newCom.method_10566(k, c);
            }
        }
        if (this.isEmpty()) {
            this.setFluid(s, newCom.method_33133() ? null : newCom);
        }
        if ((optionalCategory = s.getContainerList().getCategoryFromFilled(filledContainer)).isPresent() && this.canAddSoftFluid(s, amount = (category = optionalCategory.get()).getAmount(), newCom)) {
            if (simulate) {
                return class_1799.field_8037;
            }
            this.grow(amount);
            class_3414 sound = category.getEmptySound();
            if (sound != null && world != null && pos != null) {
                world.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
            }
            return new class_1799((class_1935)category.getEmptyContainer());
        }
        return null;
    }

    public class_1799 tryFillingItem(class_1792 emptyContainer, @Nullable class_1937 world, @Nullable class_2338 pos, boolean simulate) {
        return this.tryFillingItem(emptyContainer, world, pos, simulate, true);
    }

    @Nullable
    public class_1799 tryFillingItem(class_1792 emptyContainer, @Nullable class_1937 world, @Nullable class_2338 pos, boolean simulate, boolean playSound) {
        FluidContainerList.Category category;
        int amount;
        Optional<FluidContainerList.Category> opt = this.fluid.getContainerList().getCategoryFromEmpty(emptyContainer);
        if (opt.isPresent() && this.canRemove(amount = (category = opt.get()).getAmount())) {
            if (simulate) {
                return class_1799.field_8037;
            }
            class_1799 stack = new class_1799((class_1935)category.getFirstFilled().get());
            if (this.fluid == VanillaSoftFluids.POTION.get() && this.nbt != null && this.nbt.method_10545(POTION_TYPE_KEY) && !Utils.getID(emptyContainer).method_12836().equals("inspirations")) {
                String bottle = this.nbt.method_10558(POTION_TYPE_KEY);
                if (bottle.equals("SPLASH")) {
                    stack = new class_1799((class_1935)class_1802.field_8436);
                } else if (bottle.equals("LINGERING")) {
                    stack = new class_1799((class_1935)class_1802.field_8150);
                }
            }
            if (emptyContainer == class_1802.field_8469 && this.fluid == VanillaSoftFluids.WATER.get()) {
                stack = class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8991);
            }
            this.applyNBTtoItemStack(stack);
            this.shrink(amount);
            class_3414 sound = category.getEmptySound();
            if (sound != null && world != null && pos != null) {
                world.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
            }
            return stack;
        }
        return null;
    }

    @Nullable
    public class_1799 tryFillingBottle(class_1937 world, class_2338 pos) {
        return this.tryFillingItem(class_1802.field_8469, world, pos, false);
    }

    @Nullable
    public class_1799 tryFillingBucket(class_1937 world, class_2338 pos) {
        return this.tryFillingItem(class_1802.field_8550, world, pos, false);
    }

    @Nullable
    public class_1799 tryFillingBowl(class_1937 world, class_2338 pos) {
        return this.tryFillingItem(class_1802.field_8428, world, pos, false);
    }

    public boolean isSameFluidAs(SoftFluid other) {
        return this.isSameFluidAs(other, null);
    }

    public boolean isSameFluidAs(SoftFluid other, @Nullable class_2487 com) {
        return this.getFluid().equals(other) && SoftFluidTank.areNbtEquals(this.getNbt(), com);
    }

    public boolean tryAddingFluid(SoftFluid s, int count, @Nullable class_2487 com) {
        if (this.canAdd(count)) {
            if (this.isEmpty()) {
                this.setFluid(s, com);
                this.setCount(count);
                return true;
            }
            if (this.isSameFluidAs(s, com)) {
                this.grow(count);
                return true;
            }
        }
        return false;
    }

    public boolean tryAddingFluid(SoftFluid s, int count) {
        return this.tryAddingFluid(s, count, null);
    }

    public boolean tryAddingFluid(SoftFluid s) {
        return this.tryAddingFluid(s, 1);
    }

    public boolean tryTransferFluid(SoftFluidTank destination) {
        return this.tryTransferFluid(destination, 1);
    }

    public boolean tryTransferFluid(SoftFluidTank destination, int amount) {
        if (destination.canAdd(amount) && this.canRemove(amount)) {
            if (destination.isEmpty()) {
                destination.setFluid(this.getFluid(), this.getNbt());
                this.shrink(amount);
                destination.grow(amount);
                return true;
            }
            if (this.isSameFluidAs(destination.getFluid(), destination.getNbt())) {
                this.shrink(amount);
                destination.grow(amount);
                return true;
            }
        }
        return false;
    }

    public boolean canRemove(int n) {
        return this.count >= n && !this.isEmpty();
    }

    public boolean canAdd(int n) {
        return this.count + n <= this.capacity;
    }

    public boolean canAddSoftFluid(SoftFluid s, int count) {
        return this.canAddSoftFluid(s, count, null);
    }

    public boolean canAddSoftFluid(SoftFluid s, int count, @Nullable class_2487 nbt) {
        return this.canAdd(count) && this.isSameFluidAs(s, nbt);
    }

    public boolean isFull() {
        return this.count == this.capacity;
    }

    public boolean isEmpty() {
        return this.fluid.isEmpty() || this.count <= 0;
    }

    public void lossyAdd(int inc) {
        this.count = Math.min(this.capacity, this.count + inc);
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void fillCount() {
        this.setCount(this.capacity);
    }

    public void grow(int inc) {
        this.setCount(this.count + inc);
    }

    public void shrink(int inc) {
        this.grow(-inc);
        if (this.count == 0) {
            this.clear();
        }
    }

    public float getHeight(float maxHeight) {
        return maxHeight * (float)this.count / (float)this.capacity;
    }

    public int getComparatorOutput() {
        float f = (float)this.count / (float)this.capacity;
        return class_3532.method_15375((float)(f * 14.0f)) + 1;
    }

    public int getCount() {
        return this.count;
    }

    @Nonnull
    public SoftFluid getFluid() {
        return this.fluid;
    }

    @Nullable
    public class_2487 getNbt() {
        return this.nbt;
    }

    public void setNbt(@Nullable class_2487 nbt) {
        this.nbt = nbt;
    }

    public void clear() {
        this.fluid = VanillaSoftFluids.EMPTY.get();
        this.setCount(0);
        this.nbt = null;
        this.specialColor = 0;
    }

    public void copy(SoftFluidTank other) {
        this.setFluid(other.getFluid(), other.getNbt());
        this.setCount(Math.min(this.capacity, other.getCount()));
    }

    public void fill(SoftFluid fluid) {
        this.fill(fluid, null);
    }

    public void fill(SoftFluid fluid, @Nullable class_2487 nbt) {
        this.setFluid(fluid, nbt);
        this.fillCount();
    }

    public void setFluid(@NotNull SoftFluid fluid) {
        this.setFluid(fluid, null);
    }

    public void setFluid(@NotNull SoftFluid fluid, @Nullable class_2487 nbt) {
        this.fluid = fluid;
        if (fluid == null) {
            boolean bl = true;
        }
        this.nbt = null;
        if (nbt != null) {
            this.nbt = nbt.method_10553();
            if (fluid.equals(VanillaSoftFluids.POTION.get()) && !this.nbt.method_10545(POTION_TYPE_KEY)) {
                this.nbt.method_10582(POTION_TYPE_KEY, "REGULAR");
            }
        }
        this.specialColor = 0;
        if (this.fluid.isEmpty()) {
            this.setCount(0);
        }
        this.needsColorRefresh = true;
    }

    public abstract int getTintColor(@Nullable class_4538 var1, @Nullable class_2338 var2);

    public abstract int getFlowingTint(@Nullable class_4538 var1, @Nullable class_2338 var2);

    public abstract int getParticleColor(@Nullable class_4538 var1, @Nullable class_2338 var2);

    public boolean containsFood() {
        return this.fluid.isFood();
    }

    public void load(class_2487 compound) {
        if (compound.method_10545("FluidHolder")) {
            class_2487 cmp = compound.method_10562("FluidHolder");
            this.setCount(cmp.method_10550("Count"));
            String id = cmp.method_10558("Fluid");
            SoftFluid sf = SoftFluidRegistry.get(id);
            this.setFluid(sf, cmp.method_10562("NBT"));
        }
        if (this.fluid == null) {
            this.fluid = SoftFluidRegistry.getEmpty();
        }
    }

    public class_2487 save(class_2487 compound) {
        class_2960 id;
        class_2487 cmp = new class_2487();
        cmp.method_10569("Count", this.count);
        if (this.fluid == null) {
            this.fluid = SoftFluidRegistry.getEmpty();
        }
        if ((id = Utils.getID(this.fluid)) == null) {
            Moonlight.LOGGER.warn("Failed to save fluid in container: {} is not registered", (Object)this.fluid);
            cmp.method_10582("Fluid", SoftFluidRegistry.EMPTY_ID.toString());
        } else {
            cmp.method_10582("Fluid", id.toString());
        }
        cmp.method_10569("CachedColor", this.getTintColor(null, null));
        if (this.nbt != null && !this.nbt.method_33133()) {
            cmp.method_10566("NBT", (class_2520)this.nbt);
        }
        compound.method_10566("FluidHolder", (class_2520)cmp);
        return compound;
    }

    public boolean tryDrinkUpFluid(class_1657 player, class_1937 world) {
        if (!this.isEmpty() && this.containsFood() && this.fluid.getFoodProvider().consume(player, world, this::applyNBTtoItemStack)) {
            this.shrink(1);
            return true;
        }
        return false;
    }

    protected static boolean areNbtEquals(class_2487 nbt, class_2487 nbt1) {
        if ((nbt == null || nbt.method_33133()) && (nbt1 == null || nbt1.method_33133())) {
            return true;
        }
        if (nbt == null || nbt1 == null) {
            return false;
        }
        if (nbt1.method_10545(POTION_TYPE_KEY) && !nbt.method_10545(POTION_TYPE_KEY)) {
            class_2487 n1 = nbt1.method_10553();
            n1.method_10551(POTION_TYPE_KEY);
            return n1.equals((Object)nbt);
        }
        if (nbt.method_10545(POTION_TYPE_KEY) && !nbt1.method_10545(POTION_TYPE_KEY)) {
            class_2487 n = nbt.method_10553();
            n.method_10551(POTION_TYPE_KEY);
            return n.equals((Object)nbt1);
        }
        return nbt1.equals((Object)nbt);
    }

    protected void applyNBTtoItemStack(class_1799 stack) {
        List<String> nbtKey = this.fluid.getNbtKeyFromItem();
        if (this.nbt != null && !this.nbt.method_33133()) {
            class_2487 newCom = new class_2487();
            for (String s : nbtKey) {
                class_2520 c = this.nbt.method_10580(s);
                if (c == null || s.equals(POTION_TYPE_KEY)) continue;
                newCom.method_10566(s, c);
            }
            if (!newCom.method_33133()) {
                stack.method_7980(newCom);
            }
        }
    }

    protected void addPotionTag(class_1792 i, class_2487 com) {
        String type = "REGULAR";
        if (i instanceof class_1828) {
            type = "SPLASH";
        } else if (i instanceof class_1803) {
            type = "LINGERING";
        }
        com.method_10582(POTION_TYPE_KEY, type);
    }

    public static int getLiquidCountFromItem(class_1792 i) {
        if (i == class_1802.field_8469) {
            return 1;
        }
        if (i == class_1802.field_8428) {
            return 2;
        }
        if (i == class_1802.field_8550) {
            return 4;
        }
        return 0;
    }
}

