/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzStructures;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.world.structures.OptimizedJigsawManager;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3785;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;

public class GenericOptimizedStructure
extends class_3195 {
    public static final Codec<GenericOptimizedStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GenericOptimizedStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius)).apply((Applicative)instance, GenericOptimizedStructure::new)).codec();
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int size;
    private final class_6122 startHeight;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    public final Optional<Integer> biomeRadius;

    public GenericOptimizedStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, class_6122 startHeight, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter, Optional<Integer> biomeRadius) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.biomeRadius = biomeRadius;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_1923 chunkpos = context.comp_568();
        int y = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_2338 centerPos = new class_2338(chunkpos.method_8326(), y, chunkpos.method_8328());
        if (this.biomeRadius.isPresent() && !(context.comp_563() instanceof class_1973)) {
            int validBiomeRange = this.biomeRadius.get();
            int sectionY = centerPos.method_10264();
            if (this.projectStartToHeightmap.isPresent()) {
                sectionY += GeneralUtils.getLowestLand(context.comp_562(), context.comp_564(), centerPos, context.comp_569(), true, this.projectStartToHeightmap.get() == class_2902.class_2903.field_13195).method_10264();
            }
            sectionY = class_5742.method_33100((int)sectionY);
            for (int curChunkX = chunkpos.field_9181 - validBiomeRange; curChunkX <= chunkpos.field_9181 + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkpos.field_9180 - validBiomeRange; curChunkZ <= chunkpos.field_9180 + validBiomeRange; ++curChunkZ) {
                    class_6880 biome = context.comp_563().method_38109(class_5742.method_33102((int)curChunkX), sectionY, class_5742.method_33102((int)curChunkZ), context.comp_564().method_42371());
                    if (context.comp_570().test(biome)) continue;
                    return Optional.empty();
                }
            }
        }
        return OptimizedJigsawManager.assembleJigsawStructure(context, this.startPool, this.size, context.comp_561().method_30530(class_2378.field_25915).method_10221((Object)this), centerPos, false, this.projectStartToHeightmap, this.maxDistanceFromCenter, (structurePiecesBuilder, pieces) -> GeneralUtils.centerAllPieces(centerPos, pieces));
    }

    public class_7151<?> method_41618() {
        return BzStructures.GENERIC_OPTIMIZED_STRUCTURE;
    }
}

