/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.processors;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class RandomReplaceWithPropertiesProcessor
extends class_3491 {
    public static final Codec<RandomReplaceWithPropertiesProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2378.field_11146.method_39673().fieldOf("input_block").forGetter(config -> config.inputBlock), (App)class_2378.field_11146.method_39673().optionalFieldOf("output_block").forGetter(config -> config.outputBlock), (App)class_2378.field_11146.method_39673().listOf().optionalFieldOf("output_blocks", (Object)ImmutableList.of()).forGetter(config -> config.outputBlocks), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(config -> Float.valueOf(config.probability))).apply((Applicative)instance, instance.stable(RandomReplaceWithPropertiesProcessor::new)));
    private final class_2248 inputBlock;
    private final Optional<class_2248> outputBlock;
    private final List<class_2248> outputBlocks;
    private final float probability;

    public RandomReplaceWithPropertiesProcessor(class_2248 inputBlock, Optional<class_2248> outputBlock, List<class_2248> outputBlocks, float probability) {
        this.inputBlock = inputBlock;
        this.outputBlock = outputBlock;
        this.outputBlocks = outputBlocks;
        this.probability = probability;
    }

    public class_3499.class_3501 method_15110(class_4538 worldReader, class_2338 pos, class_2338 pos2, class_3499.class_3501 infoIn1, class_3499.class_3501 infoIn2, class_3492 settings) {
        if (infoIn2.field_15596.method_26204() == this.inputBlock) {
            class_2338 worldPos = infoIn2.field_15597;
            class_5819 random = class_5819.method_43047();
            int offSet = settings.method_16182().indexOf((Object)this) + 1;
            random.method_43052(worldPos.method_10063() * worldPos.method_10063() * (long)offSet);
            if (random.method_43057() < this.probability) {
                if (this.outputBlock.isPresent()) {
                    class_2680 newBlockState = this.outputBlock.get().method_9564();
                    for (class_2769 property : infoIn2.field_15596.method_28501()) {
                        if (!newBlockState.method_28498(property)) continue;
                        newBlockState = this.getStateWithProperty(newBlockState, infoIn2.field_15596, property);
                    }
                    return new class_3499.class_3501(infoIn2.field_15597, newBlockState, infoIn2.field_15595);
                }
                if (!this.outputBlocks.isEmpty()) {
                    class_2680 newBlockState = this.outputBlocks.get(random.method_43048(this.outputBlocks.size())).method_9564();
                    for (class_2769 property : infoIn2.field_15596.method_28501()) {
                        if (!newBlockState.method_28498(property)) continue;
                        newBlockState = this.getStateWithProperty(newBlockState, infoIn2.field_15596, property);
                    }
                    return new class_3499.class_3501(infoIn2.field_15597, newBlockState, infoIn2.field_15595);
                }
                Bumblezone.LOGGER.warn("The Bumblezone: the_bumblezone:random_replace_with_properties_processor in a processor file has no replacement block of any kind.");
            }
        }
        return infoIn2;
    }

    private <T extends Comparable<T>> class_2680 getStateWithProperty(class_2680 state, class_2680 stateToCopy, class_2769<T> property) {
        return (class_2680)state.method_11657(property, stateToCopy.method_11654(property));
    }

    protected class_3828<?> method_16772() {
        return BzProcessors.RANDOM_REPLACE_WITH_PROPERTIES_PROCESSOR;
    }
}

