/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.items.functions.PrefillMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.server.MinecraftServer;

public class ThreadExecutor {
    private static ExecutorService LOCATING_EXECUTOR_SERVICE = null;
    private static final AtomicInteger runningSearches = new AtomicInteger(0);
    private static final AtomicInteger queuedSearches = new AtomicInteger(0);

    private static void setupExecutorService() {
        ThreadExecutor.shutdownExecutorService();
        LOCATING_EXECUTOR_SERVICE = Executors.newFixedThreadPool(3, new ThreadFactory(){
            private static final AtomicInteger poolNum = new AtomicInteger(1);
            private final AtomicInteger threadNum = new AtomicInteger(1);
            private final String namePrefix = "bumblezone_locator_and_teleportation-" + poolNum.getAndIncrement() + "-thread-";

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, this.namePrefix + this.threadNum.getAndIncrement());
            }
        });
    }

    private static void shutdownExecutorService() {
        if (LOCATING_EXECUTOR_SERVICE != null) {
            LOCATING_EXECUTOR_SERVICE.shutdown();
        }
    }

    public static void handleServerAboutToStartEvent() {
        ThreadExecutor.setupExecutorService();
    }

    public static void handleServerStoppingEvent() {
        ThreadExecutor.shutdownExecutorService();
    }

    public static boolean isRunningASearch() {
        return runningSearches.get() > 0;
    }

    public static boolean hasQueuedSearch() {
        return queuedSearches.get() > 0;
    }

    public static LocateTask<class_2338> locate(class_3218 level, class_6862<class_3195> structureTag, class_2338 pos, int searchRadius, boolean skipKnownStructures) {
        queuedSearches.getAndIncrement();
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> {
            try {
                runningSearches.getAndIncrement();
                queuedSearches.getAndDecrement();
                ThreadExecutor.doLocateLevel((CompletableFuture<class_2338>)completableFuture, level, structureTag, pos, searchRadius, skipKnownStructures);
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Off thread structure locating crashed. Exception is: ", (Throwable)e);
            }
        });
        return new LocateTask<class_2338>(level.method_8503(), completableFuture, future);
    }

    public static LocateTask<class_2338> locate(class_3218 level, class_5321<class_3195> structureKey, class_2338 pos, int searchRadius, boolean skipKnownStructures) {
        queuedSearches.getAndIncrement();
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> {
            try {
                runningSearches.getAndIncrement();
                queuedSearches.getAndDecrement();
                ThreadExecutor.doLocateLevel((CompletableFuture<class_2338>)completableFuture, level, structureKey, pos, searchRadius, skipKnownStructures);
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Off thread structure locating crashed. Exception is: ", (Throwable)e);
            }
        });
        return new LocateTask<class_2338>(level.method_8503(), completableFuture, future);
    }

    public static LocateTask<Optional<class_243>> dimensionDestinationSearch(MinecraftServer minecraftServer, Supplier<Optional<class_243>> searchFunction) {
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> {
            try {
                completableFuture.complete((Optional)searchFunction.get());
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Off thread teleport destination search crashed. Exception is: ", (Throwable)e);
            }
        });
        return new LocateTask<Optional<class_243>>(minecraftServer, completableFuture, future);
    }

    private static void doLocateLevel(CompletableFuture<class_2338> completableFuture, class_3218 level, class_6862<class_3195> structureTag, class_2338 pos, int searchRadius, boolean skipExistingChunks) {
        class_2338 foundPos = level.method_8487(structureTag, pos, searchRadius, skipExistingChunks);
        completableFuture.complete(foundPos);
        runningSearches.getAndDecrement();
    }

    private static void doLocateLevel(CompletableFuture<class_2338> completableFuture, class_3218 level, class_5321<class_3195> structureKey, class_2338 pos, int searchRadius, boolean skipExistingChunks) {
        class_2378 structureRegistry = level.method_30349().method_30530(class_2378.field_25915);
        Pair foundPos = level.method_14178().method_12129().method_12103(level, (class_6885)class_6885.method_40246((class_6880[])new class_6880[]{(class_6880)structureRegistry.method_40264(structureKey).get()}), pos, searchRadius, skipExistingChunks);
        completableFuture.complete(foundPos != null ? (class_2338)foundPos.getFirst() : null);
        runningSearches.getAndDecrement();
    }

    public static void mapFilling(class_3218 level, class_2338 pos, class_22 data) {
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> {
            try {
                PrefillMap.update((class_1937)level, pos, data);
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Off thread map filling crashed. Exception is: ", (Throwable)e);
            }
        });
        new LocateTask(level.method_8503(), completableFuture, future);
    }

    public record LocateTask<T>(MinecraftServer server, CompletableFuture<T> completableFuture, Future<?> taskFuture) {
        public LocateTask<T> then(Consumer<T> action) {
            this.completableFuture.thenAccept((Consumer)action);
            return this;
        }

        public LocateTask<T> thenOnServerThread(Consumer<T> action) {
            this.completableFuture.thenAccept(pos -> this.server.method_20493(() -> action.accept(pos)));
            return this;
        }

        public void cancel() {
            this.taskFuture.cancel(true);
            this.completableFuture.cancel(false);
        }
    }
}

