/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_3218;
import net.minecraft.class_3443;
import net.minecraft.class_3468;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3853;
import net.minecraft.class_4466;
import net.minecraft.class_4538;
import net.minecraft.class_4966;
import net.minecraft.class_5000;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_7138;

public class GeneralUtils {
    private static int ACTIVE_ENTITIES = 0;
    private static final Set<class_4466> BEE_SET = new HashSet<class_4466>();
    public static final List<class_2680> VANILLA_CANDLES = ImmutableList.of((Object)class_2246.field_27099.method_9564(), (Object)class_2246.field_27109.method_9564(), (Object)class_2246.field_27141.method_9564(), (Object)class_2246.field_27111.method_9564(), (Object)class_2246.field_27112.method_9564(), (Object)class_2246.field_27107.method_9564(), (Object)class_2246.field_27113.method_9564(), (Object)class_2246.field_27103.method_9564(), (Object)class_2246.field_27108.method_9564(), (Object)class_2246.field_27105.method_9564(), (Object)class_2246.field_27102.method_9564(), (Object)class_2246.field_27101.method_9564(), (Object[])new class_2680[]{class_2246.field_27106.method_9564(), class_2246.field_27110.method_9564(), class_2246.field_27140.method_9564(), class_2246.field_27100.method_9564(), class_2246.field_27104.method_9564()});

    public static void updateEntityCount(class_3218 world) {
        BEE_SET.clear();
        int counter = 0;
        for (class_1297 entity : world.method_27909()) {
            if (entity.method_5805() && entity instanceof class_1309) {
                ++counter;
            }
            if (!(entity instanceof class_4466)) continue;
            BEE_SET.add((class_4466)entity);
        }
        ACTIVE_ENTITIES = counter;
        BEE_SET.removeIf(bee -> bee.method_5947() || bee.method_21791() || bee.method_16914() || bee.method_5934() || bee.method_5782());
    }

    public static int getNearbyActiveEntitiesInDimension(class_3218 level, class_2338 position) {
        if (level.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            return ACTIVE_ENTITIES;
        }
        return level.method_18467(class_4466.class, new class_238(position.method_10069(-16, -16, -16), position.method_10069(16, 16, 16))).size();
    }

    public static void adjustEntityCountInBz(int adjust) {
        ACTIVE_ENTITIES += adjust;
    }

    public static Set<class_4466> getAllWildBees() {
        return BEE_SET;
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, class_5819 random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.method_43057() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static class_2338 getRandomBlockposWithinRange(class_1309 entity, int maxRadius, int minRadius) {
        class_2338 newBeePos = new class_2338(entity.method_23317() + (double)((entity.method_6051().method_43048(maxRadius) + minRadius) * (entity.method_6051().method_43056() ? 1 : -1)), Doubles.constrainToRange((double)(entity.method_23318() + (double)((entity.method_6051().method_43048(maxRadius) + minRadius) * (entity.method_6051().method_43056() ? 1 : -1))), (double)1.0, (double)254.0), entity.method_23321() + (double)((entity.method_6051().method_43048(maxRadius) + minRadius) * (entity.method_6051().method_43056() ? 1 : -1)));
        return newBeePos;
    }

    public static void givePlayerItem(class_1657 playerEntity, class_1268 hand, class_1799 itemstackToGive, boolean giveContainerItem, boolean shrinkCurrentItem) {
        if (playerEntity.field_6002.method_8608()) {
            return;
        }
        class_1799 playerItem = playerEntity.method_5998(hand);
        class_1799 copiedPlayerItem = playerItem.method_7972();
        boolean instabuild = playerEntity.method_31549().field_7477;
        if (!playerItem.method_7960()) {
            playerEntity.method_7259(class_3468.field_15372.method_14956((Object)playerItem.method_7909()));
        }
        if (!instabuild && shrinkCurrentItem) {
            playerItem.method_7934(1);
        }
        if (!itemstackToGive.method_7960()) {
            if (playerItem.method_7960()) {
                playerEntity.method_6122(hand, itemstackToGive);
            } else if (instabuild) {
                if (!playerEntity.method_31548().method_7379(itemstackToGive)) {
                    playerEntity.method_31548().method_7394(itemstackToGive);
                }
            } else if (!playerEntity.method_31548().method_7394(itemstackToGive)) {
                playerEntity.method_7328(itemstackToGive, false);
            }
        }
        if (giveContainerItem && copiedPlayerItem.method_7909().method_7857()) {
            class_1799 containerItem = copiedPlayerItem.method_7909().method_7858().method_7854();
            if (playerEntity.method_5998(hand).method_7960()) {
                playerEntity.method_6122(hand, containerItem);
            } else if (instabuild) {
                if (!playerEntity.method_31548().method_7379(containerItem)) {
                    playerEntity.method_31548().method_7394(containerItem);
                }
            } else if (!playerEntity.method_31548().method_7394(containerItem)) {
                playerEntity.method_7328(containerItem, false);
            }
        }
    }

    public static boolean canJigsawsAttach(class_3499.class_3501 jigsaw1, class_3499.class_3501 jigsaw2) {
        class_5000 prop1 = (class_5000)jigsaw1.field_15596.method_11654((class_2769)class_3748.field_23262);
        class_5000 prop2 = (class_5000)jigsaw2.field_15596.method_11654((class_2769)class_3748.field_23262);
        String joint = jigsaw1.field_15595.method_10558("joint");
        if (joint.isEmpty()) {
            joint = prop1.method_26426().method_10166().method_10179() ? "aligned" : "rollable";
        }
        boolean isRollable = joint.equals("rollable");
        return prop1.method_26426() == prop2.method_26426().method_10153() && (isRollable || prop1.method_26428() == prop2.method_26428()) && jigsaw1.field_15595.method_10558("target").equals(jigsaw2.field_15595.method_10558("name"));
    }

    public static int getFirstLandYFromPos(class_4538 worldView, class_2338 pos) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        mutable.method_10101((class_2382)pos);
        class_2791 currentChunk = worldView.method_22350((class_2338)mutable);
        class_2680 currentState = currentChunk.method_8320((class_2338)mutable);
        while (mutable.method_10264() >= worldView.method_31607() && GeneralUtils.isReplaceableByStructures(currentState)) {
            mutable.method_10098(class_2350.field_11033);
            currentState = currentChunk.method_8320((class_2338)mutable);
        }
        return mutable.method_10264();
    }

    private static boolean isReplaceableByStructures(class_2680 blockState) {
        return blockState.method_26215() || blockState.method_26207().method_15797() || blockState.method_26207().method_15800() || blockState.method_27852(BzBlocks.HONEY_CRYSTAL);
    }

    public static class_2338 getLowestLand(class_2794 chunkGenerator, class_7138 randomState, class_2338 centerPos, class_5539 heightLimitView, boolean canBeOnLiquid, boolean canBeInLiquid) {
        class_2680 currentBlockstate;
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10103(centerPos.method_10263(), 1, centerPos.method_10260());
        class_4966 blockView = chunkGenerator.method_26261(mutable.method_10263(), mutable.method_10260(), heightLimitView, randomState);
        class_2680 pastBlockstate = currentBlockstate = blockView.method_32892(mutable.method_10264());
        while (mutable.method_10264() <= GeneralUtils.getMaxTerrainLimit(chunkGenerator)) {
            if (canBeInLiquid && !currentBlockstate.method_26227().method_15769()) {
                mutable.method_10098(class_2350.field_11036);
                return mutable;
            }
            if ((canBeOnLiquid || !pastBlockstate.method_26227().method_15769()) && currentBlockstate.method_26215()) {
                mutable.method_10098(class_2350.field_11036);
                return mutable;
            }
            mutable.method_10098(class_2350.field_11036);
            pastBlockstate = currentBlockstate;
            currentBlockstate = blockView.method_32892(mutable.method_10264());
        }
        return mutable;
    }

    public static int getMaxTerrainLimit(class_2794 chunkGenerator) {
        return chunkGenerator.method_33730() + chunkGenerator.method_12104();
    }

    public static void spawnItemEntity(class_3218 serverLevel, class_2338 blockPos, class_1799 itemToSpawn, double randomXZSpeed, double ySpeed) {
        if (!itemToSpawn.method_7960()) {
            class_1542 itemEntity = new class_1542((class_1937)serverLevel, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 1.0, (double)blockPos.method_10260() + 0.5, itemToSpawn);
            itemEntity.method_18799(new class_243(serverLevel.field_9229.method_43059() * randomXZSpeed, ySpeed, serverLevel.field_9229.method_43059() * randomXZSpeed));
            itemEntity.method_6988();
            serverLevel.method_8649((class_1297)itemEntity);
        }
    }

    public static void centerAllPieces(class_2338 targetPos, List<? extends class_3443> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        class_2338 structureCenter = pieces.get(0).method_14935().method_22874();
        int xOffset = targetPos.method_10263() - structureCenter.method_10263();
        int zOffset = targetPos.method_10260() - structureCenter.method_10260();
        for (class_3443 class_34432 : pieces) {
            class_34432.method_14922(xOffset, 0, zOffset);
        }
    }

    public static int split(int value, boolean upper) {
        return upper ? value >> 16 : value & 0xFFFF;
    }

    public static int merge(int upper, int lower) {
        return (upper << 16) + (lower & 0xFFFF);
    }

    public static boolean isBlockAllowedForSugarWaterWaterlogging(class_2680 blockState) {
        return blockState.method_26164(BzTags.WATERLOGGABLE_BLOCKS_WHEN_PLACED_IN_FLUID) && !blockState.method_26164(BzTags.FORCED_DISALLOW_WATERLOGGING_BLOCKS_WHEN_PLACED_IN_FLUID);
    }

    public static boolean isPermissionAllowedAtSpot(class_1937 level, class_1297 entity, class_2338 pos, boolean placingBlock) {
        class_1657 player;
        if (entity instanceof class_1657 && !(player = (class_1657)entity).method_36971(level, pos)) {
            return false;
        }
        if (entity instanceof class_1657) {
            player = (class_1657)entity;
            return ((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak(level, player, pos, level.method_8320(pos), null);
        }
        return true;
    }

    public static class BasicItemTrade
    implements class_3853.class_1652 {
        private final class_1792 itemToTrade;
        private final class_1792 itemToReceive;
        private final int amountToGive;
        private final int amountToReceive;
        protected final int maxUses;
        protected final int experience;
        protected final float multiplier;

        public BasicItemTrade(class_1792 itemToTrade, class_1792 itemToReceive, int amountToGive, int amountToReceive) {
            this(itemToReceive, itemToTrade, amountToGive, amountToReceive, 20, 2, 0.05f);
        }

        public BasicItemTrade(class_1792 itemToTrade, class_1792 itemToReceive, int amountToGive, int amountToReceive, int maxUses, int experience, float multiplier) {
            this.itemToTrade = itemToTrade;
            this.itemToReceive = itemToReceive;
            this.amountToGive = amountToGive;
            this.amountToReceive = amountToReceive;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            class_1799 in = new class_1799((class_1935)this.itemToTrade, this.amountToGive);
            class_1799 out = new class_1799((class_1935)this.itemToReceive, this.amountToReceive);
            return new class_1914(in, out, this.maxUses, this.experience, this.multiplier);
        }
    }

    public static final class Lazy<T> {
        private volatile T value;

        public T getOrCompute(Supplier<T> supplier) {
            T result = this.value;
            return result == null ? this.maybeCompute(supplier) : result;
        }

        private synchronized T maybeCompute(Supplier<T> supplier) {
            if (this.value == null) {
                this.value = Objects.requireNonNull(supplier.get());
            }
            return this.value;
        }
    }
}

