/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modcompat.BackpackedCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.FriendsAndFoesCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.GoodallCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ProjectileDamageAttributeCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.TrinketsCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.TwilightForestCompat;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.Level;

public class ModChecker {
    public static boolean potionOfBeesPresent = false;
    public static boolean strangePresent = false;
    public static boolean friendsAndFoesPresent = false;
    public static boolean twilightForestPresent = false;
    public static boolean TrinketsPresent = false;
    public static boolean goodallPresent = false;
    public static boolean backpackedPresent = false;
    public static boolean projectileDamageAttributePresent = false;

    public static void setupModCompat() {
        String currentModID = "";
        try {
            currentModID = "friendsandfoes";
            ModChecker.loadupModCompat(currentModID, () -> FriendsAndFoesCompat.setupCompat());
            currentModID = "twilightforest";
            ModChecker.loadupModCompat(currentModID, () -> TwilightForestCompat.setupCompat());
            currentModID = "trinkets";
            ModChecker.loadupModCompat(currentModID, () -> TrinketsCompat.setupCompat());
            currentModID = "goodall";
            ModChecker.loadupModCompat(currentModID, () -> GoodallCompat.setupCompat());
            currentModID = "backpacked";
            ModChecker.loadupModCompat(currentModID, () -> BackpackedCompat.setupCompat());
            currentModID = "projectile_damage";
            ModChecker.loadupModCompat(currentModID, () -> ProjectileDamageAttributeCompat.setupCompat());
        }
        catch (Exception e) {
            ModChecker.printErrorToLogs("classloading " + currentModID + " and so, mod compat done afterwards broke");
            e.printStackTrace();
        }
    }

    private static void loadupModCompat(String modid, Runnable runnable) {
        try {
            if (FabricLoader.getInstance().isModLoaded(modid)) {
                runnable.run();
            }
        }
        catch (Throwable e) {
            ModChecker.printErrorToLogs(modid);
            e.printStackTrace();
        }
    }

    private static void printErrorToLogs(String currentModID) {
        Bumblezone.LOGGER.log(Level.ERROR, "  ------------------------------------------------NOTICE-------------------------------------------------------------------------\n\n  ERROR: Something broke when trying to add mod compatibility with %s. Please let The Bumblezone developer (TelepathicGrunt) know about this!\n\n  ------------------------------------------------NOTICE-------------------------------------------------------------------------\n".formatted(currentModID));
    }
}

