/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.items.recipes.IncenseCandleRecipe;
import com.telepathicgrunt.the_bumblezone.modcompat.FakeIncenseCandleRecipeCreator;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.RandomizeTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.JEIQueenRandomizerTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.JEIQueenTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.QueenRandomizeTradesJEICategory;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.QueenTradesJEICategory;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3955;
import net.minecraft.class_6012;
import net.minecraft.class_638;
import net.minecraft.class_6862;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    public static final RecipeType<JEIQueenTradesInfo> QUEEN_TRADES = RecipeType.create((String)"the_bumblezone", (String)"queen_trades", JEIQueenTradesInfo.class);
    public static final RecipeType<JEIQueenRandomizerTradesInfo> QUEEN_RANDOMIZE_TRADES = RecipeType.create((String)"the_bumblezone", (String)"queen_color_randomizer_trades", JEIQueenRandomizerTradesInfo.class);

    public class_2960 getPluginUid() {
        return new class_2960("the_bumblezone", "jei_plugin");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        BzItems.CUSTOM_CREATIVE_TAB_ITEMS.forEach(item -> JEIIntegration.addInfo(registration, item));
        JEIIntegration.addInfo(registration, BzItems.PILE_OF_POLLEN);
        JEIIntegration.addInfo(registration, (class_3611)BzFluids.SUGAR_WATER_FLUID);
        JEIIntegration.addInfo(registration, (class_3611)BzFluids.ROYAL_JELLY_FLUID);
        JEIIntegration.addInfo(registration, (class_3611)BzFluids.HONEY_FLUID);
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        level.method_8433().method_8130(new class_2960("the_bumblezone", "incense_candle_from_super_candles")).ifPresent(recipe -> JEIIntegration.registerExtraRecipes(recipe, registration, true));
        level.method_8433().method_8130(new class_2960("the_bumblezone", "incense_candle")).ifPresent(recipe -> JEIIntegration.registerExtraRecipes(recipe, registration, false));
        LinkedList<JEIQueenTradesInfo> trades = new LinkedList<JEIQueenTradesInfo>();
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades.isEmpty()) {
            for (Pair<MainTradeRowInput, class_6012<WeightedTradeResult>> trade : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades) {
                for (WeightedTradeResult weightedTradeResult : ((class_6012)trade.getSecond()).method_34994()) {
                    trades.add(new JEIQueenTradesInfo((MainTradeRowInput)trade.getFirst(), weightedTradeResult));
                }
            }
        }
        registration.addRecipes(QUEEN_TRADES, trades);
        LinkedList<JEIQueenRandomizerTradesInfo> randomizerTrades = new LinkedList<JEIQueenRandomizerTradesInfo>();
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades.isEmpty()) {
            for (RandomizeTradeRowInput tradeEntry : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades) {
                List<class_1799> randomizeStack = tradeEntry.getWantItems().method_40239().map(e -> ((class_1792)e.comp_349()).method_7854()).toList();
                for (class_1799 input : randomizeStack) {
                    randomizerTrades.add(new JEIQueenRandomizerTradesInfo(input, (class_6862<class_1792>)((class_6862)tradeEntry.tagKey().orElse(null)), randomizeStack));
                }
            }
        }
        registration.addRecipes(QUEEN_RANDOMIZE_TRADES, randomizerTrades);
    }

    private static void addInfo(IRecipeRegistration registration, class_1792 item) {
        registration.addIngredientInfo((Object)new class_1799((class_1935)item), (IIngredientType)VanillaTypes.ITEM_STACK, new class_2561[]{class_2561.method_43471((String)("the_bumblezone." + class_2378.field_11142.method_10221((Object)item).method_12832() + ".description"))});
    }

    private static void addInfo(IRecipeRegistration registration, class_3611 fluid) {
        registration.addIngredientInfo((Object)new FluidStack(fluid, 1), (IIngredientType)FabricTypes.FLUID_STACK, new class_2561[]{class_2561.method_43471((String)("the_bumblezone." + class_2378.field_11154.method_10221((Object)fluid).method_12832() + ".description"))});
    }

    private static void registerExtraRecipes(class_1860<?> baseRecipe, IRecipeRegistration registration, boolean oneRecipeOnly) {
        if (baseRecipe instanceof IncenseCandleRecipe) {
            IncenseCandleRecipe incenseCandleRecipe = (IncenseCandleRecipe)baseRecipe;
            List<class_3955> extraRecipes = FakeIncenseCandleRecipeCreator.constructFakeRecipes(incenseCandleRecipe, oneRecipeOnly);
            registration.addRecipes(RecipeTypes.CRAFTING, extraRecipes);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new QueenTradesJEICategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new QueenRandomizeTradesJEICategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(BzItems.BEE_QUEEN_SPAWN_EGG.method_7854(), new RecipeType[]{QUEEN_TRADES});
        registration.addRecipeCatalyst(BzItems.BEE_QUEEN_SPAWN_EGG.method_7854(), new RecipeType[]{QUEEN_RANDOMIZE_TRADES});
    }

    private static class FluidStack
    implements IJeiFluidIngredient {
        private final class_3611 fluid;
        private final int count;

        private FluidStack(class_3611 fluid, int count) {
            this.fluid = fluid;
            this.count = count;
        }

        public class_3611 getFluid() {
            return this.fluid;
        }

        public long getAmount() {
            return this.count;
        }

        public Optional<class_2487> getTag() {
            return Optional.empty();
        }
    }
}

