/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.mixin.entities;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.telepathicgrunt.the_bumblezone.components.MiscComponent;
import com.telepathicgrunt.the_bumblezone.effects.HiddenEffect;
import com.telepathicgrunt.the_bumblezone.effects.ParalyzedEffect;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.the_bumblezone.enchantments.NeurotoxinsEnchantment;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.EntityTeleportationHookup;
import com.telepathicgrunt.the_bumblezone.fluids.HoneyFluid;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Shadow
    protected class_1799 field_6277;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @ModifyReturnValue(method={"isImmobile()Z"}, at={@At(value="RETURN")})
    private boolean thebumblezone_isParalyzedCheck(boolean isImmobile) {
        if (!isImmobile && ParalyzedEffect.isParalyzed((class_1309)this)) {
            return true;
        }
        return isImmobile;
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")})
    private void thebumblezone_entityHurt(class_1282 source, float pAmount, CallbackInfoReturnable<Boolean> cir) {
        NeurotoxinsEnchantment.entityHurt(this, source);
    }

    @Inject(method={"actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V"}, at={@At(value="HEAD")})
    private void thebumblezone_onEntityDamaged(class_1282 source, float amount, CallbackInfo ci) {
        BeeAggression.beeHitAndAngered((class_1297)((class_1309)this), source.method_5529());
    }

    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="HEAD")})
    private void thebumblezone_onDeath(class_1282 source, CallbackInfo ci) {
        WrathOfTheHiveEffect.calmTheBees(this.field_6002, (class_1309)this);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void thebumblezone_onLivingEntityTick(CallbackInfo ci) {
        EntityTeleportationHookup.entityTick((class_1309)this);
    }

    @ModifyReturnValue(method={"getVisibilityPercent(Lnet/minecraft/world/entity/Entity;)D"}, at={@At(value="RETURN")})
    private double thebumblezone_hideEntityWithHiddenEffect(double currentVisibility, class_1297 entity) {
        double newVisibility = HiddenEffect.hideEntity(entity, currentVisibility);
        if (currentVisibility != newVisibility) {
            return newVisibility;
        }
        return currentVisibility;
    }

    @Inject(method={"completeUsingItem()V"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/item/ItemStack;finishUsingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;")})
    private void thebumblezone_onHoneyBottleFinish(CallbackInfo ci) {
        MiscComponent.onHoneyBottleDrank((class_1309)this, this.field_6277);
    }

    @Inject(method={"baseTick()V"}, at={@At(value="TAIL")})
    private void thebumblezone_breathing(CallbackInfo ci) {
        HoneyFluid.breathing((class_1309)this);
    }

    @WrapOperation(method={"aiStep()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getFluidHeight(Lnet/minecraft/tags/TagKey;)D", ordinal=1)}, require=0)
    private double thebumblezone_customFluidJumpWeaker(class_1309 livingEntity, class_6862<class_3611> tagKey, Operation<Double> original) {
        double newFluidHeight = this.method_5861(BzTags.SPECIAL_HONEY_LIKE);
        if (newFluidHeight > 0.0) {
            return newFluidHeight;
        }
        newFluidHeight = this.method_5861(BzTags.SUGAR_WATER_FLUID);
        if (newFluidHeight > 0.0) {
            return newFluidHeight;
        }
        return (Double)original.call(new Object[]{livingEntity, tagKey});
    }
}

