/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.IncenseCandleBlockEntity;
import com.telepathicgrunt.the_bumblezone.mixin.containers.ShapedRecipeAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzRecipes;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2CharOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5321;

public class IncenseCandleRecipe
implements class_3955,
class_1865<IncenseCandleRecipe> {
    private final class_2960 id;
    private final String group;
    private final int outputCount;
    private final int maxAllowedPotions;
    private final class_2371<class_1856> shapedRecipeItems;
    private final class_2371<class_1856> shapelessRecipeItems;
    private final class_1799 result;
    private final int width;
    private final int height;
    private final boolean allowNormalPotions;
    private final boolean allowSplashPotions;
    private final boolean allowLingeringPotions;
    private final int maxLevelCap;

    public IncenseCandleRecipe(class_2960 id, String group, int outputCount, int maxAllowedPotions, class_2371<class_1856> shapedRecipeItems, class_2371<class_1856> shapelessRecipeItems, int width, int height, boolean allowNormalPotions, boolean allowSplashPotions, boolean allowLingeringPotions, int maxLevelCap) {
        this.id = id;
        this.group = group;
        this.outputCount = outputCount;
        this.maxAllowedPotions = maxAllowedPotions;
        this.shapedRecipeItems = shapedRecipeItems;
        this.shapelessRecipeItems = shapelessRecipeItems;
        this.result = IncenseCandleRecipe.getResultStack(outputCount);
        this.width = width;
        this.height = height;
        this.allowNormalPotions = allowNormalPotions;
        this.allowSplashPotions = allowSplashPotions;
        this.allowLingeringPotions = allowLingeringPotions;
        this.maxLevelCap = maxLevelCap;
    }

    public int getMaxAllowedPotions() {
        return this.maxAllowedPotions;
    }

    public boolean getAllowNormalPotions() {
        return this.allowNormalPotions;
    }

    public boolean getAllowSplashPotions() {
        return this.allowSplashPotions;
    }

    public boolean getAllowLingeringPotions() {
        return this.allowLingeringPotions;
    }

    public int getMaxLevelCap() {
        return this.maxLevelCap;
    }

    public class_2371<class_1856> getShapedRecipeItems() {
        return this.shapedRecipeItems;
    }

    public class_2371<class_1856> getShapelessRecipeItems() {
        return this.shapelessRecipeItems;
    }

    private static class_1799 getResultStack(int outputCountIn) {
        class_1799 stack = BzItems.INCENSE_CANDLE.method_7854();
        stack.method_7939(outputCountIn);
        return stack;
    }

    public class_1799 assemble(class_1715 inv) {
        ArrayList effects = new ArrayList();
        AtomicInteger maxDuration = new AtomicInteger();
        AtomicInteger amplifier = new AtomicInteger();
        AtomicInteger potionEffectsFound = new AtomicInteger();
        int splashCount = 0;
        int lingerCount = 0;
        for (int j = 0; j < inv.method_5439(); ++j) {
            class_1799 itemStack = inv.method_5438(j);
            if (!itemStack.method_31574(class_1802.field_8574) && !itemStack.method_31574(class_1802.field_8436) && !itemStack.method_31574(class_1802.field_8150)) continue;
            class_1844.method_8067((class_1799)itemStack).forEach(me -> {
                effects.add(me.method_5579());
                maxDuration.addAndGet(me.method_5579().method_5561() ? 200 : me.method_5584());
                amplifier.addAndGet(me.method_5578() + 1);
                potionEffectsFound.getAndIncrement();
            });
            if (itemStack.method_31574(class_1802.field_8436)) {
                ++splashCount;
            }
            if (!itemStack.method_31574(class_1802.field_8150)) continue;
            ++lingerCount;
        }
        if (effects.isEmpty()) {
            return IncenseCandleRecipe.getResultStack(this.outputCount);
        }
        HashSet setPicker = new HashSet(effects);
        List<class_1291> filteredMobEffects = setPicker.stream().filter(e -> !class_2378.field_11159.method_40290((class_5321)class_2378.field_11159.method_29113(e).orElseThrow()).method_40220(BzTags.DISALLOWED_INCENSE_CANDLE_EFFECTS)).toList();
        class_1291 chosenEffect = filteredMobEffects.get(new Random().nextInt(filteredMobEffects.size()));
        if (chosenEffect == null) {
            return IncenseCandleRecipe.getResultStack(this.outputCount);
        }
        IncenseCandleRecipe.balanceStats(chosenEffect, maxDuration, amplifier, potionEffectsFound);
        amplifier.set(Math.min(amplifier.get(), this.maxLevelCap));
        return IncenseCandleRecipe.createTaggedIncenseCandle(chosenEffect, maxDuration, amplifier, splashCount, lingerCount, this.outputCount);
    }

    public static void balanceStats(class_1291 chosenEffect, AtomicInteger maxDuration, AtomicInteger amplifier, AtomicInteger potionEffectsFound) {
        amplifier.set(amplifier.get() / potionEffectsFound.get());
        float durationBaseMultiplier = 0.4f / (0.9f * (float)potionEffectsFound.get()) + (float)amplifier.get() * 0.22f;
        float durationAdjustment = (float)potionEffectsFound.get() * durationBaseMultiplier;
        maxDuration.set((int)((float)maxDuration.get() / durationAdjustment));
        if (chosenEffect.method_5561()) {
            long thresholdTime = IncenseCandleBlockEntity.getInstantEffectThresholdTime(amplifier.intValue());
            int activationAmounts = (int)Math.ceil((double)maxDuration.intValue() / (double)thresholdTime);
            maxDuration.set((int)((long)activationAmounts * thresholdTime));
        }
    }

    public static class_1799 createTaggedIncenseCandle(class_1291 chosenEffect, AtomicInteger maxDuration, AtomicInteger amplifier, int splashCount, int lingerCount, int outputCount) {
        class_1799 resultStack = IncenseCandleRecipe.getResultStack(outputCount);
        class_2487 tag = resultStack.method_7948();
        class_2487 blockEntityTag = new class_2487();
        tag.method_10566("BlockEntityTag", (class_2520)blockEntityTag);
        blockEntityTag.method_10569(IncenseCandleBlockEntity.COLOR_TAG, chosenEffect.method_5556());
        blockEntityTag.method_10569(IncenseCandleBlockEntity.AMPLIFIER_TAG, amplifier.intValue());
        blockEntityTag.method_10569(IncenseCandleBlockEntity.MAX_DURATION_TAG, maxDuration.intValue());
        blockEntityTag.method_10582(IncenseCandleBlockEntity.STATUS_EFFECT_TAG, class_2378.field_11159.method_10221((Object)chosenEffect).toString());
        blockEntityTag.method_10556(IncenseCandleBlockEntity.INFINITE_TAG, false);
        blockEntityTag.method_10569(IncenseCandleBlockEntity.RANGE_TAG, 3 + splashCount * 2);
        if (chosenEffect.method_5561()) {
            blockEntityTag.method_10569(IncenseCandleBlockEntity.LINGER_TIME_TAG, 1);
        } else if (chosenEffect == class_1294.field_5925) {
            IncenseCandleRecipe.setLingerTime(lingerCount, blockEntityTag, 240);
        } else {
            IncenseCandleRecipe.setLingerTime(lingerCount, blockEntityTag, 60);
        }
        return resultStack;
    }

    private static void setLingerTime(int lingerCount, class_2487 blockEntityTag, int baseLingerTime) {
        blockEntityTag.method_10569(IncenseCandleBlockEntity.LINGER_TIME_TAG, baseLingerTime + lingerCount * baseLingerTime * 2);
    }

    public boolean method_8113(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getRecipeWidth() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.height;
    }

    public int getRecipeHeight() {
        return this.getHeight();
    }

    public class_1799 method_8110() {
        return this.result;
    }

    public boolean matches(class_1715 inv, class_1937 level) {
        boolean shapedMatch = false;
        for (int column = 0; column <= inv.method_17398() - this.width; ++column) {
            for (int row = 0; row <= inv.method_17397() - this.height; ++row) {
                if (this.matches(inv, column, row, true)) {
                    shapedMatch = true;
                }
                if (!this.matches(inv, column, row, false)) continue;
                shapedMatch = true;
            }
        }
        return shapedMatch;
    }

    private boolean matches(class_1715 craftingInventory, int width, int height, boolean mirrored) {
        int potionCount = 0;
        ObjectArrayList stackList = new ObjectArrayList();
        ObjectArrayList mobEffects = new ObjectArrayList();
        for (int column = 0; column < craftingInventory.method_17398(); ++column) {
            for (int row = 0; row < craftingInventory.method_17397(); ++row) {
                class_1799 itemStack = craftingInventory.method_5438(column + row * craftingInventory.method_17398());
                int k = column - width;
                int l = row - height;
                class_1856 ingredient = null;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = mirrored ? (class_1856)this.shapedRecipeItems.get(this.width - k - 1 + l * this.width) : (class_1856)this.shapedRecipeItems.get(k + l * this.width);
                }
                if (ingredient == null) {
                    if (itemStack.method_7960()) continue;
                    if (itemStack.method_31574(class_1802.field_8574) || itemStack.method_31574(class_1802.field_8436) || itemStack.method_31574(class_1802.field_8150)) {
                        if (itemStack.method_31574(class_1802.field_8574) && !this.allowNormalPotions) {
                            return false;
                        }
                        if (itemStack.method_31574(class_1802.field_8436) && !this.allowSplashPotions) {
                            return false;
                        }
                        if (itemStack.method_31574(class_1802.field_8150) && !this.allowLingeringPotions) {
                            return false;
                        }
                        List currentMobEffects = class_1844.method_8067((class_1799)itemStack);
                        mobEffects.addAll(currentMobEffects);
                        if (currentMobEffects.isEmpty()) {
                            return false;
                        }
                        if (++potionCount <= this.maxAllowedPotions) continue;
                        return false;
                    }
                    stackList.add(itemStack);
                    continue;
                }
                if (ingredient.method_8093(itemStack)) continue;
                return false;
            }
        }
        if (mobEffects.stream().allMatch(e -> class_2378.field_11159.method_40290((class_5321)class_2378.field_11159.method_29113((Object)e.method_5579()).orElseThrow()).method_40220(BzTags.DISALLOWED_INCENSE_CANDLE_EFFECTS))) {
            return false;
        }
        boolean shapelessMatched = this.shapelessIngredientMatched((List<class_1799>)stackList);
        return potionCount > 0 && shapelessMatched;
    }

    public boolean shapelessIngredientMatched(List<class_1799> stackList) {
        ArrayList<class_1856> copiedRequiredIngredients = new ArrayList<class_1856>((Collection<class_1856>)this.shapelessRecipeItems);
        for (int i = copiedRequiredIngredients.size() - 1; i >= 0; --i) {
            boolean foundMatch = false;
            for (int k = stackList.size() - 1; k >= 0; --k) {
                if (!((class_1856)copiedRequiredIngredients.get(i)).method_8093(stackList.get(k))) continue;
                copiedRequiredIngredients.remove(i);
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return copiedRequiredIngredients.isEmpty();
    }

    public class_1865<?> method_8119() {
        return BzRecipes.INCENSE_CANDLE_RECIPE;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 ingredients = class_2371.method_10211();
        ingredients.addAll(this.shapelessRecipeItems);
        ingredients.addAll(this.shapedRecipeItems);
        return ingredients;
    }

    public boolean method_8118() {
        return true;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public JsonObject toJson(IncenseCandleRecipe recipe) {
        return BzRecipes.INCENSE_CANDLE_RECIPE.toJson(recipe);
    }

    public IncenseCandleRecipe fromJson(class_2960 id, JsonObject json) {
        return BzRecipes.INCENSE_CANDLE_RECIPE.fromJson(id, json);
    }

    public IncenseCandleRecipe fromNetwork(class_2960 id, class_2540 buf) {
        return BzRecipes.INCENSE_CANDLE_RECIPE.fromNetwork(id, buf);
    }

    public void toNetwork(class_2540 buf, IncenseCandleRecipe recipe) {
        BzRecipes.INCENSE_CANDLE_RECIPE.toNetwork(buf, recipe);
    }

    public class_3956<?> method_17716() {
        return class_3956.field_17545;
    }

    public static class Serializer
    implements class_1865<IncenseCandleRecipe> {
        private static class_2371<class_1856> getIngredients(JsonArray jsonElements) {
            class_2371 defaultedList = class_2371.method_10211();
            for (int i = 0; i < jsonElements.size(); ++i) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)jsonElements.get(i));
                if (ingredient.method_8103()) continue;
                defaultedList.add((Object)ingredient);
            }
            return defaultedList;
        }

        public IncenseCandleRecipe fromJson(class_2960 recipeId, JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            Map<String, class_1856> map = ShapedRecipeAccessor.callKeyFromJson(class_3518.method_15296((JsonObject)json, (String)"key"));
            String[] astring = ShapedRecipeAccessor.callShrink(ShapedRecipeAccessor.callPatternFromJson(class_3518.method_15261((JsonObject)json, (String)"pattern")));
            int width = astring[0].length();
            int height = astring.length;
            class_2371<class_1856> shapedRecipeItems = ShapedRecipeAccessor.callDissolvePattern(astring, map, width, height);
            class_2371<class_1856> shapelessRecipeItems = Serializer.getIngredients(class_3518.method_15261((JsonObject)json, (String)"shapelessExtraIngredients"));
            if (shapelessRecipeItems.isEmpty()) {
                throw new JsonParseException("No shapeless ingredients for Super Incense Candle recipe");
            }
            int maxPotions = json.get("maxAllowedPotions").getAsInt();
            boolean allowNormalPotionsRead = json.get("allowNormalPotions").getAsBoolean();
            boolean allowSplashPotionsRead = json.get("allowSplashPotions").getAsBoolean();
            boolean allowLingeringPotionsRead = json.get("allowLingeringPotions").getAsBoolean();
            int maxLevelRead = json.get("maxLevelCap").getAsInt();
            int resultCount = json.get("resultCount").getAsInt();
            return new IncenseCandleRecipe(recipeId, group, resultCount, maxPotions, shapedRecipeItems, shapelessRecipeItems, width, height, allowNormalPotionsRead, allowSplashPotionsRead, allowLingeringPotionsRead, maxLevelRead);
        }

        public JsonObject toJson(IncenseCandleRecipe recipe) {
            JsonObject json = new JsonObject();
            json.addProperty("type", class_2378.field_17598.method_10221((Object)BzRecipes.INCENSE_CANDLE_RECIPE).toString());
            json.addProperty("group", recipe.group);
            class_2371<class_1856> recipeIngredients = recipe.shapedRecipeItems;
            Object2CharOpenHashMap ingredients = new Object2CharOpenHashMap();
            Char2ObjectOpenHashMap inputs = new Char2ObjectOpenHashMap();
            ingredients.defaultReturnValue(' ');
            char currentChar = 'A';
            for (class_1856 ingredient : recipeIngredients) {
                if (ingredient.method_8103() || ingredients.putIfAbsent((Object)ingredient, currentChar) != ingredients.defaultReturnValue()) continue;
                inputs.putIfAbsent(currentChar, (Object)ingredient);
                currentChar = (char)(currentChar + '\u0001');
            }
            ArrayList<String> pattern = new ArrayList<String>();
            StringBuilder patternLine = new StringBuilder();
            for (int i = 0; i < recipeIngredients.size(); ++i) {
                if (i != 0 && i % recipe.getWidth() == 0) {
                    pattern.add(patternLine.toString());
                    patternLine.setLength(0);
                }
                class_1856 ingredient = (class_1856)recipeIngredients.get(i);
                patternLine.append(ingredients.getChar((Object)ingredient));
            }
            pattern.add(patternLine.toString());
            JsonArray jsonArray = new JsonArray();
            for (String string : pattern) {
                jsonArray.add(string);
            }
            json.add("pattern", (JsonElement)jsonArray);
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry entry : inputs.entrySet()) {
                jsonObject.add(String.valueOf(entry.getKey()), ((class_1856)entry.getValue()).method_8089());
            }
            json.add("key", (JsonElement)jsonObject);
            JsonArray shapelessRecipeJsonArray = new JsonArray();
            recipe.shapelessRecipeItems.stream().map(class_1856::method_8089).forEach(arg_0 -> ((JsonArray)shapelessRecipeJsonArray).add(arg_0));
            json.add("shapelessExtraIngredients", (JsonElement)shapelessRecipeJsonArray);
            json.addProperty("maxAllowedPotions", (Number)recipe.maxAllowedPotions);
            json.addProperty("allowNormalPotions", Boolean.valueOf(recipe.allowNormalPotions));
            json.addProperty("allowSplashPotions", Boolean.valueOf(recipe.allowSplashPotions));
            json.addProperty("allowLingeringPotions", Boolean.valueOf(recipe.allowLingeringPotions));
            json.addProperty("maxLevelCap", (Number)recipe.maxLevelCap);
            json.addProperty("resultCount", (Number)recipe.result.method_7947());
            return json;
        }

        public IncenseCandleRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            String group = buffer.method_19772();
            int width = buffer.method_10816();
            int height = buffer.method_10816();
            class_2371 shapedRecipe = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
            shapedRecipe.replaceAll(ignored -> class_1856.method_8086((class_2540)buffer));
            int ingredientCount = buffer.method_10816();
            class_2371 shapelessRecipe = class_2371.method_10213((int)ingredientCount, (Object)class_1856.field_9017);
            shapelessRecipe.replaceAll(ignored -> class_1856.method_8086((class_2540)buffer));
            int maxPotionRead = buffer.method_10816();
            boolean allowNormalPotionsRead = buffer.readBoolean();
            boolean allowSplashPotionsRead = buffer.readBoolean();
            boolean allowLingeringPotionsRead = buffer.readBoolean();
            int maxLevelRead = buffer.method_10816();
            int resultCountRead = buffer.method_10816();
            return new IncenseCandleRecipe(recipeId, group, resultCountRead, maxPotionRead, (class_2371<class_1856>)shapedRecipe, (class_2371<class_1856>)shapelessRecipe, width, height, allowNormalPotionsRead, allowSplashPotionsRead, allowLingeringPotionsRead, maxLevelRead);
        }

        public void toNetwork(class_2540 buffer, IncenseCandleRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10804(recipe.width);
            buffer.method_10804(recipe.height);
            for (class_1856 ingredient : recipe.shapedRecipeItems) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10804(recipe.shapelessRecipeItems.size());
            for (class_1856 ingredient : recipe.shapelessRecipeItems) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10804(recipe.maxAllowedPotions);
            buffer.writeBoolean(recipe.allowNormalPotions);
            buffer.writeBoolean(recipe.allowSplashPotions);
            buffer.writeBoolean(recipe.allowLingeringPotions);
            buffer.method_10804(recipe.maxLevelCap);
            buffer.method_10804(recipe.outputCount);
        }
    }
}

