/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.telepathicgrunt.the_bumblezone.modinit.BzRecipes;
import java.util.Map;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ContainerCraftingRecipe
extends class_1867 {
    private final String group;
    private final class_1799 recipeOutput;
    private final class_2371<class_1856> recipeItems;
    public static final Map<class_1792, class_1792> HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET = Map.ofEntries(Map.entry(class_1802.field_27876, class_1802.field_8550), Map.entry(class_1802.field_28354, class_1802.field_8550), Map.entry(class_1802.field_8666, class_1802.field_8550), Map.entry(class_1802.field_8108, class_1802.field_8550), Map.entry(class_1802.field_8714, class_1802.field_8550), Map.entry(class_1802.field_8478, class_1802.field_8550), Map.entry(class_1802.field_8766, class_1802.field_8428), Map.entry(class_1802.field_8208, class_1802.field_8428), Map.entry(class_1802.field_8308, class_1802.field_8428), Map.entry(class_1802.field_8515, class_1802.field_8428), Map.entry(class_1802.field_8574, class_1802.field_8469), Map.entry(class_1802.field_8436, class_1802.field_8469), Map.entry(class_1802.field_8150, class_1802.field_8469), Map.entry(class_1802.field_8287, class_1802.field_8469));

    public ContainerCraftingRecipe(class_2960 idIn, String groupIn, class_1799 recipeOutputIn, class_2371<class_1856> recipeItemsIn) {
        super(idIn, groupIn, recipeOutputIn, recipeItemsIn);
        this.group = groupIn;
        this.recipeOutput = recipeOutputIn;
        this.recipeItems = recipeItemsIn;
    }

    public class_1865<?> method_8119() {
        return BzRecipes.CONTAINER_CRAFTING_RECIPE;
    }

    public class_2371<class_1856> method_8117() {
        return this.recipeItems;
    }

    public class_2371<class_1799> getRemainingItems(class_1715 inv) {
        class_2371 remainingInv = class_2371.method_10213((int)inv.method_5439(), (Object)class_1799.field_8037);
        int containerOutput = this.recipeOutput.method_7909().method_7857() ? this.recipeOutput.method_7947() : 0;
        for (int i = 0; i < remainingInv.size(); ++i) {
            class_1799 craftingInput = inv.method_5438(i);
            class_1792 craftingContainer = craftingInput.method_7909().method_7858();
            class_1792 recipeContainer = this.recipeOutput.method_7909().method_7858();
            if (craftingContainer == null && HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET.containsKey(craftingInput.method_7909())) {
                craftingContainer = HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET.get(craftingInput.method_7909());
            }
            if (recipeContainer == null && HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET.containsKey(this.recipeOutput.method_7909())) {
                recipeContainer = HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET.get(this.recipeOutput.method_7909());
            }
            if (craftingContainer == null) continue;
            if (containerOutput > 0 && (this.recipeOutput.method_7909() == craftingContainer || recipeContainer == craftingInput.method_7909() || recipeContainer == craftingContainer)) {
                --containerOutput;
                continue;
            }
            remainingInv.set(i, (Object)craftingContainer.method_7854());
        }
        return remainingInv;
    }

    public static JsonObject itemStackFromJson(class_1799 itemStack) {
        JsonObject json = new JsonObject();
        json.addProperty("count", (Number)itemStack.method_7947());
        json.addProperty("item", class_2378.field_11142.method_10221((Object)itemStack.method_7909()).toString());
        return json;
    }

    public static class Serializer
    implements class_1865<ContainerCraftingRecipe> {
        public ContainerCraftingRecipe fromJson(class_2960 recipeId, JsonObject json) {
            String s = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_2371<class_1856> DefaultedList = Serializer.getIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (DefaultedList.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            class_1799 itemstack = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            return new ContainerCraftingRecipe(recipeId, s, itemstack, DefaultedList);
        }

        private static class_2371<class_1856> getIngredients(JsonArray jsonElements) {
            class_2371 defaultedList = class_2371.method_10211();
            for (int i = 0; i < jsonElements.size(); ++i) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)jsonElements.get(i));
                if (ingredient.method_8103()) continue;
                defaultedList.add((Object)ingredient);
            }
            return defaultedList;
        }

        public ContainerCraftingRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            String s = buffer.method_10800(Short.MAX_VALUE);
            int i = buffer.method_10816();
            class_2371 defaultedList = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            for (int j = 0; j < defaultedList.size(); ++j) {
                defaultedList.set(j, (Object)class_1856.method_8086((class_2540)buffer));
            }
            class_1799 itemstack = buffer.method_10819();
            return new ContainerCraftingRecipe(recipeId, s, itemstack, (class_2371<class_1856>)defaultedList);
        }

        public void toNetwork(class_2540 buffer, ContainerCraftingRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10804(recipe.recipeItems.size());
            for (class_1856 ingredient : recipe.recipeItems) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.recipeOutput);
        }

        public JsonObject toJson(ContainerCraftingRecipe recipe) {
            JsonObject json = new JsonObject();
            json.addProperty("group", recipe.method_8112());
            JsonArray array = new JsonArray();
            recipe.recipeItems.stream().map(class_1856::method_8089).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            json.add("ingredients", (JsonElement)array);
            json.add("result", (JsonElement)ContainerCraftingRecipe.itemStackFromJson(recipe.recipeOutput));
            return json;
        }
    }
}

