/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.client.rendering.beequeen.BeeQueenPose;
import com.telepathicgrunt.the_bumblezone.components.MiscComponent;
import com.telepathicgrunt.the_bumblezone.configs.BzConfig;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeeQueenAlwaysLookAtPlayerGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeeQueenAngerableMeleeAttackGoal;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.mixin.entities.PlayerAdvancementsAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_3830;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4466;
import net.minecraft.class_4538;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5138;
import net.minecraft.class_5250;
import net.minecraft.class_5354;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6012;
import net.minecraft.class_6019;
import net.minecraft.class_7094;

public class BeeQueenEntity
extends class_1429
implements class_5354 {
    private static final class_4051 PLAYER_ACKNOWLEDGE_SIGHT = class_4051.method_36626();
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 attackAnimationState = new class_7094();
    public final class_7094 itemThrownAnimationState = new class_7094();
    public final class_7094 itemRejectAnimationState = new class_7094();
    public static final class_2941<BeeQueenPose> QUEEN_POSE_SERIALIZER = class_2941.method_43240(BeeQueenPose.class);
    private static final class_2940<Integer> THROWCOOLDOWN = class_2945.method_12791(BeeQueenEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> BEESPAWNCOOLDOWN = class_2945.method_12791(BeeQueenEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> REMAINING_ANGER_TIME = class_2945.method_12791(BeeQueenEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<BeeQueenPose> QUEEN_POSE = class_2945.method_12791(BeeQueenEntity.class, QUEEN_POSE_SERIALIZER);
    private static final class_2940<Integer> REMAINING_BONUS_TRADE_TIME = class_2945.method_12791(BeeQueenEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_1799> BONUS_TRADE_ITEM = class_2945.method_12791(BeeQueenEntity.class, (class_2941)class_2943.field_13322);
    private static final class_6019 PERSISTENT_ANGER_TIME = class_4802.method_24505((int)60, (int)120);
    private final Set<UUID> acknowledgedPlayers = new HashSet<UUID>();
    private UUID persistentAngerTarget;
    private int underWaterTicks;
    private int poseTicks;
    private boolean hasTrades = true;
    private static final Supplier<WeightedTradeResult> ESSENCE_DROP = () -> new WeightedTradeResult(null, Optional.of(List.of(BzItems.ESSENCE_OF_THE_BEES)), 1, 1000, 1);
    private static final class_2960 ESSENCE_ADVANCEMENT_RL = new class_2960("the_bumblezone", "the_bumblezone/the_queens_desire/essence_infusion");

    public BeeQueenEntity(class_1299<? extends BeeQueenEntity> type, class_1937 world) {
        super(type, world);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(THROWCOOLDOWN, (Object)0);
        this.field_6011.method_12784(REMAINING_ANGER_TIME, (Object)0);
        this.field_6011.method_12784(BEESPAWNCOOLDOWN, (Object)0);
        this.field_6011.method_12784(QUEEN_POSE, (Object)BeeQueenPose.NONE);
        this.field_6011.method_12784(REMAINING_BONUS_TRADE_TIME, (Object)0);
        this.field_6011.method_12784(BONUS_TRADE_ITEM, (Object)class_1799.field_8037);
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (QUEEN_POSE.equals(entityDataAccessor)) {
            BeeQueenPose pose = this.getQueenPose();
            if (pose == BeeQueenPose.ATTACKING) {
                this.attackAnimationState.method_41322(this.field_6012);
            } else {
                this.attackAnimationState.method_41325();
            }
            if (pose == BeeQueenPose.ITEM_REJECT) {
                this.itemRejectAnimationState.method_41322(this.field_6012);
            } else {
                this.itemRejectAnimationState.method_41325();
            }
            if (pose == BeeQueenPose.ITEM_THROW) {
                this.itemThrownAnimationState.method_41322(this.field_6012);
            } else {
                this.itemThrownAnimationState.method_41325();
            }
        }
        super.method_5674(entityDataAccessor);
    }

    public static class_5132.class_5133 getAttributeBuilder() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 150.0).method_26868(class_5134.field_23719, 0.1).method_26868(class_5134.field_23721, 10.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new BeeQueenAngerableMeleeAttackGoal(this));
        this.field_6201.method_6277(2, (class_1352)new BeeQueenAlwaysLookAtPlayerGoal((class_1308)this, class_1657.class, 60.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1347((class_1308)this));
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("throwcooldown", this.getThrowCooldown());
        tag.method_10569("beespawncooldown", this.getBeeSpawnCooldown());
        tag.method_10569("bonustradetime", this.getRemainingBonusTradeTime());
        tag.method_10566("bonustradeitem", (class_2520)this.getBonusTradeItem().method_7953(new class_2487()));
        this.method_29517(tag);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setThrowCooldown(tag.method_10550("throwcooldown"));
        this.setBeeSpawnCooldown(tag.method_10550("beespawncooldown"));
        this.setRemainingBonusTradeTime(tag.method_10550("bonustradetime"));
        this.setBonusTradeItem(class_1799.method_7915((class_2487)tag.method_10562("bonustradeitem")));
        if (this.getBonusTradeItem().method_31573(BzTags.DISALLOWED_RANDOM_BONUS_TRADE_ITEMS) && !this.getBonusTradeItem().method_31573(BzTags.FORCED_ALLOWED_RANDOM_BONUS_TRADE_ITEMS)) {
            this.setBonusTradeItem(class_1799.field_8037);
            this.setRemainingBonusTradeTime(0);
        }
        this.method_29512(this.field_6002, tag);
    }

    public void setQueenPose(BeeQueenPose beeQueenPose) {
        this.field_6011.method_12778(QUEEN_POSE, (Object)beeQueenPose);
    }

    public BeeQueenPose getQueenPose() {
        return (BeeQueenPose)((Object)this.field_6011.method_12789(QUEEN_POSE));
    }

    protected class_1408 method_5965(class_1937 pLevel) {
        return new DirectPathNavigator((class_1308)this, pLevel);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    public static boolean checkMobSpawnRules(class_1299<? extends class_1308> entityType, class_1936 iWorld, class_3730 spawnReason, class_2338 blockPos, class_5819 random) {
        return true;
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        return true;
    }

    public boolean method_5957(class_4538 worldReader) {
        class_238 box = this.method_5829();
        return !worldReader.method_22345(box) && worldReader.method_29546(box).noneMatch(state -> state.method_26207().method_15801()) && worldReader.method_8606((class_1297)this);
    }

    public boolean method_5810() {
        return false;
    }

    public void method_5865(class_1297 entity) {
        this.positionRider(entity, class_1297::method_5814);
    }

    public double method_5621() {
        return this.method_18377((class_4050)class_4050.field_18076).field_18068 * 0.9f;
    }

    private void positionRider(class_1297 entity, class_1297.class_4738 moveFunction) {
        if (this.method_5626(entity)) {
            double riderYOffset = this.method_23318() + this.method_5621() + entity.method_5678();
            class_243 forwardVect = class_243.method_1030((float)0.0f, (float)this.method_43078());
            class_243 sideVect = class_243.method_1030((float)0.0f, (float)(this.method_43078() - 90.0f));
            moveFunction.accept(entity, this.method_23317() + sideVect.method_10216() - forwardVect.method_10216() * 0.5, riderYOffset, this.method_23321() + sideVect.method_10215() - forwardVect.method_10215() * 0.5);
        }
    }

    public boolean method_5679(class_1282 damageSource) {
        if (damageSource == class_1282.field_16992) {
            return true;
        }
        return super.method_5679(damageSource);
    }

    public void method_5844(class_2680 blockState, class_243 speedMult) {
        if (blockState.method_26204() instanceof class_3830) {
            return;
        }
        super.method_5844(blockState, speedMult);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1309 livingEntity;
        class_1297 entity;
        if (this.method_5679(source)) {
            return false;
        }
        if (this.method_30230() && source == class_1282.field_5855) {
            this.spawnAngryParticles(6);
            this.method_6013(source);
            return false;
        }
        if (!this.method_5987() && (entity = source.method_5529()) instanceof class_1309 && !(livingEntity = (class_1309)entity).method_7325()) {
            if (livingEntity instanceof class_1657) {
                class_1657 player = (class_1657)livingEntity;
                if (this.field_6002.method_8407() == class_1267.field_5801 || player.method_7337()) {
                    this.spawnAngryParticles(6);
                    return super.method_5643(source, amount);
                }
            }
            if ((livingEntity.field_6002.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID) || BzConfig.allowWrathOfTheHiveOutsideBumblezone) && BzConfig.aggressiveBees) {
                if (livingEntity.method_6059(BzEffects.PROTECTION_OF_THE_HIVE)) {
                    livingEntity.method_6016(BzEffects.PROTECTION_OF_THE_HIVE);
                } else {
                    livingEntity.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE, BzConfig.howLongWrathOfTheHiveLasts, 3, false, BzConfig.showWrathOfTheHiveParticles, true));
                }
            }
            this.method_29509();
            this.method_29513(livingEntity.method_5667());
            this.method_5980(livingEntity);
        }
        this.spawnAngryParticles(6);
        return super.method_5643(source, amount);
    }

    protected void method_5958() {
        this.underWaterTicks = this.method_5869() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 100) {
            this.method_5643(class_1282.field_5859, 3.0f);
        }
        if (!this.field_6002.field_9236) {
            this.method_29510((class_3218)this.field_6002, false);
        }
    }

    public static void applyMiningFatigueInStructures(class_3222 serverPlayer) {
        if (serverPlayer.method_7337() || serverPlayer.method_7325()) {
            return;
        }
        class_5138 structureManager = ((class_3218)serverPlayer.field_6002).method_27056();
        if (structureManager.method_41413(serverPlayer.method_24515(), BzTags.BEE_QUEEN_MINING_FATIGUE).method_16657() && !serverPlayer.field_6002.method_8390(BeeQueenEntity.class, serverPlayer.method_5829().method_1009(30.0, 30.0, 30.0), e -> !e.method_5987()).isEmpty()) {
            serverPlayer.method_6092(new class_1293(class_1294.field_5901, 100, 2, false, false, true));
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5805()) {
            this.idleAnimationState.method_41324(this.field_6012);
        } else {
            this.idleAnimationState.method_41325();
        }
        BeeQueenPose pose = this.getQueenPose();
        if (pose != BeeQueenPose.NONE) {
            if (pose == BeeQueenPose.ATTACKING && this.poseTicks > 17) {
                this.setQueenPose(BeeQueenPose.NONE);
                this.poseTicks = 0;
            }
            if (pose == BeeQueenPose.ITEM_REJECT && this.poseTicks > 20) {
                this.setQueenPose(BeeQueenPose.NONE);
                this.poseTicks = 0;
            }
            if (pose == BeeQueenPose.ITEM_THROW && this.poseTicks > 20) {
                this.setQueenPose(BeeQueenPose.NONE);
                this.poseTicks = 0;
            }
            ++this.poseTicks;
        }
        if (!this.method_5987()) {
            if (!this.method_37908().method_8608() && this.method_37908().method_8510() % 200L == 0L) {
                this.method_6025(1.0f);
            }
            if (!this.field_6002.method_8608()) {
                if (this.method_29511()) {
                    this.performAngryActions();
                } else {
                    this.performGroundTrades();
                }
            }
        }
        this.performBonusTradeTick();
    }

    private void performBonusTradeTick() {
        if (!this.field_6002.method_8608()) {
            if (BzConfig.beeQueenBonusTradeRewardMultiplier <= 1 || BzConfig.beeQueenBonusTradeDurationInTicks == 0 || BzConfig.beeQueenBonusTradeAmountTillSatified == 0) {
                if (this.getRemainingBonusTradeTime() > 0) {
                    this.setRemainingBonusTradeTime(0);
                }
                if (!this.getBonusTradeItem().method_7960()) {
                    this.setBonusTradeItem(class_1799.field_8037);
                    this.acknowledgedPlayers.clear();
                }
            }
            int minNotifyTime = 1200;
            if (this.getRemainingBonusTradeTime() > 0) {
                this.setRemainingBonusTradeTime(this.getRemainingBonusTradeTime() - 1);
            } else if (!this.getBonusTradeItem().method_7960()) {
                this.setBonusTradeItem(class_1799.field_8037);
                this.acknowledgedPlayers.clear();
            }
            if (this.hasTrades && !this.method_29511() && (this.method_37908().method_8510() + this.method_5667().getLeastSignificantBits()) % 20L == 0L) {
                List nearbyPlayers = null;
                if (this.getRemainingBonusTradeTime() == 0 && (nearbyPlayers = this.field_6002.method_18464(PLAYER_ACKNOWLEDGE_SIGHT, (class_1309)this, this.method_5829().method_1014(8.0))).size() > 0) {
                    this.setRemainingBonusTradeTime(BzConfig.beeQueenBonusTradeDurationInTicks);
                    List<class_1792> allowedBonusTradeItems = QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.keySet().stream().filter(i -> i.method_7859() != null && !i.method_40131().method_40220(BzTags.DISALLOWED_RANDOM_BONUS_TRADE_ITEMS) || i.method_40131().method_40220(BzTags.FORCED_ALLOWED_RANDOM_BONUS_TRADE_ITEMS)).toList();
                    if (allowedBonusTradeItems.size() > 0) {
                        this.setBonusTradeItem(((class_1792)allowedBonusTradeItems.get(this.method_6051().method_43048(allowedBonusTradeItems.size()))).method_7854());
                        this.getBonusTradeItem().method_7933(BzConfig.beeQueenBonusTradeAmountTillSatified);
                    } else {
                        this.hasTrades = false;
                        this.setRemainingBonusTradeTime(0);
                        return;
                    }
                }
                if (this.getBonusTradeItem().method_7960() && this.getRemainingBonusTradeTime() > 0) {
                    if (this.getRemainingBonusTradeTime() > minNotifyTime) {
                        if (nearbyPlayers == null) {
                            nearbyPlayers = this.field_6002.method_18464(PLAYER_ACKNOWLEDGE_SIGHT, (class_1309)this, this.method_5829().method_1014(8.0));
                        }
                        for (class_1657 player : nearbyPlayers) {
                            if (this.acknowledgedPlayers.contains(player.method_5667())) continue;
                            player.method_7353((class_2561)class_2561.method_43471((String)"entity.the_bumblezone.bee_queen.mention_bonus_trade_satisfied").method_27692(class_124.field_1068), true);
                            this.acknowledgedPlayers.add(player.method_5667());
                        }
                    }
                    return;
                }
                if (!this.getBonusTradeItem().method_7960() && this.getRemainingBonusTradeTime() >= minNotifyTime && nearbyPlayers != null) {
                    boolean notifiedAPlayer = false;
                    for (class_1657 player : nearbyPlayers) {
                        if (this.acknowledgedPlayers.contains(player.method_5667())) continue;
                        class_2561 itemName = this.getBonusTradeItem().method_7964();
                        if (itemName instanceof class_5250) {
                            class_5250 mutableComponent = (class_5250)itemName;
                            mutableComponent.method_27692(class_124.field_1054);
                        }
                        if (player.field_7498.field_7761.stream().anyMatch(s -> s.method_7677().method_7962(this.getBonusTradeItem()))) {
                            player.method_7353((class_2561)class_2561.method_43469((String)"entity.the_bumblezone.bee_queen.mention_bonus_trade_inventory", (Object[])new Object[]{itemName}).method_27692(class_124.field_1068), true);
                        } else {
                            player.method_7353((class_2561)class_2561.method_43469((String)"entity.the_bumblezone.bee_queen.mention_bonus_trade", (Object[])new Object[]{itemName, this.getRemainingBonusTradeTime() / minNotifyTime}).method_27692(class_124.field_1068), true);
                        }
                        notifiedAPlayer = true;
                        this.acknowledgedPlayers.add(player.method_5667());
                    }
                    if (notifiedAPlayer) {
                        this.setQueenPose(BeeQueenPose.ITEM_THROW);
                    }
                }
            }
        }
    }

    private void performAngryActions() {
        if (this.field_6002.method_8407() == class_1267.field_5801) {
            this.method_29922();
            return;
        }
        int beeCooldown = this.getBeeSpawnCooldown();
        if (beeCooldown <= 0 && !this.method_6062()) {
            this.setBeeSpawnCooldown(this.field_5974.method_43048(50) + 75);
            class_2338 spawnBlockPos = GeneralUtils.getRandomBlockposWithinRange((class_1309)this, 5, 0);
            if (!this.field_6002.method_8320(spawnBlockPos).method_26215()) {
                return;
            }
            class_4466 bee = (class_4466)class_1299.field_20346.method_5883(this.field_6002);
            if (bee == null) {
                return;
            }
            bee.method_29514(this.method_29507());
            bee.method_29513(this.method_29508());
            bee.method_5980(this.method_5968());
            bee.method_5641((double)spawnBlockPos.method_10263() + 0.5, (double)spawnBlockPos.method_10264() + 0.5, (double)spawnBlockPos.method_10260() + 0.5, this.field_5974.method_43057() * 360.0f, 0.0f);
            bee.method_5943((class_5425)((class_3218)this.field_6002), this.field_6002.method_8404(spawnBlockPos), class_3730.field_16461, null, null);
            bee.method_6092(new class_1293(class_1294.field_5920, Integer.MAX_VALUE, 0, true, false, false));
            this.field_6002.method_8649((class_1297)bee);
            this.spawnAngryParticles(6);
            this.setQueenPose(BeeQueenPose.ATTACKING);
        } else {
            this.setBeeSpawnCooldown(beeCooldown - 1);
        }
    }

    private void performGroundTrades() {
        int throwCooldown = this.getThrowCooldown();
        if (throwCooldown > 0) {
            this.setThrowCooldown(throwCooldown - 1);
        }
        if ((this.method_37908().method_8510() + this.method_5667().getLeastSignificantBits()) % 20L == 0L && throwCooldown <= 0) {
            class_243 forwardVect = class_243.method_1030((float)0.0f, (float)this.method_43078());
            class_243 sideVect = class_243.method_1030((float)0.0f, (float)(this.method_43078() - 90.0f));
            class_238 scanArea = this.method_5829().method_35580(0.45, 0.9, 0.45).method_989(forwardVect.method_10216() * 0.5, -0.95, forwardVect.method_10215() * 0.5);
            List items = this.field_6002.method_18467(class_1542.class, scanArea);
            items.stream().filter(ie -> !ie.method_6977()).findFirst().ifPresent(itemEntity -> {
                class_1657 patt27018$temp;
                int tradedItems = 0;
                class_1792 item = itemEntity.method_6983().method_7909();
                if (QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.containsKey((Object)item)) {
                    for (int i = 0; i < itemEntity.method_6983().method_7947(); ++i) {
                        Optional reward = ((class_6012)QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.get((Object)item)).method_34992(this.field_5974);
                        if (!reward.isPresent()) continue;
                        this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), itemEntity.method_6983(), itemEntity.method_6978());
                        ++tradedItems;
                    }
                }
                if (tradedItems > 0) {
                    itemEntity.method_5650(class_1297.class_5529.field_26999);
                } else {
                    itemEntity.method_5650(class_1297.class_5529.field_26999);
                    class_1542 rejectedItemEntity = new class_1542(this.field_6002, this.method_23317() + sideVect.method_10216() * 1.75 + forwardVect.method_10216() * 1.0, this.method_23318() + 0.3, this.method_23321() + sideVect.method_10215() * 1.75 + forwardVect.method_10216() * 1.0, itemEntity.method_6983(), (double)((this.field_5974.method_43057() - 0.5f) / 10.0f) + forwardVect.method_10216() / 3.0, (double)0.4f, (double)((this.field_5974.method_43057() - 0.5f) / 10.0f) + forwardVect.method_10215() / 3.0);
                    this.field_6002.method_8649((class_1297)rejectedItemEntity);
                    rejectedItemEntity.method_6988();
                    this.spawnAngryParticles(2);
                    this.setQueenPose(BeeQueenPose.ITEM_REJECT);
                }
                this.setThrowCooldown(50);
                if (tradedItems > 0 && itemEntity.method_6978() != null && (patt27018$temp = this.field_6002.method_18470(itemEntity.method_6978())) instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)patt27018$temp;
                    BzCriterias.BEE_QUEEN_FIRST_TRADE_TRIGGER.trigger(serverPlayer);
                    MiscComponent.onQueenBeeTrade((class_1657)serverPlayer, tradedItems);
                    if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                        MiscComponent capability = (MiscComponent)Bumblezone.MISC_COMPONENT.get((Object)serverPlayer);
                        if (!capability.receivedEssencePrize) {
                            this.spawnReward(forwardVect, sideVect, ESSENCE_DROP.get(), class_1799.field_8037, null);
                            capability.receivedEssencePrize = true;
                            serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"entity.the_bumblezone.bee_queen.mention_reset").method_27692(class_124.field_1056).method_27692(class_124.field_1065), false);
                        }
                    }
                }
            });
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.method_5987()) {
            return class_1269.field_5811;
        }
        if (this.method_29511() || hand == class_1268.field_5810) {
            return class_1269.field_5814;
        }
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        if (stack.method_7960() && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                MiscComponent capability = (MiscComponent)Bumblezone.MISC_COMPONENT.get((Object)serverPlayer);
                if (!capability.receivedEssencePrize) {
                    class_243 forwardVect = class_243.method_1030((float)0.0f, (float)this.method_43078());
                    class_243 sideVect = class_243.method_1030((float)0.0f, (float)(this.method_43078() - 90.0f));
                    this.spawnReward(forwardVect, sideVect, ESSENCE_DROP.get(), class_1799.field_8037, null);
                    capability.receivedEssencePrize = true;
                    serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"entity.the_bumblezone.bee_queen.mention_reset").method_27692(class_124.field_1056).method_27692(class_124.field_1065), false);
                } else {
                    long timeDiff = this.field_6002.method_8510() - capability.tradeResetPrimedTime;
                    if (timeDiff < 200L && timeDiff > 10L) {
                        this.resetAdvancementTree(serverPlayer, BzCriterias.QUEENS_DESIRE_ROOT_ADVANCEMENT);
                        capability.resetAllTrackerStats();
                        serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"entity.the_bumblezone.bee_queen.reset_advancements").method_27692(class_124.field_1056).method_27692(class_124.field_1065), false);
                    } else {
                        capability.tradeResetPrimedTime = this.field_6002.method_8510();
                        serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"entity.the_bumblezone.bee_queen.advancements_warning").method_27692(class_124.field_1056).method_27692(class_124.field_1065), false);
                    }
                }
            }
            return class_1269.field_5811;
        }
        boolean traded = false;
        if (QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.containsKey((Object)item)) {
            if (this.field_6002.method_8608()) {
                return class_1269.field_5812;
            }
            class_243 forwardVect = class_243.method_1030((float)0.0f, (float)this.method_43078());
            class_243 sideVect = class_243.method_1030((float)0.0f, (float)(this.method_43078() - 90.0f));
            Optional reward = ((class_6012)QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.get((Object)item)).method_34992(this.field_5974);
            if (reward.isPresent()) {
                this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), stack, player.method_5667());
                traded = true;
            }
        }
        if (!this.field_6002.method_8608()) {
            if (!traded) {
                this.spawnAngryParticles(2);
                this.setQueenPose(BeeQueenPose.ITEM_REJECT);
            } else {
                this.setThrowCooldown(50);
                stack.method_7934(1);
                player.method_6122(hand, stack);
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    BzCriterias.BEE_QUEEN_FIRST_TRADE_TRIGGER.trigger(serverPlayer);
                    MiscComponent.onQueenBeeTrade((class_1657)serverPlayer);
                    if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                        MiscComponent capability = (MiscComponent)Bumblezone.MISC_COMPONENT.get((Object)serverPlayer);
                        if (!capability.receivedEssencePrize) {
                            class_243 forwardVect = class_243.method_1030((float)0.0f, (float)this.method_43078());
                            class_243 sideVect = class_243.method_1030((float)0.0f, (float)(this.method_43078() - 90.0f));
                            this.spawnReward(forwardVect, sideVect, ESSENCE_DROP.get(), class_1799.field_8037, null);
                            capability.receivedEssencePrize = true;
                            serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"entity.the_bumblezone.bee_queen.mention_reset").method_27692(class_124.field_1056).method_27692(class_124.field_1065), false);
                        }
                    }
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    private void resetAdvancementTree(class_3222 serverPlayer, class_2960 advancementRL) {
        Iterable advancements = serverPlayer.field_13995.method_3851().method_12896(advancementRL).method_681();
        for (class_161 advancement : advancements) {
            if (advancement.method_688().equals((Object)ESSENCE_ADVANCEMENT_RL)) continue;
            class_167 advancementprogress = serverPlayer.method_14236().method_12882(advancement);
            for (String criteria : advancementprogress.method_734()) {
                serverPlayer.method_14236().method_12883(advancement, criteria);
            }
            this.resetAdvancementTree(serverPlayer, advancement.method_688());
        }
    }

    private static boolean finalbeeQueenAdvancementDone(class_3222 serverPlayer) {
        class_161 advancement = serverPlayer.field_13995.method_3851().method_12896(BzCriterias.QUEENS_DESIRE_FINAL_ADVANCEMENT);
        Map<class_161, class_167> advancementsProgressMap = ((PlayerAdvancementsAccessor)serverPlayer.method_14236()).getAdvancements();
        return advancement != null && advancementsProgressMap.containsKey(advancement) && advancementsProgressMap.get(advancement).method_740();
    }

    private boolean isContainerBlockEntity(class_1799 itemStack) {
        class_2343 block;
        class_1747 blockItem;
        class_1792 class_17922 = itemStack.method_7909();
        return class_17922 instanceof class_1747 && (class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_2343 && (block = (class_2343)class_17922).method_10123(this.method_24515(), blockItem.method_7711().method_9564()) instanceof class_1263;
    }

    private void spawnReward(class_243 forwardVect, class_243 sideVect, WeightedTradeResult reward, class_1799 originalItem, UUID playerUUID) {
        int currentItemStackCount;
        int rewardMultiplier = 1;
        if (this.getBonusTradeItem().method_7962(originalItem) && BzConfig.beeQueenBonusTradeRewardMultiplier > 1) {
            class_1657 player;
            rewardMultiplier = BzConfig.beeQueenBonusTradeRewardMultiplier;
            this.getBonusTradeItem().method_7934(1);
            if (this.getBonusTradeItem().method_7960()) {
                this.setBonusTradeItem(class_1799.field_8037);
            }
            if ((player = this.field_6002.method_18470(playerUUID)) != null) {
                if (!this.getBonusTradeItem().method_7960()) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"entity.the_bumblezone.bee_queen.mention_bonus_trade_performed", (Object[])new Object[]{BzConfig.beeQueenBonusTradeRewardMultiplier}).method_27692(class_124.field_1068), true);
                } else {
                    this.acknowledgedPlayers.clear();
                    player.method_7353((class_2561)class_2561.method_43471((String)"entity.the_bumblezone.bee_queen.mention_bonus_trade_satisfied").method_27692(class_124.field_1068), true);
                    this.acknowledgedPlayers.add(playerUUID);
                }
            }
        }
        class_1792 chosenItem = reward.getItems().get(this.field_5974.method_43048(reward.getItems().size()));
        int itemStackMaxSize = chosenItem.method_7882();
        for (int remainingItemToSpawn = reward.count * rewardMultiplier; remainingItemToSpawn > 0; remainingItemToSpawn -= currentItemStackCount) {
            class_1937 class_19372;
            class_1799 rewardItem = chosenItem.method_7854();
            this.setQueenPose(BeeQueenPose.ITEM_THROW);
            if (originalItem.method_31573(class_3489.field_15556) && rewardItem.method_31573(class_3489.field_15556) && originalItem.method_7985()) {
                rewardItem.method_7948().method_10543(originalItem.method_7948());
            } else if (originalItem.method_7962(rewardItem) && originalItem.method_7985()) {
                rewardItem.method_7948().method_10543(originalItem.method_7948());
            } else if (this.isContainerBlockEntity(originalItem) && this.isContainerBlockEntity(rewardItem) && originalItem.method_7985()) {
                rewardItem.method_7948().method_10543(originalItem.method_7948());
            }
            currentItemStackCount = Math.min(remainingItemToSpawn, itemStackMaxSize);
            rewardItem.method_7939(currentItemStackCount);
            class_1542 rewardItemEntity = new class_1542(this.field_6002, this.method_23317() + sideVect.method_10216() * 0.9 + forwardVect.method_10216() * 1.0, this.method_23318() + 0.3, this.method_23321() + sideVect.method_10215() * 0.9 + forwardVect.method_10216() * 1.0, rewardItem, (double)((this.field_5974.method_43057() - 0.5f) / 10.0f) + forwardVect.method_10216() / 4.0, (double)0.3f, (double)((this.field_5974.method_43057() - 0.5f) / 10.0f) + forwardVect.method_10215() / 4.0);
            this.field_6002.method_8649((class_1297)rewardItemEntity);
            rewardItemEntity.method_6988();
            this.spawnHappyParticles();
            if (reward.xpReward <= 0 || !((class_19372 = this.field_6002) instanceof class_3218)) continue;
            class_3218 serverLevel = (class_3218)class_19372;
            class_1303.method_31493((class_3218)serverLevel, (class_243)new class_243(this.method_23317() + forwardVect.method_10216() * 1.0, this.method_23318() + 0.3, this.method_23321() + forwardVect.method_10216() * 1.0), (int)reward.xpReward);
        }
        this.field_6002.method_8396(null, this.method_24515(), BzSounds.BEE_QUEEN_HAPPY, class_3419.field_15254, 1.0f, this.method_6051().method_43057() * 0.2f + 0.6f);
    }

    public void spawnAngryParticles(int particles) {
        if (!this.field_6002.method_8608()) {
            ((class_3218)this.field_6002).method_14199((class_2394)class_2398.field_11231, this.method_23317(), this.method_23318() + (double)0.45f, this.method_23321(), particles, (double)(this.method_6051().method_43057() - 0.5f), (double)(this.method_6051().method_43057() * 0.4f + 0.4f), (double)(this.method_6051().method_43057() - 0.5f), (double)(this.method_6051().method_43057() * 0.8f + 0.4f));
        }
    }

    private void spawnHappyParticles() {
        ((class_3218)this.field_6002).method_14199((class_2394)class_2398.field_11211, this.method_23317(), this.method_23318() + 0.75, this.method_23321(), 5, 0.8, 0.75, 0.8, (double)this.method_6051().method_43057() + 0.5);
    }

    public class_1296 method_5613(class_3218 serverWorld, class_1296 ageableEntity) {
        class_4466 bee = (class_4466)class_1299.field_20346.method_5883((class_1937)serverWorld);
        bee.method_7217(true);
        return bee;
    }

    public int method_20240() {
        return 1;
    }

    public int method_5978() {
        return 90;
    }

    public int getThrowCooldown() {
        return (Integer)this.field_6011.method_12789(THROWCOOLDOWN);
    }

    public void setThrowCooldown(Integer cooldown) {
        this.field_6011.method_12778(THROWCOOLDOWN, (Object)cooldown);
    }

    public int getBeeSpawnCooldown() {
        return (Integer)this.field_6011.method_12789(BEESPAWNCOOLDOWN);
    }

    public void setBeeSpawnCooldown(Integer cooldown) {
        this.field_6011.method_12778(BEESPAWNCOOLDOWN, (Object)cooldown);
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(REMAINING_ANGER_TIME);
    }

    public void method_29514(int remainingPersistentAngerTime) {
        this.field_6011.method_12778(REMAINING_ANGER_TIME, (Object)remainingPersistentAngerTime);
    }

    public UUID method_29508() {
        return this.persistentAngerTarget;
    }

    public void method_29513(UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void method_29509() {
        this.method_29514(PERSISTENT_ANGER_TIME.method_35008(this.field_5974));
    }

    public void method_29922() {
        super.method_29922();
        this.setBeeSpawnCooldown(0);
        this.method_5980(null);
    }

    public int getRemainingBonusTradeTime() {
        return (Integer)this.field_6011.method_12789(REMAINING_BONUS_TRADE_TIME);
    }

    public void setRemainingBonusTradeTime(Integer remainingBonusTradeItem) {
        this.field_6011.method_12778(REMAINING_BONUS_TRADE_TIME, (Object)remainingBonusTradeItem);
    }

    public class_1799 getBonusTradeItem() {
        return (class_1799)this.field_6011.method_12789(BONUS_TRADE_ITEM);
    }

    public void setBonusTradeItem(class_1799 bonusTradeItem) {
        this.field_6011.method_12778(BONUS_TRADE_ITEM, (Object)bonusTradeItem);
    }

    protected void method_5712(class_2338 pos, class_2680 blockState) {
    }

    protected class_3414 method_5994() {
        return BzSounds.BEE_QUEEN_LOOP;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return BzSounds.BEE_QUEEN_HURT;
    }

    protected class_3414 method_6002() {
        return BzSounds.BEE_QUEEN_DEATH;
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.5f * this.method_5751()), (double)(this.method_17681() * 0.2f));
    }

    public static class DirectPathNavigator
    extends class_1409 {
        private final class_1308 mob;

        public DirectPathNavigator(class_1308 mob, class_1937 world) {
            super(mob, world);
            this.mob = mob;
        }

        public void method_6360() {
            ++this.field_6675;
        }

        public boolean method_6337(double x, double y, double z, double speedIn) {
            this.mob.method_5962().method_6239(x, y, z, speedIn);
            return true;
        }

        public boolean method_6335(class_1297 entityIn, double speedIn) {
            this.mob.method_5962().method_6239(entityIn.method_23317(), entityIn.method_23318(), entityIn.method_23321(), speedIn);
            return true;
        }
    }
}

