/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.components.EntityComponent;
import com.telepathicgrunt.the_bumblezone.configs.BzConfig;
import com.telepathicgrunt.the_bumblezone.entities.EntityTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.EnchantmentUtils;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzWorldSavedData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4153;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6885;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;

public class EntityTeleportationHookup {
    public static void playerTick(class_3222 serverPlayer) {
        List poiInRange;
        class_3218 serverLevel;
        class_1937 level = serverPlayer.field_6002;
        if (level instanceof class_3218 && ((serverLevel = (class_3218)level).method_8510() + serverPlayer.method_5667().getLeastSignificantBits()) % 100L == 0L && !serverLevel.method_27983().equals(BzDimension.BZ_WORLD_KEY) && (poiInRange = serverLevel.method_19494().method_22383(pointOfInterestType -> pointOfInterestType.method_40220(BzTags.IS_NEAR_BEEHIVE_ADVANCEMENT_TRIGGER_POI), serverPlayer.method_24515(), 8, class_4153.class_4155.field_18489).toList()).size() > 0) {
            BzCriterias.IS_NEAR_BEEHIVE_TRIGGER.trigger(serverPlayer);
        }
    }

    public static void entityTick(class_1309 livingEntity) {
        if (livingEntity.field_6002.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            if (livingEntity.method_23318() < -2.0) {
                if (BzConfig.enableExitTeleportation) {
                    if (livingEntity instanceof class_3222) {
                        BzCriterias.TELEPORT_OUT_OF_BUMBLEZONE_TRIGGER.trigger((class_3222)livingEntity);
                    }
                    if (livingEntity.method_23318() < -4.0) {
                        livingEntity.method_24203(livingEntity.method_23317(), -4.0, livingEntity.method_23321());
                        livingEntity.method_30634(livingEntity.method_23317(), -4.0, livingEntity.method_23321());
                        livingEntity.method_18800(0.0, 0.0, 0.0);
                        if (!livingEntity.field_6002.method_8608()) {
                            livingEntity.method_6092(new class_1293(class_1294.field_5906, 12, 100, false, false, true));
                        }
                    }
                    livingEntity.field_6017 = 0.0f;
                    if (!livingEntity.field_6002.method_8608()) {
                        EntityTeleportationHookup.teleportOutOfBz(livingEntity);
                    }
                }
            } else if (livingEntity.method_23318() > 255.0 && BzConfig.enableExitTeleportation) {
                if (livingEntity instanceof class_3222) {
                    BzCriterias.TELEPORT_OUT_OF_BUMBLEZONE_TRIGGER.trigger((class_3222)livingEntity);
                }
                if (livingEntity.method_23318() > 257.0) {
                    livingEntity.method_24203(livingEntity.method_23317(), 257.0, livingEntity.method_23321());
                    livingEntity.method_30634(livingEntity.method_23317(), 257.0, livingEntity.method_23321());
                }
                if (!livingEntity.field_6002.method_8608()) {
                    EntityTeleportationHookup.teleportOutOfBz(livingEntity);
                }
            }
        }
    }

    public static void teleportOutOfBz(class_1309 livingEntity) {
        if (!livingEntity.field_6002.method_8608()) {
            class_5321 worldKey;
            EntityTeleportationHookup.checkAndCorrectStoredDimension(livingEntity);
            MinecraftServer minecraftServer = livingEntity.method_5682();
            if (livingEntity.method_5642() == null) {
                worldKey = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)livingEntity)).getNonBZDimension());
            } else {
                class_1297 class_12972 = livingEntity.method_5642();
                if (class_12972 instanceof class_1309) {
                    class_1309 livingEntity2 = (class_1309)class_12972;
                    EntityTeleportationHookup.checkAndCorrectStoredDimension(livingEntity2);
                }
                worldKey = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)livingEntity.method_5642())).getNonBZDimension());
            }
            class_3218 serverWorld = minecraftServer.method_3847(worldKey);
            if (serverWorld == null) {
                serverWorld = minecraftServer.method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(BzConfig.defaultDimension)));
            }
            BzWorldSavedData.queueEntityToTeleport((class_1297)livingEntity, (class_5321<class_1937>)serverWorld.method_27983());
        }
    }

    public static boolean runTeleportProjectileImpact(class_239 hitResult, class_1297 thrower, class_1297 projectile) {
        if (thrower == null || thrower.field_6002 == null) {
            return false;
        }
        class_1937 world = thrower.field_6002;
        if (EntityTeleportationHookup.isTeleportAllowedInDimension(world)) {
            class_3965 blockHitResult;
            class_2680 block;
            class_2338 hivePos = null;
            if (hitResult instanceof class_3965 && EntityTeleportationBackend.isValidBeeHive(block = world.method_8320((blockHitResult = (class_3965)hitResult).method_17777()))) {
                hivePos = blockHitResult.method_17777();
            }
            if (hivePos == null) {
                hivePos = EntityTeleportationHookup.getNearbyHivePos(hitResult.method_17784(), world);
            }
            if (hivePos == null) {
                hivePos = EntityTeleportationHookup.getNearbyHivePos(hitResult.method_17784().method_1019(projectile.method_18798()), world);
            }
            if (hivePos == null) {
                return false;
            }
            boolean validBelowBlock = EntityTeleportationHookup.isValidBelowBlock(world, thrower, hivePos);
            if (validBelowBlock) {
                EntityTeleportationHookup.performTeleportation(thrower, projectile);
                return true;
            }
        }
        return false;
    }

    public static boolean runEntityHitCheck(class_239 hitResult, class_1297 thrower, class_1297 projectile) {
        if (thrower == null || thrower.field_6002 == null) {
            return false;
        }
        class_1937 world = thrower.field_6002;
        if (hitResult instanceof class_3966) {
            class_3966 entityHitResult = (class_3966)hitResult;
            if (EntityTeleportationHookup.isTeleportAllowedInDimension(world)) {
                class_1297 hitEntity = entityHitResult.method_17782();
                boolean passedCheck = false;
                if (hitEntity.method_5864().method_20210(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_ANYWHERE) || hitEntity.method_5864().method_20210(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_HIGH) || hitEntity.method_5864().method_20210(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_LOW)) {
                    class_243 hitPos = projectile.method_19538();
                    class_238 boundBox = entityHitResult.method_17782().method_5829();
                    double relativeHitY = hitPos.method_10214() - boundBox.field_1322;
                    double entityBoundHeight = boundBox.field_1325 - boundBox.field_1322;
                    double minYThreshold = -2.147483648E9;
                    double maxYThreshold = 2.147483647E9;
                    if (hitEntity.method_5864().method_20210(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_HIGH)) {
                        minYThreshold = entityBoundHeight / 2.0;
                    }
                    if (hitEntity.method_5864().method_20210(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_HIGH)) {
                        maxYThreshold = entityBoundHeight / 2.0;
                    }
                    if (minYThreshold != maxYThreshold && (relativeHitY > maxYThreshold || relativeHitY < minYThreshold)) {
                        return false;
                    }
                    passedCheck = true;
                }
                for (class_1799 stack : hitEntity.method_5877()) {
                    if (stack == null || !stack.method_31573(BzTags.TARGET_WITH_HELD_ITEM_HIT_BY_TELEPORT_PROJECTILE)) continue;
                    passedCheck = true;
                    break;
                }
                for (class_1799 stack : hitEntity.method_5661()) {
                    if (stack == null || !stack.method_31573(BzTags.TARGET_ARMOR_HIT_BY_TELEPORT_PROJECTILE)) continue;
                    passedCheck = true;
                }
                if (!passedCheck) {
                    return false;
                }
                class_2338 hivePos = entityHitResult.method_17782().method_24515();
                boolean validBelowBlock = EntityTeleportationHookup.isValidBelowBlock(world, thrower, hivePos);
                if (validBelowBlock) {
                    EntityTeleportationHookup.performTeleportation(thrower, projectile);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean runItemUseOn(class_1657 user, class_2338 clickedPos, class_2680 blockstate, class_1799 usingStack) {
        class_1937 world = user.field_6002;
        if (EntityTeleportationHookup.isTeleportAllowedInDimension(world)) {
            boolean isAllowTeleportItem;
            if (!EntityTeleportationBackend.isValidBeeHive(blockstate)) {
                return false;
            }
            boolean bl = isAllowTeleportItem = usingStack.method_31573(BzTags.TELEPORT_ITEM_RIGHT_CLICKED_BEEHIVE) || usingStack.method_31573(BzTags.TELEPORT_ITEM_RIGHT_CLICKED_BEEHIVE_CROUCHING) && user.method_5715();
            if (!isAllowTeleportItem) {
                Map enchantments = class_1890.method_8222((class_1799)usingStack);
                for (class_1887 enchantment : enchantments.keySet()) {
                    if (EnchantmentUtils.isEnchantmentTagged(enchantment, BzTags.ITEM_WITH_TELEPORT_ENCHANT)) {
                        isAllowTeleportItem = true;
                        break;
                    }
                    if (!user.method_5715() || !EnchantmentUtils.isEnchantmentTagged(enchantment, BzTags.ITEM_WITH_TELEPORT_ENCHANT_CROUCHING)) continue;
                    isAllowTeleportItem = true;
                    break;
                }
            }
            if (!isAllowTeleportItem) {
                return false;
            }
            boolean validBelowBlock = EntityTeleportationHookup.isValidBelowBlock(world, (class_1297)user, clickedPos);
            if (validBelowBlock) {
                if (user instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)user;
                    BzWorldSavedData.queueEntityToTeleport((class_1297)serverPlayer, BzDimension.BZ_WORLD_KEY);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isTeleportAllowedInDimension(class_1937 level) {
        if (!BzConfig.enableEntranceTeleportation || level.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            return false;
        }
        if (BzConfig.onlyOverworldHivesTeleports) {
            class_2960 defaultDimRL = new class_2960(BzConfig.defaultDimension);
            class_5321 worldKey = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)defaultDimRL);
            return level.method_27983().equals(worldKey);
        }
        return true;
    }

    private static void performTeleportation(class_1297 thrower, class_1297 projectile) {
        if (thrower instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)thrower;
            if (projectile != null) {
                if (class_2378.field_11145.method_10221((Object)projectile.method_5864()).method_12832().contains("pearl")) {
                    BzCriterias.TELEPORT_TO_BUMBLEZONE_PEARL_TRIGGER.trigger(serverPlayer);
                }
                projectile.method_5650(class_1297.class_5529.field_26999);
            }
            BzWorldSavedData.queueEntityToTeleport((class_1297)serverPlayer, BzDimension.BZ_WORLD_KEY);
        }
    }

    private static boolean isValidBelowBlock(class_1937 world, class_1297 playerEntity, class_2338 hivePos) {
        Optional blockTag = class_2378.field_11146.method_40266(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT);
        if (blockTag.isPresent() && ((class_6885.class_6888)blockTag.get()).method_40247() != 0) {
            if (world.method_8320(hivePos.method_10074()).method_26164(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT)) {
                return true;
            }
            if (BzConfig.warnPlayersOfWrongBlockUnderHive && playerEntity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)playerEntity;
                Bumblezone.LOGGER.info("Bumblezone: The attempt to teleport to Bumblezone failed due to not having a block from the following block tag below the hive: the_bumblezone:required_blocks_under_hive_to_teleport");
                class_5250 message = class_2561.method_43471((String)"system.the_bumblezone.require_hive_blocks_failed");
                serverPlayer.method_7353((class_2561)message, true);
            }
        } else {
            return true;
        }
        return false;
    }

    private static class_2338 getNearbyHivePos(class_243 hitBlockPos, class_1937 world) {
        double checkRadius = 0.5;
        for (double offset = -checkRadius; offset <= checkRadius; offset += checkRadius) {
            for (double offset2 = -checkRadius; offset2 <= checkRadius; offset2 += checkRadius) {
                for (double offset3 = -checkRadius; offset3 <= checkRadius; offset3 += checkRadius) {
                    class_2338 offsettedHitPos = new class_2338(hitBlockPos.method_1031(offset, offset2, offset3));
                    class_2680 block = world.method_8320(offsettedHitPos);
                    if (!EntityTeleportationBackend.isValidBeeHive(block)) continue;
                    return offsettedHitPos;
                }
            }
        }
        return null;
    }

    public static void runPistonPushed(class_2350 direction, class_1309 pushedEntity) {
        if (pushedEntity.field_6002.method_8608()) {
            return;
        }
        class_3218 world = (class_3218)pushedEntity.field_6002;
        if (BzConfig.enableEntranceTeleportation && !world.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID) && (!BzConfig.onlyOverworldHivesTeleports || world.method_27983().equals(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(BzConfig.defaultDimension))))) {
            if (BzWorldSavedData.isEntityQueuedToTeleportAlready((class_1297)pushedEntity)) {
                return;
            }
            class_2338.class_2339 entityPos = new class_2338.class_2339().method_10101((class_2382)pushedEntity.method_24515());
            class_2338[] blockPositions = new class_2338[]{entityPos, entityPos.method_10093(direction), entityPos.method_10093(class_2350.field_11036), entityPos.method_10093(class_2350.field_11036).method_10093(direction)};
            ArrayList<class_2680> belowHiveBlocks = new ArrayList<class_2680>();
            boolean isPushedIntoBeehive = false;
            for (class_2338 pos : blockPositions) {
                if (!EntityTeleportationBackend.isValidBeeHive(world.method_8320(pos))) continue;
                isPushedIntoBeehive = true;
                belowHiveBlocks.add(world.method_8320(pos.method_10074()));
            }
            if (isPushedIntoBeehive) {
                boolean validBelowBlock = false;
                Optional blockTag = class_2378.field_11146.method_40266(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT);
                if (blockTag.isPresent() && ((class_6885.class_6888)blockTag.get()).method_40247() != 0) {
                    for (class_2680 belowBlock : belowHiveBlocks) {
                        if (!belowBlock.method_26164(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT)) continue;
                        validBelowBlock = true;
                    }
                    if (!validBelowBlock && BzConfig.warnPlayersOfWrongBlockUnderHive) {
                        if (pushedEntity instanceof class_1657) {
                            class_1657 playerEntity = (class_1657)pushedEntity;
                            Bumblezone.LOGGER.log(Level.INFO, "Bumblezone: The attempt to teleport to Bumblezone failed due to not having a block from the following block tag below the hive: the_bumblezone:required_blocks_under_hive_to_teleport");
                            class_5250 message = class_2561.method_43471((String)"system.the_bumblezone.require_hive_blocks_failed");
                            playerEntity.method_7353((class_2561)message, true);
                        }
                        return;
                    }
                } else {
                    validBelowBlock = true;
                }
                if (validBelowBlock) {
                    if (pushedEntity instanceof class_3222) {
                        BzCriterias.TELEPORT_TO_BUMBLEZONE_PISTON_TRIGGER.trigger((class_3222)pushedEntity);
                    }
                    BzWorldSavedData.queueEntityToTeleport((class_1297)pushedEntity, BzDimension.BZ_WORLD_KEY);
                }
            }
        }
    }

    private static void checkAndCorrectStoredDimension(class_1309 livingEntity) {
        if (((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)livingEntity)).getNonBZDimension().equals((Object)Bumblezone.MOD_DIMENSION_ID) || BzConfig.forceExitToOverworld) {
            ((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)livingEntity)).setNonBZDimension(new class_2960(BzConfig.defaultDimension));
        }
    }
}

