/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.client.MusicHandler;
import com.telepathicgrunt.the_bumblezone.configs.BzConfig;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.the_bumblezone.items.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4466;
import net.minecraft.class_5138;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

public class BeeAggression {
    private static final Set<String> LIST_OF_BEE_HATING_NAMES = Set.of("bear", "panda", "wasp", "spider");
    private static final Set<class_1299<?>> SET_OF_BEE_HATED_NAMED_ENTITIES = new HashSet();
    private static final Set<class_1299<?>> SET_OF_BEE_NAMED_ENTITIES = new HashSet();

    public static void setupEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> BeeAggression.setupBeeHatingList());
        PlayerBlockBreakEvents.AFTER.register((world, playerEntity, blockPos, blockState, blockEntity) -> BeeAggression.blockBreakAnger(playerEntity, blockState.method_26204()));
    }

    public static void setupBeeHatingList() {
        if (SET_OF_BEE_HATED_NAMED_ENTITIES.size() != 0) {
            return;
        }
        if (SET_OF_BEE_NAMED_ENTITIES.size() != 0) {
            return;
        }
        for (Map.Entry entry : class_2378.field_11145.method_29722()) {
            String mobName = ((class_5321)entry.getKey()).method_29177().method_12832();
            if (mobName.contains("bee")) {
                SET_OF_BEE_NAMED_ENTITIES.add((class_1299)entry.getValue());
            }
            if (!LIST_OF_BEE_HATING_NAMES.stream().anyMatch(mobName::contains)) continue;
            SET_OF_BEE_HATED_NAMED_ENTITIES.add((class_1299)entry.getValue());
        }
    }

    public static void blockBreakAnger(class_1657 player, class_2248 block) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (block.method_9564().method_26164(BzTags.WRATH_ACTIVATING_BLOCKS_WHEN_MINED)) {
                BeeAggression.angerBees(serverPlayer);
            }
        }
    }

    public static void itemPickupAnger(class_1657 player, class_1792 item) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (item.method_7854().method_31573(BzTags.WRATH_ACTIVATING_ITEMS_WHEN_PICKED_UP)) {
                BeeAggression.angerBees(serverPlayer);
            }
        }
    }

    private static void angerBees(class_3222 player) {
        if ((player.field_6002.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID) || BzConfig.allowWrathOfTheHiveOutsideBumblezone) && BzConfig.aggressiveBees && !player.method_7337() && !player.method_7325()) {
            if (!player.method_6059(BzEffects.PROTECTION_OF_THE_HIVE)) {
                if (!EssenceOfTheBees.hasEssence(player) && player.field_6002.method_8407() != class_1267.field_5801) {
                    class_5250 message = class_2561.method_43471((String)"system.the_bumblezone.no_protection").method_27692(class_124.field_1067).method_27692(class_124.field_1061);
                    player.method_7353((class_2561)message, true);
                    player.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE, BzConfig.howLongWrathOfTheHiveLasts, 2, false, BzConfig.showWrathOfTheHiveParticles, true));
                }
            } else {
                BzCriterias.HONEY_PERMISSION_TRIGGER.trigger(player);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void beeHitAndAngered(class_1297 entity, class_1297 attackerEntity) {
        if (entity.field_6002.method_8608()) return;
        if (!(entity instanceof class_4466)) return;
        if (attackerEntity == null) return;
        if (attackerEntity.method_7325()) return;
        if (attackerEntity instanceof class_1657) {
            class_1657 player = (class_1657)attackerEntity;
            if (!((class_1657)attackerEntity).method_7337() && !attackerEntity.method_7325() && player.field_6002.method_8407() != class_1267.field_5801) {
                if (player.method_6059(BzEffects.PROTECTION_OF_THE_HIVE)) {
                    player.method_6016(BzEffects.PROTECTION_OF_THE_HIVE);
                    WrathOfTheHiveEffect.calmTheBees(player.field_6002, (class_1309)player);
                    return;
                }
                if (!entity.field_6002.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
                    if (!BzConfig.allowWrathOfTheHiveOutsideBumblezone) return;
                }
                if (!BzConfig.aggressiveBees) return;
                if (player instanceof class_3222 && player.method_6059(BzEffects.WRATH_OF_THE_HIVE)) {
                    BzCriterias.EXTENDED_WRATH_OF_THE_HIVE_TRIGGER.trigger((class_3222)player, attackerEntity);
                }
                player.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE, BzConfig.howLongWrathOfTheHiveLasts, 2, false, BzConfig.showWrathOfTheHiveParticles, true));
                return;
            }
        }
        if (!(attackerEntity instanceof class_1308)) return;
        class_1308 mob = (class_1308)attackerEntity;
        if (mob.method_6059(BzEffects.PROTECTION_OF_THE_HIVE)) {
            mob.method_6016(BzEffects.PROTECTION_OF_THE_HIVE);
            WrathOfTheHiveEffect.calmTheBees(mob.field_6002, (class_1309)mob);
            return;
        }
        if (!entity.field_6002.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            if (!BzConfig.allowWrathOfTheHiveOutsideBumblezone) return;
        }
        if (!BzConfig.aggressiveBees) return;
        mob.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE, BzConfig.howLongWrathOfTheHiveLasts, 2, false, true));
    }

    public static void entityTypeBeeAnger(class_1297 entity) {
        if (BeeAggression.doesBeesHateEntity(entity)) {
            ((class_1308)entity).method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE, BzConfig.howLongWrathOfTheHiveLasts, 1, false, true));
        }
    }

    public static boolean doesBeesHateEntity(class_1297 entity) {
        class_1308 mobEntity;
        if (entity != null && entity.field_6002 != null && !entity.field_6002.method_8608() && entity.field_6002.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID) && BzConfig.aggressiveBees && entity instanceof class_1308 && !(mobEntity = (class_1308)entity).method_5987()) {
            if (mobEntity.method_5864().method_20210(BzTags.FORCED_BEE_CALM_AT)) {
                return false;
            }
            if (mobEntity.method_5864().method_20210(BzTags.FORCED_BEE_ANGRY_AT)) {
                return true;
            }
            if (SET_OF_BEE_HATED_NAMED_ENTITIES.contains(entity.method_5864()) || !SET_OF_BEE_NAMED_ENTITIES.contains(entity.method_5864()) && mobEntity.method_6046() == class_1310.field_6293) {
                return !mobEntity.method_6059(BzEffects.WRATH_OF_THE_HIVE);
            }
        }
        return false;
    }

    public static boolean isBeelikeEntity(class_1297 entity) {
        return SET_OF_BEE_NAMED_ENTITIES.contains(entity.method_5864());
    }

    public static void playerTick(class_1657 playerEntity) {
        if (!playerEntity.field_6002.method_8608() && playerEntity.method_6059(BzEffects.WRATH_OF_THE_HIVE)) {
            if (playerEntity.field_6002.method_8407() == class_1267.field_5801) {
                playerEntity.method_6016(BzEffects.WRATH_OF_THE_HIVE);
                WrathOfTheHiveEffect.calmTheBees(playerEntity.field_6002, (class_1309)playerEntity);
            } else if (!BzConfig.allowWrathOfTheHiveOutsideBumblezone && !playerEntity.field_6002.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
                playerEntity.method_6016(BzEffects.WRATH_OF_THE_HIVE);
                WrathOfTheHiveEffect.calmTheBees(playerEntity.field_6002, (class_1309)playerEntity);
            }
        }
        if (playerEntity.field_6002.method_8608()) {
            boolean wrathEffect = playerEntity.method_6059(BzEffects.WRATH_OF_THE_HIVE);
            if (wrathEffect) {
                if (BzConfig.playWrathOfHiveEffectMusic) {
                    MusicHandler.playAngryBeeMusic(playerEntity);
                } else {
                    MusicHandler.stopAngryBeeMusic(playerEntity);
                }
            }
            if (!WrathOfTheHiveEffect.ACTIVE_WRATH && wrathEffect) {
                WrathOfTheHiveEffect.ACTIVE_WRATH = true;
            } else if (WrathOfTheHiveEffect.ACTIVE_WRATH && !wrathEffect) {
                MusicHandler.stopAngryBeeMusic(playerEntity);
                WrathOfTheHiveEffect.calmTheBees(playerEntity.field_6002, (class_1309)playerEntity);
                WrathOfTheHiveEffect.ACTIVE_WRATH = false;
            }
        }
    }

    public static void applyAngerIfInTaggedStructures(class_3222 serverPlayer) {
        if (serverPlayer.method_7337() || serverPlayer.method_7325() || !BzConfig.aggressiveBees || serverPlayer.field_6002.method_8407() == class_1267.field_5801) {
            return;
        }
        class_5138 structureManager = ((class_3218)serverPlayer.field_6002).method_27056();
        if (structureManager.method_41413(serverPlayer.method_24515(), BzTags.WRATH_CAUSING).method_16657() && !serverPlayer.method_6059(BzEffects.PROTECTION_OF_THE_HIVE)) {
            if (!serverPlayer.method_6059(BzEffects.WRATH_OF_THE_HIVE)) {
                class_5250 message = class_2561.method_43471((String)"system.the_bumblezone.no_protection").method_27692(class_124.field_1067).method_27692(class_124.field_1061);
                serverPlayer.method_7353((class_2561)message, true);
            }
            serverPlayer.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE, BzConfig.howLongWrathOfTheHiveLasts, 2, false, BzConfig.showWrathOfTheHiveParticles, true));
        }
    }

    public static void preventAngerOnEssencedPlayers(List<class_4466> beeList, List<class_1657> playerList) {
        for (int i = playerList.size() - 1; i >= 0; --i) {
            class_3222 serverPlayer;
            class_1657 player = playerList.get(i);
            if (!(player instanceof class_3222) || !EssenceOfTheBees.hasEssence(serverPlayer = (class_3222)player)) continue;
            for (class_4466 bee : beeList) {
                if (bee.method_5968() != player) continue;
                bee.method_5980(null);
            }
            playerList.remove(i);
        }
    }

    public static void preventAngerOnEssencedPlayers(class_1657 player, List<class_1297> entityList) {
        class_3222 serverPlayer;
        if (player != null && player.field_6002.method_8608() || player instanceof class_3222 && EssenceOfTheBees.hasEssence(serverPlayer = (class_3222)player)) {
            entityList.clear();
        }
    }
}

