/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client;

import com.telepathicgrunt.the_bumblezone.client.BeehemothControls;
import com.telepathicgrunt.the_bumblezone.client.items.HoneyCompassItemProperty;
import com.telepathicgrunt.the_bumblezone.client.items.IncenseCandleColoring;
import com.telepathicgrunt.the_bumblezone.client.particles.HoneyParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.PollenPuffParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.RoyalJellyParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.SparkleParticle;
import com.telepathicgrunt.the_bumblezone.client.rendering.FluidRender;
import com.telepathicgrunt.the_bumblezone.client.rendering.beearmor.BeeArmorModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beehemoth.BeehemothModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beehemoth.BeehemothRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.beequeen.BeeQueenModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beequeen.BeeQueenRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.beestinger.BeeStingerModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beestinger.BeeStingerRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.honeycrystalshard.HoneyCrystalShardModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.honeycrystalshard.HoneyCrystalShardRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.honeyslime.HoneySlimeRendering;
import com.telepathicgrunt.the_bumblezone.client.rendering.stingerspear.StingerSpearModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.stingerspear.StingerSpearRenderer;
import com.telepathicgrunt.the_bumblezone.items.BeeCannon;
import com.telepathicgrunt.the_bumblezone.items.CrystalCannon;
import com.telepathicgrunt.the_bumblezone.items.StinglessBeeHelmet;
import com.telepathicgrunt.the_bumblezone.mixin.client.DimensionSpecialEffectsAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzMenuTypes;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.packets.CrystallineFlowerEnchantmentPacket;
import com.telepathicgrunt.the_bumblezone.packets.MobEffectClientSyncPacket;
import com.telepathicgrunt.the_bumblezone.packets.QueenMainTradesSyncPacket;
import com.telepathicgrunt.the_bumblezone.packets.QueenRandomizerTradesSyncPacket;
import com.telepathicgrunt.the_bumblezone.packets.UpdateFallingBlockPacket;
import com.telepathicgrunt.the_bumblezone.screens.CrystallineFlowerScreen;
import com.telepathicgrunt.the_bumblezone.screens.StrictChestScreen;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzSkyProperty;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3611;
import net.minecraft.class_3929;
import net.minecraft.class_5272;
import net.minecraft.class_5601;
import net.minecraft.class_6395;
import net.minecraft.class_953;

@Environment(value=EnvType.CLIENT)
public class BumblezoneClient
implements ClientModInitializer {
    public static final class_2960 SUGAR_WATER_FLUID_STILL = new class_2960("the_bumblezone", "block/sugar_water_still");
    public static final class_2960 SUGAR_WATER_FLUID_FLOWING = new class_2960("the_bumblezone", "block/sugar_water_flow");
    public static final class_2960 HONEY_FLUID_STILL = new class_2960("the_bumblezone", "block/honey_fluid_still");
    public static final class_2960 HONEY_FLUID_FLOWING = new class_2960("the_bumblezone", "block/honey_fluid_flow");
    public static final class_2960 ROYAL_JELLY_FLUID_STILL = new class_2960("the_bumblezone", "block/royal_jelly_fluid_still");
    public static final class_2960 ROYAL_JELLY_FLOWING = new class_2960("the_bumblezone", "block/royal_jelly_fluid_flow");

    public void onInitializeClient() {
        DimensionSpecialEffectsAccessor.thebumblezone_getBY_IDENTIFIER().put((Object)new class_2960("the_bumblezone", "sky_property"), (Object)new BzSkyProperty());
        IncenseCandleColoring.registerBlockColors();
        IncenseCandleColoring.registerItemColors();
        this.registerFluidRenders();
        BumblezoneClient.registerRenderLayers();
        this.registerParticleFactories();
        this.registerEntityRenders();
        this.registerModelLayers();
        this.registerItemPredicates();
        this.registerArmorRenderers();
        this.registerScreens();
        this.registerKeybinds();
        UpdateFallingBlockPacket.registerPacket();
        MobEffectClientSyncPacket.registerPacket();
        CrystallineFlowerEnchantmentPacket.registerPacket();
        QueenMainTradesSyncPacket.registerPacket();
        QueenRandomizerTradesSyncPacket.registerPacket();
        ClientTickEvents.END_CLIENT_TICK.register(minecraft -> StinglessBeeHelmet.decrementHighlightingCounter((class_1657)minecraft.field_1724));
    }

    private void registerEntityRenders() {
        EntityRendererRegistry.register(BzEntities.POLLEN_PUFF_ENTITY, class_953::new);
        EntityRendererRegistry.register(BzEntities.HONEY_SLIME, HoneySlimeRendering::new);
        EntityRendererRegistry.register(BzEntities.BEEHEMOTH, BeehemothRenderer::new);
        EntityRendererRegistry.register(BzEntities.BEE_QUEEN, BeeQueenRenderer::new);
        EntityRendererRegistry.register(BzEntities.THROWN_STINGER_SPEAR_ENTITY, StingerSpearRenderer::new);
        EntityRendererRegistry.register(BzEntities.BEE_STINGER_ENTITY, BeeStingerRenderer::new);
        EntityRendererRegistry.register(BzEntities.HONEY_CRYSTAL_SHARD, HoneyCrystalShardRenderer::new);
    }

    private void registerParticleFactories() {
        ParticleFactoryRegistry.getInstance().register((class_2396)BzParticles.POLLEN_PARTICLE, PollenPuffParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)BzParticles.HONEY_PARTICLE, HoneyParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)BzParticles.ROYAL_JELLY_PARTICLE, RoyalJellyParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)BzParticles.SPARKLE_PARTICLE, SparkleParticle.Factory::new);
    }

    private void registerFluidRenders() {
        FluidRender.setupFluidRendering((class_3611)BzFluids.SUGAR_WATER_FLUID, (class_3611)BzFluids.SUGAR_WATER_FLUID_FLOWING, SUGAR_WATER_FLUID_STILL, SUGAR_WATER_FLUID_FLOWING, true);
        FluidRender.setupFluidRendering((class_3611)BzFluids.HONEY_FLUID, (class_3611)BzFluids.HONEY_FLUID_FLOWING, HONEY_FLUID_STILL, HONEY_FLUID_FLOWING, false);
        FluidRender.setupFluidRendering((class_3611)BzFluids.ROYAL_JELLY_FLUID, (class_3611)BzFluids.ROYAL_JELLY_FLUID_FLOWING, ROYAL_JELLY_FLUID_STILL, ROYAL_JELLY_FLOWING, false);
    }

    private void registerModelLayers() {
        EntityModelLayerRegistry.registerModelLayer((class_5601)BeehemothModel.LAYER_LOCATION, BeehemothModel::createBodyLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)BeeQueenModel.LAYER_LOCATION, BeeQueenModel::createBodyLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)StingerSpearModel.LAYER_LOCATION, StingerSpearModel::createLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)BeeStingerModel.LAYER_LOCATION, BeeStingerModel::createLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)HoneyCrystalShardModel.LAYER_LOCATION, HoneyCrystalShardModel::createLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)BeeArmorModel.VARIANT_1_LAYER_LOCATION, BeeArmorModel::createVariant1);
        EntityModelLayerRegistry.registerModelLayer((class_5601)BeeArmorModel.VARIANT_2_LAYER_LOCATION, BeeArmorModel::createVariant2);
    }

    private void registerItemPredicates() {
        class_5272.method_27879((class_1792)BzItems.HONEY_CRYSTAL_SHIELD, (class_2960)new class_2960("blocking"), (itemStack, world, livingEntity, int1) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)BzItems.STINGER_SPEAR, (class_2960)new class_2960("throwing"), (itemStack, world, livingEntity, int1) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)BzItems.HONEY_COMPASS, (class_2960)new class_2960("angle"), (class_6395)HoneyCompassItemProperty.getClampedItemPropertyFunction());
        class_5272.method_27879((class_1792)BzItems.BEE_CANNON, (class_2960)new class_2960("primed"), (itemStack, world, livingEntity, int1) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)BzItems.CRYSTAL_CANNON, (class_2960)new class_2960("primed"), (itemStack, world, livingEntity, int1) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)BzItems.BEE_CANNON, (class_2960)new class_2960("bee_count"), (itemStack, world, livingEntity, int1) -> (float)BeeCannon.getNumberOfBees(itemStack) / 10.0f);
        class_5272.method_27879((class_1792)BzItems.CRYSTAL_CANNON, (class_2960)new class_2960("crystal_count"), (itemStack, world, livingEntity, int1) -> (float)CrystalCannon.getNumberOfCrystals(itemStack) / 10.0f);
        class_5272.method_27879((class_1792)BzItems.HONEYCOMB_BROOD, (class_2960)new class_2960("is_creative_tab_icon"), (itemStack, world, livingEntity, integer) -> itemStack.method_7985() && itemStack.method_7969().method_10577("isCreativeTabIcon") ? 1.0f : 0.0f);
    }

    private void registerArmorRenderers() {
        BzItems.STINGLESS_BEE_HELMET_1.registerRenderer().run();
        BzItems.STINGLESS_BEE_HELMET_2.registerRenderer().run();
        BzItems.BUMBLE_BEE_CHESTPLATE_1.registerRenderer().run();
        BzItems.BUMBLE_BEE_CHESTPLATE_2.registerRenderer().run();
        BzItems.TRANS_BUMBLE_BEE_CHESTPLATE_1.registerRenderer().run();
        BzItems.TRANS_BUMBLE_BEE_CHESTPLATE_2.registerRenderer().run();
        BzItems.HONEY_BEE_LEGGINGS_1.registerRenderer().run();
        BzItems.HONEY_BEE_LEGGINGS_2.registerRenderer().run();
        BzItems.CARPENTER_BEE_BOOTS_1.registerRenderer().run();
        BzItems.CARPENTER_BEE_BOOTS_2.registerRenderer().run();
    }

    private void registerScreens() {
        class_3929.method_17542(BzMenuTypes.STRICT_9x1, StrictChestScreen::new);
        class_3929.method_17542(BzMenuTypes.STRICT_9x2, StrictChestScreen::new);
        class_3929.method_17542(BzMenuTypes.STRICT_9x3, StrictChestScreen::new);
        class_3929.method_17542(BzMenuTypes.STRICT_9x4, StrictChestScreen::new);
        class_3929.method_17542(BzMenuTypes.STRICT_9x5, StrictChestScreen::new);
        class_3929.method_17542(BzMenuTypes.STRICT_9x6, StrictChestScreen::new);
        class_3929.method_17542(BzMenuTypes.CRYSTALLINE_FLOWER, CrystallineFlowerScreen::new);
    }

    private void registerKeybinds() {
        KeyBindingHelper.registerKeyBinding((class_304)BeehemothControls.KEY_BIND_BEEHEMOTH_UP);
        KeyBindingHelper.registerKeyBinding((class_304)BeehemothControls.KEY_BIND_BEEHEMOTH_DOWN);
    }

    public static void registerRenderLayers() {
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STICKY_HONEY_REDSTONE, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STICKY_HONEY_RESIDUE, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.HONEY_WEB, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.REDSTONE_HONEY_WEB, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.SUPER_CANDLE_WICK, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.SUPER_CANDLE_WICK_SOUL, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.INCENSE_BASE_CANDLE, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.CRYSTALLINE_FLOWER, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_BLACK, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_BLUE, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_BROWN, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_CYAN, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_GRAY, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_GREEN, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_LIGHT_BLUE, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_LIGHT_GRAY, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_LIME, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_MAGENTA, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_ORANGE, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_PINK, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_PURPLE, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_RED, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_WHITE, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.STRING_CURTAIN_YELLOW, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.HONEY_CRYSTAL, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.GLISTERING_HONEY_CRYSTAL, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock(BzBlocks.ROYAL_JELLY_BLOCK, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock(BzFluids.SUGAR_WATER_BLOCK, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putFluid((class_3611)BzFluids.SUGAR_WATER_FLUID, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putFluid((class_3611)BzFluids.SUGAR_WATER_FLUID_FLOWING, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock(BzFluids.HONEY_FLUID_BLOCK, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putFluid((class_3611)BzFluids.HONEY_FLUID, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putFluid((class_3611)BzFluids.HONEY_FLUID_FLOWING, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock(BzFluids.ROYAL_JELLY_FLUID_BLOCK, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putFluid((class_3611)BzFluids.ROYAL_JELLY_FLUID, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putFluid((class_3611)BzFluids.ROYAL_JELLY_FLUID_FLOWING, class_1921.method_23583());
    }
}

