/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.blockentities;

import com.telepathicgrunt.the_bumblezone.blocks.CrystallineFlower;
import com.telepathicgrunt.the_bumblezone.configs.BzConfig;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.UUID;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4538;

public class CrystallineFlowerBlockEntity
extends class_2586 {
    public static String TIER_TAG = "tier";
    public static String XP_TAG = "xp";
    public static String GUID_TAG = "guid";
    private int xpTier = 1;
    private int currentXp = 0;
    private String guid = UUID.randomUUID().toString();

    protected CrystallineFlowerBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public CrystallineFlowerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        this(BzBlockEntities.CRYSTALLINE_FLOWER, blockPos, blockState);
    }

    public int getXpTier() {
        return this.xpTier;
    }

    public void setXpTier(int xpTier) {
        this.xpTier = xpTier;
    }

    public int getCurrentXp() {
        return this.currentXp;
    }

    public void setCurrentXp(int currentXp) {
        this.currentXp = currentXp;
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.xpTier = compoundTag.method_10550(TIER_TAG);
        this.currentXp = Math.min(compoundTag.method_10550(XP_TAG), this.getMaxXpForTier(this.xpTier));
        this.guid = compoundTag.method_10558(GUID_TAG);
        if (this.guid.isEmpty()) {
            this.guid = UUID.randomUUID().toString();
        }
    }

    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        this.saveFieldsToTag(compoundTag);
    }

    private void saveFieldsToTag(class_2487 compoundTag) {
        compoundTag.method_10569(TIER_TAG, this.xpTier);
        compoundTag.method_10569(XP_TAG, this.currentXp);
        compoundTag.method_10582(GUID_TAG, this.guid);
    }

    public void method_38240(class_1799 stack) {
        class_2487 compoundTag = new class_2487();
        this.method_11007(compoundTag);
        class_1747.method_38073((class_1799)stack, (class_2591)this.method_11017(), (class_2487)compoundTag);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.saveFieldsToTag(tag);
        return tag;
    }

    public void addXpAndTier(int xpChange) {
        this.currentXp += xpChange;
        int tierChange = 0;
        while (this.currentXp >= this.getMaxXpForTier(this.xpTier) && !this.isMaxTier()) {
            this.currentXp -= this.getMaxXpForTier(this.xpTier);
            ++tierChange;
            ++this.xpTier;
        }
        while (this.currentXp < 0 && !this.isMinTier()) {
            this.currentXp += this.getMaxXpForTier(this.xpTier);
            --tierChange;
            --this.xpTier;
        }
        if (this.isMaxTier()) {
            this.currentXp = 0;
        }
        if (this.currentXp >= this.getMaxXpForTier(this.xpTier)) {
            this.currentXp = this.getMaxXpForTier(this.xpTier);
        } else if (this.currentXp < 0) {
            this.currentXp = 0;
        }
        this.method_5431();
        this.setPillar(tierChange);
    }

    public void increaseTier(int tierIncrease) {
        int tierChange = Math.min(7 - this.xpTier, tierIncrease);
        if (!this.isMaxTier()) {
            this.xpTier += tierIncrease;
        } else {
            this.currentXp = this.getMaxXpForTier(this.xpTier);
        }
        if (this.currentXp >= this.getMaxXpForTier(this.xpTier) && !this.isMaxTier()) {
            this.currentXp = this.getMaxXpForTier(this.xpTier) - 1;
        }
        this.method_5431();
        this.setPillar(tierChange);
    }

    public void decreaseTier(int tierDecrease) {
        int tierChange = Math.min(this.xpTier - 1, tierDecrease);
        if (!this.isMinTier()) {
            this.xpTier -= tierDecrease;
        }
        if (this.currentXp >= this.getMaxXpForTier(this.xpTier) && !this.isMaxTier()) {
            this.currentXp = this.getMaxXpForTier(this.xpTier) - 1;
        }
        this.method_5431();
        this.setPillar(-tierChange);
    }

    public void setPillar(int tierChange) {
        if (this.field_11863 != null && tierChange != 0) {
            int bottomHeight = CrystallineFlower.flowerHeightBelow((class_4538)this.field_11863, this.method_11016());
            class_2338 operatingPos = this.method_11016().method_10087(bottomHeight);
            int topHeight = CrystallineFlower.flowerHeightAbove((class_4538)this.field_11863, operatingPos);
            class_2586 blockEntity = this.field_11863.method_8321(operatingPos);
            if (blockEntity instanceof CrystallineFlowerBlockEntity) {
                class_2586 targetBlockEntity;
                CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
                if (bottomHeight != 0 && (targetBlockEntity = this.field_11863.method_8321(this.method_11016().method_10087(bottomHeight))) instanceof CrystallineFlowerBlockEntity) {
                    targetBlockEntity.method_11014(crystallineFlowerBlockEntity.method_16887());
                }
                boolean upward = tierChange > 0;
                for (int i = 0; i < (upward ? this.xpTier : topHeight + 1); ++i) {
                    boolean placePlant = upward || i < this.xpTier;
                    this.field_11863.method_8652(operatingPos.method_10086(i), placePlant ? BzBlocks.CRYSTALLINE_FLOWER.method_9564() : class_2246.field_10124.method_9564(), 2);
                    class_1937 class_19372 = this.field_11863;
                    if (!(class_19372 instanceof class_3218)) continue;
                    class_3218 serverLevel = (class_3218)class_19372;
                    if (placePlant) continue;
                    int itemsToDrop = 0;
                    while ((double)itemsToDrop < 2.0 + (double)i / 1.5) {
                        class_1799 stack = BzItems.HONEY_CRYSTAL_SHARDS.method_7854();
                        stack.method_7939(1);
                        GeneralUtils.spawnItemEntity(serverLevel, operatingPos.method_10086(i), stack, 0.05, 0.2);
                        ++itemsToDrop;
                    }
                }
                operatingPos = operatingPos.method_10086(upward ? this.xpTier - 1 : topHeight + tierChange);
                this.field_11863.method_8652(operatingPos, (class_2680)BzBlocks.CRYSTALLINE_FLOWER.method_9564().method_11657((class_2769)CrystallineFlower.FLOWER, (Comparable)Boolean.valueOf(true)), 2);
                class_2586 blockEntity2 = this.field_11863.method_8321(operatingPos);
                if (blockEntity2 instanceof CrystallineFlowerBlockEntity) {
                    CrystallineFlowerBlockEntity crystallineFlowerBlockEntity2 = (CrystallineFlowerBlockEntity)blockEntity2;
                    crystallineFlowerBlockEntity2.method_11014(crystallineFlowerBlockEntity.method_16887());
                }
            }
            for (int i = 0; i < topHeight; ++i) {
                class_2338 updatePos = operatingPos.method_10086(i);
                class_2680 state = this.field_11863.method_8320(updatePos);
                this.field_11863.method_8452(updatePos, state.method_26204());
            }
        }
    }

    public boolean isMaxXP() {
        return this.currentXp == this.getMaxXpForTier(this.xpTier);
    }

    public boolean isMinXP() {
        return this.currentXp == 0;
    }

    public boolean isMaxTier() {
        return this.xpTier == 7;
    }

    public boolean isMinTier() {
        return this.xpTier == 0;
    }

    public int getMaxXpForTier(int tier) {
        return Math.max(1, 45 + tier * tier * 14 + BzConfig.crystallineFlowerExtraXpNeededForTiers);
    }

    public int getXpForNextTiers(int nextTiersToCalculate) {
        int totalXpNeeded = 0;
        for (int i = 0; i < nextTiersToCalculate; ++i) {
            if (i == 0) {
                totalXpNeeded += this.getMaxXpForTier(this.xpTier) - this.currentXp;
                continue;
            }
            if (this.xpTier + i > 7) continue;
            totalXpNeeded += this.getMaxXpForTier(this.xpTier + i);
        }
        return totalXpNeeded;
    }
}

