/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.entities.mobs.BeehemothEntity;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.PollenPuffEntity;
import com.telepathicgrunt.the_bumblezone.items.HoneyBeeLeggings;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.FallingBlockEntityAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.BeeEntityInvoker;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.class_10;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1440;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2968;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_4466;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class PileOfPollen
extends class_2346 {
    public static final class_2758 LAYERS = class_2741.field_12536;
    protected static final class_265[] SHAPE_BY_LAYER = new class_265[]{class_259.method_1073(), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    protected static final class_238[] SHAPE_AABB_BY_LAYER = new class_238[]{class_238.method_30048((class_243)new class_243(0.0, 0.0, 0.0), (double)0.0, (double)0.0, (double)0.0), SHAPE_BY_LAYER[1].method_1107().method_1014((double)0.1f), SHAPE_BY_LAYER[2].method_1107().method_1014((double)0.1f), SHAPE_BY_LAYER[3].method_1107().method_1014((double)0.1f), SHAPE_BY_LAYER[4].method_1107().method_1014((double)0.1f), SHAPE_BY_LAYER[5].method_1107().method_1014((double)0.1f), SHAPE_BY_LAYER[6].method_1107().method_1014((double)0.1f), SHAPE_BY_LAYER[7].method_1107().method_1014((double)0.1f), SHAPE_BY_LAYER[8].method_1107().method_1014((double)0.1f)};
    private class_1792 item;

    public PileOfPollen() {
        super(class_4970.class_2251.method_9637((class_3614)BzBlocks.YELLOW_NOT_SOLID).method_26245((blockState, world, blockPos) -> true).method_22488().method_9632(0.1f).method_9626(class_2498.field_11548));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> blockStateBuilder) {
        blockStateBuilder.method_11667(new class_2769[]{LAYERS});
    }

    public class_1799 method_9574(class_1922 world, class_2338 blockPos, class_2680 blockState) {
        return new class_1799((class_1935)BzItems.POLLEN_PUFF);
    }

    public class_1792 method_8389() {
        if (this.item == null) {
            this.item = BzItems.POLLEN_PUFF;
        }
        return this.item;
    }

    public boolean method_9516(class_2680 blockState, class_1922 world, class_2338 blockPos, class_10 pathType) {
        return true;
    }

    public class_265 method_9530(class_2680 blockState, class_1922 world, class_2338 blockPos, class_3726 selectionContext) {
        return SHAPE_BY_LAYER[(Integer)blockState.method_11654((class_2769)LAYERS)];
    }

    public static class_238 getAABBShape(class_2680 blockState) {
        return SHAPE_AABB_BY_LAYER[(Integer)blockState.method_11654((class_2769)LAYERS)];
    }

    public class_265 method_9549(class_2680 blockState, class_1922 world, class_2338 blockPos, class_3726 selectionContext) {
        return class_259.method_1073();
    }

    public class_265 method_25959(class_2680 blockState, class_1922 world, class_2338 blockPos) {
        return SHAPE_BY_LAYER[(Integer)blockState.method_11654((class_2769)LAYERS)];
    }

    public class_265 method_26159(class_2680 blockState, class_1922 world, class_2338 blockPos, class_3726 selectionContext) {
        return SHAPE_BY_LAYER[(Integer)blockState.method_11654((class_2769)LAYERS)];
    }

    public boolean method_9526(class_2680 blockState) {
        return true;
    }

    public boolean method_9558(class_2680 blockState, class_4538 world, class_2338 blockPos) {
        class_2680 blockstate = world.method_8320(blockPos.method_10074());
        if (blockstate.method_27852(class_2246.field_10295) || blockstate.method_27852(class_2246.field_10225) || blockstate.method_27852(class_2246.field_10499) || !world.method_8320(blockPos).method_26227().method_15769()) {
            return false;
        }
        if (blockstate.method_26215() || blockstate.method_27852(BzBlocks.PILE_OF_POLLEN) || blockstate.method_27852(class_2246.field_21211) || blockstate.method_27852(class_2246.field_10114)) {
            return true;
        }
        return class_2248.method_9501((class_265)blockstate.method_26220((class_1922)world, blockPos.method_10074()), (class_2350)class_2350.field_11036);
    }

    public class_2680 method_9559(class_2680 oldBlockState, class_2350 direction, class_2680 newBlockState, class_1936 world, class_2338 blockPos, class_2338 blockPos1) {
        return !oldBlockState.method_26184((class_4538)world, blockPos) ? class_2246.field_10124.method_9564() : super.method_9559(oldBlockState, direction, newBlockState, world, blockPos, blockPos1);
    }

    public void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 random) {
        if (PileOfPollen.canFall(serverLevel.method_8320(blockPos.method_10074())) && blockPos.method_10264() >= serverLevel.method_31607()) {
            class_1540 fallingblockentity = new class_1540((class_1937)serverLevel, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5, serverLevel.method_8320(blockPos));
            serverLevel.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
            this.method_10132(fallingblockentity);
            serverLevel.method_8649((class_1297)fallingblockentity);
        }
    }

    private static boolean canFall(class_2680 blockState) {
        class_3614 material = blockState.method_26207();
        boolean isFullPollenPile = blockState.method_27852(BzBlocks.PILE_OF_POLLEN) && (Integer)blockState.method_11654((class_2769)LAYERS) == 8;
        return !isFullPollenPile && (blockState.method_26215() || blockState.method_26164(class_3481.field_21952) || material.method_15797() || material.method_15800());
    }

    public boolean method_9616(class_2680 blockState, class_1750 itemPlacementContext) {
        int layerValue = (Integer)blockState.method_11654((class_2769)LAYERS);
        if (itemPlacementContext.method_8041().method_7909() == this.method_8389() && layerValue < 8) {
            if (!(itemPlacementContext instanceof class_2968) && itemPlacementContext.method_7717()) {
                return itemPlacementContext.method_8038() == class_2350.field_11036;
            }
            return true;
        }
        return layerValue == 1;
    }

    public class_2680 method_9605(class_1750 itemPlacementContext) {
        class_2680 blockState = itemPlacementContext.method_8045().method_8320(itemPlacementContext.method_8037());
        if (blockState.method_27852((class_2248)this)) {
            int layerValue = (Integer)blockState.method_11654((class_2769)LAYERS);
            return (class_2680)blockState.method_11657((class_2769)LAYERS, (Comparable)Integer.valueOf(Math.min(8, layerValue + 1)));
        }
        return super.method_9605(itemPlacementContext);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 blockState, class_1937 worldIn, class_2338 pos) {
        return (Integer)blockState.method_11654((class_2769)LAYERS);
    }

    public void method_9585(class_1936 world, class_2338 blockPos, class_2680 blockState) {
        if (world.method_8608()) {
            for (int i = 0; i < 50; ++i) {
                PileOfPollen.spawnParticles(blockState, world, blockPos, world.method_8409(), true);
                PileOfPollen.spawnParticles(world, class_243.method_24953((class_2382)blockPos), world.method_8409(), 0.055, 0.0075, 0.0);
            }
        }
    }

    public void method_9548(class_2680 blockState, class_1937 world, class_2338 blockPos, class_1297 entity) {
        if (!blockState.method_27852(BzBlocks.PILE_OF_POLLEN)) {
            return;
        }
        if (entity instanceof class_1540) {
            if (((class_1540)entity).method_6962().method_26215() || world.method_8608()) {
                return;
            }
            if (((class_1540)entity).method_6962().method_27852(BzBlocks.PILE_OF_POLLEN)) {
                PileOfPollen.stackPollen(blockState, world, blockPos, ((class_1540)entity).method_6962());
                entity.method_5650(class_1297.class_5529.field_26999);
                ((FallingBlockEntityAccessor)entity).setBlock(class_2246.field_10124.method_9564());
            } else {
                world.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
                if (world.method_8608()) {
                    for (int i = 0; i < (Integer)blockState.method_11654((class_2769)LAYERS) * 30; ++i) {
                        PileOfPollen.spawnParticles(blockState, (class_1936)world, blockPos, world.field_9229, true);
                    }
                }
            }
        } else if (entity instanceof PollenPuffEntity) {
            PollenPuffEntity pollenPuffEntity = (PollenPuffEntity)entity;
            if (pollenPuffEntity.isConsumed() || !GeneralUtils.isPermissionAllowedAtSpot(world, pollenPuffEntity.method_24921(), blockPos, true)) {
                return;
            }
            PileOfPollen.stackPollen(blockState, world, blockPos, BzBlocks.PILE_OF_POLLEN.method_9564());
            pollenPuffEntity.method_5650(class_1297.class_5529.field_26999);
            pollenPuffEntity.consumed();
            if (world.method_8608()) {
                for (int i = 0; i < 50; ++i) {
                    PileOfPollen.spawnParticles((class_1936)world, pollenPuffEntity.method_19538(), world.field_9229, 0.055, 0.0075, 0.0);
                }
            }
        } else if (!(entity instanceof class_1303)) {
            class_1309 livingEntity;
            double entitySpeed;
            int layerValueMinusOne = (Integer)blockState.method_11654((class_2769)LAYERS) - 1;
            double speedReduction = entity instanceof class_1676 ? 0.85 : 1.0 - (double)layerValueMinusOne * 0.1;
            double chance = 0.22 + (double)layerValueMinusOne * 0.09;
            class_1799 beeLeggings = HoneyBeeLeggings.getEntityBeeLegging(entity);
            if (!beeLeggings.method_7960()) {
                speedReduction = Math.max(0.9, speedReduction);
            }
            class_243 deltaMovement = entity.method_18798();
            double newYDelta = deltaMovement.field_1351;
            if (entity instanceof class_3222 && entity.field_6017 > 18.0f && newYDelta < -0.9 && (Integer)blockState.method_11654((class_2769)LAYERS) >= 7) {
                BzCriterias.FALLING_ON_POLLEN_BLOCK_TRIGGER.trigger((class_3222)entity);
            }
            newYDelta = deltaMovement.field_1351 > 0.0 ? (newYDelta *= 1.0 - (double)layerValueMinusOne * 0.01) : (newYDelta *= 0.84 - (double)layerValueMinusOne * 0.03);
            if (!(entity instanceof class_4466) && !(entity instanceof BeehemothEntity)) {
                entity.method_18799(new class_243(deltaMovement.field_1352 * speedReduction, newYDelta, deltaMovement.field_1350 * speedReduction));
            }
            if ((entitySpeed = entity.method_18798().method_1033()) > 1.0E-5 && (double)world.field_9229.method_43057() < chance) {
                int particleStrength;
                int particleNumber = (int)(entitySpeed / 0.0045);
                int n = particleStrength = entity instanceof class_1542 ? Math.min(10, particleNumber / 3) : Math.min(20, particleNumber);
                if (world.method_8608()) {
                    for (int i = 0; i < particleNumber; ++i) {
                        if (particleNumber > 5) {
                            PileOfPollen.spawnParticles(blockState, (class_1936)world, blockPos, world.field_9229, true);
                        }
                        PileOfPollen.spawnParticles((class_1936)world, entity.method_19538().method_1019(entity.method_18798().method_18805(2.0, 2.0, 2.0)).method_1031(0.0, 0.75, 0.0), world.field_9229, 0.006 * (double)particleStrength, 7.5E-4 * (double)particleStrength, 0.006 * (double)particleStrength);
                    }
                } else if (!(entity instanceof class_1657) && !(entity instanceof class_1542)) {
                    PileOfPollen.spawnParticlesServer((class_1936)world, entity.method_19538().method_1019(entity.method_18798().method_18805(2.0, 2.0, 2.0)).method_1031(0.0, 0.75, 0.0), world.field_9229, 0.006 * (double)particleStrength, 7.5E-4 * (double)particleStrength, 0.006 * (double)particleStrength, particleNumber);
                }
            }
            if (entity instanceof class_4466 && !((class_4466)entity).method_21784() && entity.method_5864().method_20210(BzTags.POLLEN_PUFF_CAN_POLLINATE)) {
                ((BeeEntityInvoker)entity).callSetHasNectar(true);
                ((class_4466)entity).method_21780();
                if (layerValueMinusOne == 0) {
                    world.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
                } else {
                    world.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)LAYERS, (Comparable)Integer.valueOf(layerValueMinusOne)), 3);
                }
            }
            if (entity instanceof class_1440) {
                class_1440 pandaEntity = (class_1440)entity;
                PileOfPollen.pandaSneezing(pandaEntity);
            }
            if (entity instanceof class_1309 && !(livingEntity = (class_1309)entity).method_6059(BzEffects.HIDDEN)) {
                PileOfPollen.applyHiddenEffectIfBuried(livingEntity, blockState, blockPos);
            }
        }
    }

    public static void reapplyHiddenEffectIfInsidePollenPile(class_1309 livingEntity) {
        class_238 aabb = livingEntity.method_5829();
        class_1937 level = livingEntity.field_6002;
        class_2338 minCorner = new class_2338(aabb.field_1323 + 0.001, aabb.field_1322 + 0.001, aabb.field_1321 + 0.001);
        class_2338 maxCorner = new class_2338(aabb.field_1320 - 0.001, aabb.field_1325 - 0.001, aabb.field_1324 - 0.001);
        if (level.method_22343(minCorner, maxCorner)) {
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            for (int x = minCorner.method_10263(); x <= maxCorner.method_10263(); ++x) {
                for (int y = minCorner.method_10264(); y <= maxCorner.method_10264(); ++y) {
                    for (int z = minCorner.method_10260(); z <= maxCorner.method_10260(); ++z) {
                        mutableBlockPos.method_10103(x, y, z);
                        class_2680 blockState = level.method_8320((class_2338)mutableBlockPos);
                        if (!blockState.method_27852(BzBlocks.PILE_OF_POLLEN)) continue;
                        PileOfPollen.applyHiddenEffectIfBuried(livingEntity, blockState, (class_2338)mutableBlockPos);
                    }
                }
            }
        }
    }

    private static void applyHiddenEffectIfBuried(class_1309 livingEntity, class_2680 blockState, class_2338 blockPos) {
        class_238 blockBounds = PileOfPollen.getAABBShape(blockState).method_989((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
        if (blockBounds.method_1006(livingEntity.method_33571())) {
            livingEntity.method_6092(new class_1293(BzEffects.HIDDEN, 10, 1, true, false, true));
        } else if (blockBounds.method_1006(livingEntity.method_33571().method_1031(0.0, -0.2, 0.0))) {
            livingEntity.method_6092(new class_1293(BzEffects.HIDDEN, 10, 0, true, false, true));
        }
    }

    public static void stackPollen(class_2680 blockState, class_1937 world, class_2338 blockPos, class_2680 pollonToStack) {
        class_2680 lastSetState = null;
        int initialLayerValue = (Integer)blockState.method_11654((class_2769)LAYERS);
        int layersToAdd = (Integer)pollonToStack.method_11654((class_2769)LAYERS);
        if (initialLayerValue < 8) {
            int layerToMax = 8 - initialLayerValue;
            lastSetState = (class_2680)blockState.method_11657((class_2769)LAYERS, (Comparable)Integer.valueOf(initialLayerValue + Math.min(layerToMax, layersToAdd)));
            if (!world.method_8608()) {
                world.method_8652(blockPos, lastSetState, 3);
            }
            layersToAdd -= layerToMax;
        }
        class_2680 aboveState = world.method_8320(blockPos.method_10084());
        if (layersToAdd > 0 && aboveState.method_27852(BzBlocks.PILE_OF_POLLEN)) {
            PileOfPollen.stackPollen(aboveState, world, blockPos.method_10084(), (class_2680)blockState.method_11657((class_2769)LAYERS, (Comparable)Integer.valueOf(layersToAdd)));
        } else {
            if (layersToAdd > 0 && aboveState.method_26215()) {
                lastSetState = (class_2680)blockState.method_11657((class_2769)LAYERS, (Comparable)Integer.valueOf(layersToAdd));
                if (!world.method_8608()) {
                    world.method_8652(blockPos.method_10084(), (class_2680)blockState.method_11657((class_2769)LAYERS, (Comparable)Integer.valueOf(layersToAdd)), 3);
                }
            }
            if (world.method_8608() && lastSetState != null) {
                for (int i = 0; i < 40; ++i) {
                    PileOfPollen.spawnParticles(lastSetState, (class_1936)world, blockPos, world.field_9229, true);
                }
            }
        }
    }

    public static void pandaSneezing(class_1440 pandaEntity) {
        if (!pandaEntity.field_6002.method_8608() && pandaEntity.method_6051().method_43057() < 0.005f && pandaEntity.field_6002.method_8320(pandaEntity.method_24515()).method_27852(BzBlocks.PILE_OF_POLLEN)) {
            pandaEntity.method_6546(true);
        }
    }

    public void method_9496(class_2680 blockState, class_1937 world, class_2338 blockPos, class_5819 random) {
        int layerValue = (Integer)blockState.method_11654((class_2769)LAYERS);
        double chance = 0.015f + (float)layerValue * 0.008f;
        if ((double)random.method_43057() < chance) {
            PileOfPollen.spawnParticles(blockState, (class_1936)world, blockPos, random, false);
        }
    }

    public int method_10130(class_2680 blockState, class_1922 blockReader, class_2338 blockPos) {
        return 0xFFAA00;
    }

    public static void spawnParticles(class_2680 blockState, class_1936 world, class_2338 blockPos, class_5819 random, boolean disturbed) {
        for (class_2350 direction : class_2350.values()) {
            class_2338 blockpos = blockPos.method_10093(direction);
            if (world.method_8320(blockpos).method_26216((class_1922)world, blockpos)) continue;
            double speedYModifier = disturbed ? 0.05 : 0.005;
            double speedXZModifier = disturbed ? 0.03 : 0.005;
            class_265 currentShape = SHAPE_BY_LAYER[(Integer)blockState.method_11654((class_2769)LAYERS)];
            double yHeight = currentShape.method_1105(class_2350.class_2351.field_11052) - currentShape.method_1091(class_2350.class_2351.field_11052);
            class_2350.class_2351 directionAxis = direction.method_10166();
            double xOffset = directionAxis == class_2350.class_2351.field_11048 ? 0.5 + 0.5625 * (double)direction.method_10148() : (double)random.method_43057();
            double yOffset = directionAxis == class_2350.class_2351.field_11052 ? yHeight * (double)direction.method_10164() : (double)random.method_43057() * yHeight;
            double zOffset = directionAxis == class_2350.class_2351.field_11051 ? 0.5 + 0.5625 * (double)direction.method_10165() : (double)random.method_43057();
            world.method_8406((class_2394)BzParticles.POLLEN_PARTICLE, (double)blockPos.method_10263() + xOffset, (double)blockPos.method_10264() + yOffset, (double)blockPos.method_10260() + zOffset, random.method_43059() * speedXZModifier, random.method_43059() * speedYModifier + (disturbed ? 0.01 : 0.0), random.method_43059() * speedXZModifier);
            return;
        }
    }

    public static void spawnParticles(class_1936 world, class_243 location, class_5819 random, double speedXZModifier, double speedYModifier, double initYSpeed) {
        double xOffset = (double)random.method_43057() * 0.3 - 0.15;
        double yOffset = (double)random.method_43057() * 0.3 - 0.15;
        double zOffset = (double)random.method_43057() * 0.3 - 0.15;
        world.method_8406((class_2394)BzParticles.POLLEN_PARTICLE, location.method_10216() + xOffset, location.method_10214() + yOffset, location.method_10215() + zOffset, random.method_43059() * speedXZModifier, random.method_43059() * speedYModifier + initYSpeed, random.method_43059() * speedXZModifier);
    }

    public static void spawnParticlesServer(class_1936 world, class_243 location, class_5819 random, double speedXZModifier, double speedYModifier, double initYSpeed, int numberOfParticles) {
        if (world.method_8608()) {
            return;
        }
        double xOffset = (double)random.method_43057() * 0.3 - 0.15;
        double yOffset = (double)random.method_43057() * 0.3 - 0.15;
        double zOffset = (double)random.method_43057() * 0.3 - 0.15;
        ((class_3218)world).method_14199((class_2394)BzParticles.POLLEN_PARTICLE, location.method_10216() + xOffset, location.method_10214() + yOffset, location.method_10215() + zOffset, numberOfParticles, random.method_43059() * speedXZModifier, random.method_43059() * speedYModifier + initYSpeed, random.method_43059() * speedXZModifier, (double)0.02f);
    }
}

