/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.init.ModEntities;
import com.mrcrayfish.goblintraders.trades.EntityTrades;
import com.mrcrayfish.goblintraders.trades.IRaritySettings;
import com.mrcrayfish.goblintraders.trades.TradeManager;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3853;

public class GoblinTraderEntity
extends AbstractGoblinEntity {
    public GoblinTraderEntity(class_1937 level) {
        this((class_1299<? extends AbstractGoblinEntity>)ModEntities.GOBLIN_TRADER, level);
    }

    public GoblinTraderEntity(class_1299<? extends AbstractGoblinEntity> type, class_1937 level) {
        super((class_1299<? extends TraderCreatureEntity>)type, level);
    }

    @Override
    public class_2960 getTexture() {
        return new class_2960("goblintraders", "textures/entity/goblin_trader.png");
    }

    @Override
    protected void populateTradeData() {
        class_1916 offers = this.method_8264();
        EntityTrades entityTrades = TradeManager.instance().getTrades(ModEntities.GOBLIN_TRADER);
        if (entityTrades != null) {
            Map<TradeRarity, List<class_3853.class_1652>> tradeMap = entityTrades.getTradeMap();
            for (TradeRarity rarity : TradeRarity.values()) {
                IRaritySettings settings = Config.ENTITIES.goblinTrader.trades.getSettings(rarity);
                if (settings.includeChance() <= 0.0 || settings.includeChance() < 1.0 && this.method_6051().method_43058() > settings.includeChance()) continue;
                List<class_3853.class_1652> trades = tradeMap.get((Object)rarity);
                int min = Math.min(settings.getMinValue(), settings.getMaxValue());
                int max = Math.max(settings.getMinValue(), settings.getMaxValue());
                int count = min + this.method_6051().method_43048(max - min + 1);
                this.addTrades(offers, trades, count, rarity.shouldShuffle());
            }
        }
    }

    @Override
    public class_1799 getFavouriteFood() {
        return new class_1799((class_1935)class_1802.field_8279);
    }

    @Override
    protected int getMaxRestockDelay() {
        return (Integer)Config.ENTITIES.goblinTrader.restockDelay.get();
    }

    @Override
    public boolean canAttackBack() {
        return (Boolean)Config.ENTITIES.goblinTrader.canAttackBack.get();
    }

    public int method_5970() {
        return (Integer)Config.ENTITIES.goblinTrader.gruntNoiseInterval.get();
    }
}

