/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.platform;

import corgitaco.corgilib.CorgiLib;
import corgitaco.corgilib.network.Packet;
import java.nio.file.Path;
import java.util.List;
import java.util.ServiceLoader;
import net.minecraft.class_3222;

public interface ModPlatform {
    public static final ModPlatform PLATFORM = ModPlatform.load(ModPlatform.class);

    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    public <P extends Packet> void sendToClient(class_3222 var1, P var2);

    default public <P extends Packet> void sendToAllClients(List<class_3222> players, P packet) {
        for (class_3222 player : players) {
            this.sendToClient(player, packet);
        }
    }

    public <P extends Packet> void sendToServer(P var1);

    public Path configDir();

    default public Path modConfigDir() {
        return this.configDir().resolve("corgilib");
    }

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        CorgiLib.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

