/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.utils;

import io.github.lucaargolo.seasons.utils.Season;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class ModConfig {
    private SeasonLength seasonLength = new SeasonLength();
    private SeasonLock seasonLock = new SeasonLock();
    private List<String> dimensionAllowlist = List.of("minecraft:overworld");
    private boolean doTemperatureChanges = true;
    private boolean shouldSnowyBiomesMeltInSummer = true;
    private List<String> biomeDenylist = List.of("terralith:glacial_chasm");
    private boolean isSeasonTiedWithSystemTime = false;
    private boolean isInNorthHemisphere = true;
    private boolean isSeasonMessingCrops = true;
    private boolean isSeasonMessingBonemeal = false;
    private boolean doCropsGrowsNormallyUnderground = false;
    private boolean doAnimalsBreedInWinter = true;
    private boolean notifyCompat = true;
    private boolean debugCommandEnabled = false;

    public boolean shouldNotifyCompat() {
        return this.notifyCompat;
    }

    public boolean doAnimalsBreedInWinter() {
        return this.doAnimalsBreedInWinter;
    }

    public boolean isSeasonMessingCrops() {
        return this.isSeasonMessingCrops;
    }

    public boolean isSeasonMessingBonemeal() {
        return this.isSeasonMessingBonemeal;
    }

    public boolean doCropsGrowsNormallyUnderground() {
        return this.doCropsGrowsNormallyUnderground;
    }

    public boolean doTemperatureChanges(class_2960 biomeId) {
        return this.doTemperatureChanges && !this.biomeDenylist.contains(biomeId.toString());
    }

    public boolean shouldSnowyBiomesMeltInSummer() {
        return this.shouldSnowyBiomesMeltInSummer;
    }

    public int getSpringLength() {
        return this.seasonLength.springLength;
    }

    public int getSummerLength() {
        return this.seasonLength.summerLength;
    }

    public int getFallLength() {
        return this.seasonLength.fallLength;
    }

    public int getWinterLength() {
        return this.seasonLength.winterLength;
    }

    public int getYearLength() {
        return this.seasonLength.springLength + this.seasonLength.summerLength + this.seasonLength.fallLength + this.seasonLength.winterLength;
    }

    @Deprecated
    public int getSeasonLength() {
        return this.getSpringLength();
    }

    public boolean isSeasonLocked() {
        return this.seasonLock.isSeasonLocked;
    }

    public Season getLockedSeason() {
        return this.seasonLock.lockedSeason;
    }

    public boolean isValidInDimension(class_5321<class_1937> dimension) {
        return this.dimensionAllowlist.contains(dimension.method_29177().toString());
    }

    public boolean isSeasonTiedWithSystemTime() {
        return this.isSeasonTiedWithSystemTime;
    }

    public boolean isInNorthHemisphere() {
        return this.isInNorthHemisphere;
    }

    public boolean isDebugCommandEnabled() {
        return this.debugCommandEnabled;
    }

    private static class SeasonLength {
        private int springLength = 672000;
        private int summerLength = 672000;
        private int fallLength = 672000;
        private int winterLength = 672000;

        private SeasonLength() {
        }
    }

    private static class SeasonLock {
        private boolean isSeasonLocked = false;
        private Season lockedSeason = Season.SPRING;

        private SeasonLock() {
        }
    }
}

