/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.mixin;

import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.mixed.BiomeMixed;
import io.github.lucaargolo.seasons.resources.FoliageSeasonColors;
import io.github.lucaargolo.seasons.resources.GrassSeasonColors;
import io.github.lucaargolo.seasons.utils.ColorsCache;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4763;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1959.class})
public abstract class BiomeMixin
implements BiomeMixed {
    @Shadow
    @Final
    public class_1959.class_5482 field_26393;
    @Shadow
    @Final
    private class_4763 field_22039;
    private class_1959.class_5482 originalWeather;

    @Shadow
    protected abstract int method_30773();

    @Shadow
    protected abstract int method_30774();

    @Inject(at={@At(value="TAIL")}, method={"getGrassColorAt"}, cancellable=true)
    @Environment(value=EnvType.CLIENT)
    public void getSeasonGrassColor(double x, double z, CallbackInfoReturnable<Integer> cir) {
        Optional<Integer> overridedColor;
        class_1959 biome = (class_1959)this;
        if (ColorsCache.hasGrassCache(biome)) {
            overridedColor = ColorsCache.getGrassCache(biome);
        } else {
            class_2960 biomeIdentifier;
            Optional<Integer> seasonGrassColor;
            overridedColor = this.field_22039.method_30812();
            class_638 world = class_310.method_1551().field_1687;
            if (world != null && (seasonGrassColor = GrassSeasonColors.getSeasonGrassColor(biome, biomeIdentifier = world.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome), FabricSeasons.getCurrentSeason())).isPresent()) {
                overridedColor = seasonGrassColor;
            }
            ColorsCache.createGrassCache(biome, overridedColor);
        }
        if (this.field_22039.method_30814() == class_4763.class_5486.field_26428) {
            int swampColor1 = GrassSeasonColors.getSwampColor1(FabricSeasons.getCurrentSeason());
            int swampColor2 = GrassSeasonColors.getSwampColor2(FabricSeasons.getCurrentSeason());
            double d = class_1959.field_9324.method_16451(x * 0.0225, z * 0.0225, false);
            cir.setReturnValue((Object)(d < -0.1 ? swampColor1 : swampColor2));
        } else if (overridedColor != null) {
            Integer integer = overridedColor.orElseGet(this::method_30773);
            cir.setReturnValue((Object)this.field_22039.method_30814().method_30823(x, z, integer.intValue()));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"getFoliageColor"}, cancellable=true)
    @Environment(value=EnvType.CLIENT)
    public void getSeasonFoliageColor(CallbackInfoReturnable<Integer> cir) {
        Optional<Integer> overridedColor;
        class_1959 biome = (class_1959)this;
        if (ColorsCache.hasFoliageCache(biome)) {
            overridedColor = ColorsCache.getFoliageCache(biome);
        } else {
            class_2960 biomeIdentifier;
            Optional<Integer> seasonFoliageColor;
            overridedColor = this.field_22039.method_30811();
            class_638 world = class_310.method_1551().field_1687;
            if (world != null && (seasonFoliageColor = FoliageSeasonColors.getSeasonFoliageColor(biome, biomeIdentifier = world.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome), FabricSeasons.getCurrentSeason())).isPresent()) {
                overridedColor = seasonFoliageColor;
            }
            ColorsCache.createFoliageCache(biome, overridedColor);
        }
        if (overridedColor != null) {
            Integer integer = overridedColor.orElseGet(this::method_30774);
            cir.setReturnValue((Object)integer);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getDefaultFoliageColor"}, cancellable=true)
    @Environment(value=EnvType.CLIENT)
    public void getSeasonDefaultFolliageColor(CallbackInfoReturnable<Integer> cir) {
        if (this.originalWeather != null) {
            double originalTemperature = class_3532.method_15363((float)this.originalWeather.comp_844, (float)0.0f, (float)1.0f);
            double originalDownfall = class_3532.method_15363((float)this.originalWeather.comp_846, (float)0.0f, (float)1.0f);
            cir.setReturnValue((Object)FoliageSeasonColors.getColor(FabricSeasons.getCurrentSeason(), originalTemperature, originalDownfall));
        } else {
            double temperature = class_3532.method_15363((float)this.field_26393.comp_844, (float)0.0f, (float)1.0f);
            double downfall = class_3532.method_15363((float)this.field_26393.comp_846, (float)0.0f, (float)1.0f);
            cir.setReturnValue((Object)FoliageSeasonColors.getColor(FabricSeasons.getCurrentSeason(), temperature, downfall));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getDefaultGrassColor"}, cancellable=true)
    @Environment(value=EnvType.CLIENT)
    public void getSeasonDefaultGrassColor(CallbackInfoReturnable<Integer> cir) {
        if (this.originalWeather != null) {
            double d = class_3532.method_15363((float)this.originalWeather.comp_844, (float)0.0f, (float)1.0f);
            double e = class_3532.method_15363((float)this.originalWeather.comp_846, (float)0.0f, (float)1.0f);
            cir.setReturnValue((Object)GrassSeasonColors.getColor(FabricSeasons.getCurrentSeason(), d, e));
        } else {
            double d = class_3532.method_15363((float)this.field_26393.comp_844, (float)0.0f, (float)1.0f);
            double e = class_3532.method_15363((float)this.field_26393.comp_846, (float)0.0f, (float)1.0f);
            cir.setReturnValue((Object)GrassSeasonColors.getColor(FabricSeasons.getCurrentSeason(), d, e));
        }
    }

    @Override
    public class_1959.class_5482 getOriginalWeather() {
        return this.originalWeather;
    }

    @Override
    public void setOriginalWeather(class_1959.class_5482 originalWeather) {
        this.originalWeather = originalWeather;
    }
}

