/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.commands;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.resources.CropConfigs;
import io.github.lucaargolo.seasons.utils.Season;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2247;
import net.minecraft.class_2257;
import net.minecraft.class_2287;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_746;

public class SeasonDebugCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 commandRegistry) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"season_debug").then(ClientCommandManager.literal((String)"create_all_crops").executes(context -> {
            AtomicInteger index = new AtomicInteger();
            FabricSeasons.SEEDS_MAP.values().forEach(block -> {
                class_2960 cropId = class_2378.field_11146.method_10221(block);
                index.getAndIncrement();
                SeasonDebugCommand.createCrop(cropId);
            });
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Successfully created " + index.get() + " crop entries.")));
            return 1;
        }))).then(ClientCommandManager.literal((String)"create_biome_translations").executes(context -> {
            AtomicInteger index = new AtomicInteger();
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            player.method_37908().method_30349().method_30530(class_2378.field_25114).method_40295().forEach(biomeEntry -> biomeEntry.method_40230().ifPresent(biomeKey -> {
                if (SeasonDebugCommand.createTranslation(biomeKey.method_29177())) {
                    index.getAndIncrement();
                }
            }));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Successfully created " + index.get() + " biome translations.")));
            return 1;
        }))).then(ClientCommandManager.literal((String)"create_block_variants").then(ClientCommandManager.argument((String)"block", (ArgumentType)class_2257.method_9653((class_7157)commandRegistry)).executes(context -> {
            class_2680 state = ((class_2247)context.getArgument("block", class_2247.class)).method_9494();
            Optional optional = state.method_41520().method_40230();
            if (optional.isPresent()) {
                class_310 client = class_310.method_1551();
                class_2960 blockId = ((class_5321)optional.get()).method_29177();
                Optional optional2 = client.method_1478().method_14486(new class_2960(blockId.method_12836(), "blockstates/" + blockId.method_12832() + ".json"));
                if (optional2.isPresent()) {
                    class_3298 blockState = (class_3298)optional2.get();
                    try {
                        HashSet<class_2960> models = SeasonDebugCommand.collectModels(new HashSet<class_2960>(), JsonParser.parseReader((Reader)new InputStreamReader(blockState.method_14482(), StandardCharsets.UTF_8)));
                        models.forEach(model -> {
                            class_2960 modelId = new class_2960(model.method_12836(), "models/" + model.method_12832() + ".json");
                            Optional optional3 = client.method_1478().method_14486(modelId);
                            if (optional3.isPresent()) {
                                class_3298 blockModel = (class_3298)optional3.get();
                                try {
                                    HashMap<String, class_2960> textures = SeasonDebugCommand.collectTextures(new HashMap<String, class_2960>(), client.method_1478(), JsonParser.parseReader((Reader)new InputStreamReader(blockModel.method_14482(), StandardCharsets.UTF_8)));
                                    textures.forEach((name, id) -> {
                                        Optional optional4 = client.method_1478().method_14486(new class_2960(id.method_12836(), "textures/" + id.method_12832() + ".png"));
                                        if (optional4.isPresent()) {
                                            class_3298 texture = (class_3298)optional4.get();
                                            try {
                                                SeasonDebugCommand.copyTexture(id, texture.method_14482());
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                    SeasonDebugCommand.createTextureIndex(modelId, textures);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"create_item_variants").then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2287.method_9776((class_7157)commandRegistry)).executes(context -> {
            class_1792 item = class_2287.method_9777((CommandContext)context, (String)"item").method_9785();
            Optional optional = item.method_40131().method_40230();
            if (optional.isPresent()) {
                class_310 client = class_310.method_1551();
                class_2960 itemId = ((class_5321)optional.get()).method_29177();
                class_2960 modelId = new class_2960(itemId.method_12836(), "models/item/" + itemId.method_12832() + ".json");
                Optional optional2 = client.method_1478().method_14486(modelId);
                if (optional2.isPresent()) {
                    class_3298 itemModel = (class_3298)optional2.get();
                    try {
                        HashMap<String, class_2960> textures = SeasonDebugCommand.collectTextures(new HashMap<String, class_2960>(), client.method_1478(), JsonParser.parseReader((Reader)new InputStreamReader(itemModel.method_14482(), StandardCharsets.UTF_8)));
                        textures.forEach((name, id) -> {
                            Optional optional4 = client.method_1478().method_14486(new class_2960(id.method_12836(), "textures/" + id.method_12832() + ".png"));
                            if (optional4.isPresent()) {
                                class_3298 texture = (class_3298)optional4.get();
                                try {
                                    SeasonDebugCommand.copyTexture(id, texture.method_14482());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        SeasonDebugCommand.createTextureIndex(modelId, textures);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"print_biomes").executes(context -> {
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            ArrayList<class_6880> entries = new ArrayList<class_6880>();
            player.method_37908().method_30349().method_30530(class_2378.field_25114).method_40295().forEach(entries::add);
            entries.sort(Comparator.comparing(entry -> entry.method_40230().orElse(class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)new class_2960("missingno"))).method_29177().toString()));
            AtomicReference<String> str = new AtomicReference<String>("\n");
            entries.forEach(entry -> str.updateAndGet(s -> s + entry.method_40230().orElse(class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)new class_2960("missingno"))).method_29177().toString() + "\n"));
            System.out.println(str.get());
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"create_foliage_color").then(ClientCommandManager.argument((String)"color", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int color = IntegerArgumentType.getInteger((CommandContext)context, (String)"color");
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            Season season = FabricSeasons.getCurrentSeason(player.method_37908());
            class_6880 entry = player.method_37908().method_23753(player.method_24515());
            class_2960 id = ((class_5321)entry.method_40230().orElseThrow()).method_29177();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(SeasonDebugCommand.setBiomeColor(id, season, color, "foliage"));
            return 1;
        }))).then(ClientCommandManager.argument((String)"hex_color", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String hexColor = StringArgumentType.getString((CommandContext)context, (String)"hex_color");
            int color = Integer.parseInt(hexColor, 16);
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            Season season = FabricSeasons.getCurrentSeason(player.method_37908());
            class_6880 entry = player.method_37908().method_23753(player.method_24515());
            class_2960 id = ((class_5321)entry.method_40230().orElseThrow()).method_29177();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(SeasonDebugCommand.setBiomeColor(id, season, color, "foliage"));
            return 1;
        }))).executes(context -> {
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            Season season = FabricSeasons.getCurrentSeason(player.method_37908());
            class_6880 entry = player.method_37908().method_23753(player.method_24515());
            class_2960 id = ((class_5321)entry.method_40230().orElseThrow()).method_29177();
            class_1959 biome = (class_1959)entry.comp_349();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(SeasonDebugCommand.setBiomeColor(id, season, biome.method_8698(), "foliage"));
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"create_grass_color").then(ClientCommandManager.argument((String)"color", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int color = IntegerArgumentType.getInteger((CommandContext)context, (String)"color");
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            Season season = FabricSeasons.getCurrentSeason(player.method_37908());
            class_6880 entry = player.method_37908().method_23753(player.method_24515());
            class_2960 id = ((class_5321)entry.method_40230().orElseThrow()).method_29177();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(SeasonDebugCommand.setBiomeColor(id, season, color, "grass"));
            return 1;
        }))).then(ClientCommandManager.argument((String)"hex_color", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String hexColor = StringArgumentType.getString((CommandContext)context, (String)"hex_color");
            int color = Integer.parseInt(hexColor, 16);
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            Season season = FabricSeasons.getCurrentSeason(player.method_37908());
            class_6880 entry = player.method_37908().method_23753(player.method_24515());
            class_2960 id = ((class_5321)entry.method_40230().orElseThrow()).method_29177();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(SeasonDebugCommand.setBiomeColor(id, season, color, "grass"));
            return 1;
        }))).executes(context -> {
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            Season season = FabricSeasons.getCurrentSeason(player.method_37908());
            class_6880 entry = player.method_37908().method_23753(player.method_24515());
            class_2960 id = ((class_5321)entry.method_40230().orElseThrow()).method_29177();
            class_1959 biome = (class_1959)entry.comp_349();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(SeasonDebugCommand.setBiomeColor(id, season, biome.method_8711(player.method_23317(), player.method_23321()), "grass"));
            return 1;
        })));
    }

    private static HashMap<String, class_2960> collectTextures(HashMap<String, class_2960> map, class_3300 manager, JsonElement element) throws IOException {
        class_2960 parent;
        Optional optional;
        JsonObject model = element.getAsJsonObject();
        if (model.has("parent") && (optional = manager.method_14486(new class_2960((parent = new class_2960(model.get("parent").getAsString())).method_12836(), "models/" + parent.method_12832() + ".json"))).isPresent()) {
            class_3298 parentModel = (class_3298)optional.get();
            SeasonDebugCommand.collectTextures(map, manager, JsonParser.parseReader((Reader)new InputStreamReader(parentModel.method_14482(), StandardCharsets.UTF_8)));
        }
        if (model.has("textures")) {
            JsonObject textures = model.getAsJsonObject("textures");
            textures.entrySet().forEach(entry -> {
                if (class_2960.method_20207((String)((JsonElement)entry.getValue()).getAsString())) {
                    map.put((String)entry.getKey(), new class_2960(((JsonElement)entry.getValue()).getAsString()));
                }
            });
        }
        return map;
    }

    private static HashSet<class_2960> collectModels(HashSet<class_2960> set, JsonElement element) {
        if (element.isJsonObject()) {
            element.getAsJsonObject().entrySet().forEach(entry -> {
                if (Objects.equals(entry.getKey(), "model") && ((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                    set.add(new class_2960(((JsonElement)entry.getValue()).getAsString()));
                } else {
                    SeasonDebugCommand.collectModels(set, (JsonElement)entry.getValue());
                }
            });
        } else if (element.isJsonArray()) {
            element.getAsJsonArray().forEach(innerElement -> SeasonDebugCommand.collectModels(set, innerElement));
        }
        return set;
    }

    private static void createTextureIndex(class_2960 id, HashMap<String, class_2960> textureMap) {
        Path gamePath = FabricLoader.getInstance().getGameDir();
        CharSequence[] split = id.method_12832().split("/");
        String last = split[split.length - 1];
        split[split.length - 1] = "";
        String join = String.join((CharSequence)File.separator, split);
        File resourcePath = new File(gamePath + File.separator + "resourcepacks" + File.separator + "seasons_debug" + File.separator + "assets" + File.separator + id.method_12836() + File.separator + "seasons" + File.separator + join.substring(0, join.length() - 1));
        resourcePath.mkdirs();
        File textureFile = new File(resourcePath.getPath() + File.separator + last);
        JsonObject textureJson = new JsonObject();
        try {
            textureFile.createNewFile();
            for (Season s : Season.values()) {
                if (s == Season.SPRING) continue;
                JsonObject textureMapJson = new JsonObject();
                textureMap.forEach((key, value) -> {
                    CharSequence[] innerSplit = value.method_12832().split("/");
                    String innerLast = innerSplit[innerSplit.length - 1];
                    innerSplit[innerSplit.length - 1] = "";
                    String innerJoin = String.join((CharSequence)"/", innerSplit);
                    textureMapJson.add(key, (JsonElement)new JsonPrimitive(new class_2960(value.method_12836(), innerJoin + s.name().toLowerCase(Locale.ROOT) + "_" + innerLast).toString()));
                });
                textureJson.add(s.name().toLowerCase(Locale.ROOT), (JsonElement)textureMapJson);
            }
            JsonObject f = new JsonObject();
            f.add("textures", (JsonElement)textureJson);
            String json = FabricSeasons.GSON.toJson((JsonElement)f);
            try (PrintWriter out = new PrintWriter(textureFile);){
                out.println(json);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void copyTexture(class_2960 id, InputStream inputStream) {
        ArrayList<File> files = new ArrayList<File>();
        for (Season s : Season.values()) {
            if (s == Season.SPRING) continue;
            Path gamePath = FabricLoader.getInstance().getGameDir();
            CharSequence[] split = id.method_12832().split("/");
            String last = split[split.length - 1];
            split[split.length - 1] = "";
            String join = String.join((CharSequence)File.separator, split);
            File resourcePath = new File(gamePath + File.separator + "resourcepacks" + File.separator + "seasons_debug" + File.separator + "assets" + File.separator + id.method_12836() + File.separator + "textures" + File.separator + join.substring(0, join.length() - 1));
            resourcePath.mkdirs();
            File textureFile = new File(resourcePath.getPath() + File.separator + s.name().toLowerCase(Locale.ROOT) + "_" + last + ".png");
            files.add(textureFile);
        }
        try {
            int read;
            ArrayList<FileOutputStream> streams = new ArrayList<FileOutputStream>();
            for (File f : files) {
                if (!f.createNewFile()) continue;
                streams.add(new FileOutputStream(f));
            }
            byte[] bytes = new byte[8192];
            while ((read = inputStream.read(bytes)) != -1) {
                for (FileOutputStream s : streams) {
                    s.write(bytes, 0, read);
                }
            }
            for (FileOutputStream s : streams) {
                s.close();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static class_2561 setBiomeColor(class_2960 id, Season season, int color, String type) {
        Path gamePath = FabricLoader.getInstance().getGameDir();
        File resourcePath = new File(gamePath + File.separator + "resourcepacks" + File.separator + "seasons_debug" + File.separator + "assets" + File.separator + id.method_12836() + File.separator + "seasons" + File.separator + type);
        resourcePath.mkdirs();
        File biomeFile = new File(resourcePath.getPath() + File.separator + id.method_12832() + ".json");
        try {
            JsonObject biomeJson;
            if (biomeFile.createNewFile()) {
                biomeJson = new JsonObject();
                biomeJson.add(Season.SPRING.name().toLowerCase(Locale.ROOT), (JsonElement)new JsonPrimitive((Number)color));
                biomeJson.add(Season.SUMMER.name().toLowerCase(Locale.ROOT), (JsonElement)new JsonPrimitive((Number)color));
                biomeJson.add(Season.FALL.name().toLowerCase(Locale.ROOT), (JsonElement)new JsonPrimitive((Number)color));
                biomeJson.add(Season.WINTER.name().toLowerCase(Locale.ROOT), (JsonElement)new JsonPrimitive((Number)color));
            } else {
                biomeJson = JsonParser.parseString((String)new String(Files.readAllBytes(biomeFile.toPath()))).getAsJsonObject();
            }
            biomeJson.add(season.name().toLowerCase(Locale.ROOT), (JsonElement)new JsonPrimitive((Number)color));
            String json = FabricSeasons.GSON.toJson((JsonElement)biomeJson);
            try (PrintWriter out = new PrintWriter(biomeFile);){
                out.println(json);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return class_2561.method_43470((String)("Successfully set " + id + " " + type + " color to " + color + " at " + biomeFile.getPath())).method_27694(style -> style.method_36139(color).method_10958(new class_2558(class_2558.class_2559.field_21462, Integer.toHexString(color))));
    }

    private static void createCrop(class_2960 id) {
        Path gamePath = FabricLoader.getInstance().getGameDir();
        File dataPath = new File(gamePath + File.separator + "datapacks" + File.separator + "seasons_debug" + File.separator + "data" + File.separator + id.method_12836() + File.separator + "seasons" + File.separator + "crop");
        dataPath.mkdirs();
        File cropFile = new File(dataPath.getPath() + File.separator + id.method_12832() + ".json");
        try {
            JsonObject cropJson;
            if (cropFile.createNewFile()) {
                cropJson = new JsonObject();
                cropJson.add(Season.SPRING.name().toLowerCase(Locale.ROOT), (JsonElement)new JsonPrimitive((Number)Float.valueOf(CropConfigs.getSeasonCropMultiplier(id, Season.SPRING))));
                cropJson.add(Season.SUMMER.name().toLowerCase(Locale.ROOT), (JsonElement)new JsonPrimitive((Number)Float.valueOf(CropConfigs.getSeasonCropMultiplier(id, Season.SUMMER))));
                cropJson.add(Season.FALL.name().toLowerCase(Locale.ROOT), (JsonElement)new JsonPrimitive((Number)Float.valueOf(CropConfigs.getSeasonCropMultiplier(id, Season.FALL))));
                cropJson.add(Season.WINTER.name().toLowerCase(Locale.ROOT), (JsonElement)new JsonPrimitive((Number)Float.valueOf(CropConfigs.getSeasonCropMultiplier(id, Season.WINTER))));
            } else {
                cropJson = JsonParser.parseString((String)new String(Files.readAllBytes(cropFile.toPath()))).getAsJsonObject();
            }
            String json = FabricSeasons.GSON.toJson((JsonElement)cropJson);
            try (PrintWriter out = new PrintWriter(cropFile);){
                out.println(json);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static boolean createTranslation(class_2960 id) {
        block9: {
            Path gamePath = FabricLoader.getInstance().getGameDir();
            String translationKey = "biome." + id.method_12836() + "." + id.method_12832();
            CharSequence[] split = id.method_12832().split("_");
            for (int i = 0; i < split.length; ++i) {
                String s = split[i];
                String[] innerSplit = s.split("/");
                s = innerSplit[0];
                char c = s.charAt(0);
                s = s.replaceFirst(String.valueOf(c), String.valueOf(Character.toUpperCase(c)));
                split[i] = s;
            }
            String translation = String.join((CharSequence)" ", split);
            if (class_1074.method_4663((String)translationKey)) {
                return false;
            }
            File dataPath = new File(gamePath + File.separator + "resourcepacks" + File.separator + "seasons_debug" + File.separator + "assets" + File.separator + id.method_12836());
            dataPath.mkdirs();
            File langFile = new File(dataPath.getPath() + File.separator + "en_us.json");
            try {
                JsonObject langJson = langFile.createNewFile() ? new JsonObject() : JsonParser.parseString((String)new String(Files.readAllBytes(langFile.toPath()))).getAsJsonObject();
                if (langJson.has(translationKey)) break block9;
                langJson.add(translationKey, (JsonElement)new JsonPrimitive(translation));
                String json = FabricSeasons.GSON.toJson((JsonElement)langJson);
                try (PrintWriter out = new PrintWriter(langFile);){
                    out.println(json);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return true;
    }
}

