/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons;

import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.commands.SeasonDebugCommand;
import io.github.lucaargolo.seasons.resources.CropConfigs;
import io.github.lucaargolo.seasons.resources.FoliageSeasonColors;
import io.github.lucaargolo.seasons.resources.GrassSeasonColors;
import io.github.lucaargolo.seasons.utils.CompatWarnState;
import io.github.lucaargolo.seasons.utils.CropConfig;
import io.github.lucaargolo.seasons.utils.ModConfig;
import io.github.lucaargolo.seasons.utils.ModIdentifier;
import io.github.lucaargolo.seasons.utils.Season;
import io.github.lucaargolo.seasons.utils.SeasonalFertilizable;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_5321;

public class FabricSeasonsClient
implements ClientModInitializer {
    private static boolean isServerConfig = false;
    private static ModConfig clientConfig = null;
    private static final Map<class_5321<class_1937>, Season> lastRenderedSeasonMap = new HashMap<class_5321<class_1937>, Season>();
    public static final Map<class_1087, Map<Season, class_1087>> originalToSeasonModelMap = new HashMap<class_1087, Map<Season, class_1087>>();

    public void onInitializeClient() {
        clientConfig = FabricSeasons.CONFIG;
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new GrassSeasonColors());
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new FoliageSeasonColors());
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            FabricSeasons.SEEDS_MAP.clear();
            class_2378.field_11142.forEach(item -> {
                class_2248 block;
                if (item instanceof class_1747 && (block = ((class_1747)item).method_7711()) instanceof SeasonalFertilizable) {
                    FabricSeasons.SEEDS_MAP.put((class_1792)item, ((class_1747)item).method_7711());
                }
            });
        });
        ClientTickEvents.END_WORLD_TICK.register(clientWorld -> {
            if (FabricSeasons.getCurrentSeason((class_1937)clientWorld) != lastRenderedSeasonMap.get(clientWorld.method_27983())) {
                lastRenderedSeasonMap.put((class_5321<class_1937>)clientWorld.method_27983(), FabricSeasons.getCurrentSeason((class_1937)clientWorld));
                class_310.method_1551().field_1769.method_3279();
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FabricSeasons.ANSWER_CONFIG, (client, handler, buf, responseSender) -> {
            String configJson = buf.method_19772();
            client.execute(() -> {
                FabricSeasons.CONFIG = (ModConfig)FabricSeasons.GSON.fromJson(configJson, ModConfig.class);
                isServerConfig = true;
                FabricSeasons.LOGGER.info("[Fabric Seasons] Received dedicated server config.");
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FabricSeasons.UPDATE_CROPS, (client, handler, buf, responseSender) -> {
            CropConfig receivedConfig = CropConfig.fromBuf(buf);
            HashMap<class_2960, CropConfig> receivedMap = CropConfigs.fromBuf(buf);
            client.execute(() -> {
                CropConfigs.receiveConfig(receivedConfig, receivedMap);
                FabricSeasons.LOGGER.info("[Fabric Seasons] Received dedicated server crops.");
            });
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (FabricSeasons.CONFIG.shouldNotifyCompat()) {
                CompatWarnState.join(client);
            }
            if (!client.method_1496()) {
                FabricSeasons.LOGGER.info("[Fabric Seasons] Joined dedicated server, asking for config.");
                ClientPlayNetworking.send((class_2960)FabricSeasons.ASK_FOR_CONFIG, (class_2540)PacketByteBufs.empty());
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            CropConfigs.clear();
            if (isServerConfig && clientConfig != null) {
                FabricSeasons.LOGGER.info("[Fabric Seasons] Left dedicated server, restoring config.");
                FabricSeasons.CONFIG = clientConfig;
                isServerConfig = false;
            }
        });
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)class_2378.field_11146.method_10223((class_2960)new ModIdentifier("greenhouse_glass")), class_1921.method_23583());
        if (FabricLoader.getInstance().isDevelopmentEnvironment() || FabricSeasons.CONFIG.isDebugCommandEnabled()) {
            ClientCommandRegistrationCallback.EVENT.register(SeasonDebugCommand::register);
        }
        FabricLoader.getInstance().getModContainer("seasons").ifPresent(container -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new ModIdentifier("seasonal_lush_caves"), (ModContainer)container, (String)"Seasonal Lush Caves", (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED));
    }
}

