/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.client.VisibleClientPlayers;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class SendVisiblePlayerListPacket
extends BaseS2CMessage {
    public final List<UUID> uuids;

    private SendVisiblePlayerListPacket(List<UUID> uuids) {
        this.uuids = uuids;
    }

    SendVisiblePlayerListPacket(class_2540 buf) {
        this.uuids = new ArrayList<UUID>();
        int size = buf.method_10816();
        for (int i = 0; i < size; ++i) {
            this.uuids.add(buf.method_10790());
        }
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_VISIBLE_PLAYER_LIST;
    }

    public void write(class_2540 buf) {
        buf.method_10804(this.uuids.size());
        this.uuids.forEach(arg_0 -> ((class_2540)buf).method_10797(arg_0));
    }

    public void handle(NetworkManager.PacketContext context) {
        VisibleClientPlayers.updatePlayerList(this.uuids);
    }

    public static void syncToLevel(class_1937 level) {
        SendVisiblePlayerListPacket.syncToPlayers(FTBChunksAPI.getManager().getMinecraftServer().method_3760().method_14571().stream().filter(p -> p.field_6002 == level).toList());
    }

    public static void syncToAll() {
        SendVisiblePlayerListPacket.syncToPlayers(FTBChunksAPI.getManager().getMinecraftServer().method_3760().method_14571());
    }

    public static void syncToPlayers(List<class_3222> players) {
        if (players == null) {
            players = FTBChunksAPI.getManager().getMinecraftServer().method_3760().method_14571();
        }
        List playerList = players.stream().map(player -> new VisiblePlayerItem((class_3222)player, FTBChunksAPI.getManager().getData((class_3222)player))).collect(Collectors.toList());
        boolean override = (Boolean)FTBChunksWorldConfig.LOCATION_MODE_OVERRIDE.get();
        for (VisiblePlayerItem recipient : playerList) {
            ArrayList<UUID> playerIds = new ArrayList<UUID>();
            for (VisiblePlayerItem other : playerList) {
                if (!override && !recipient.player.method_5687(2) && !other.data.canUse(recipient.player, FTBChunksTeamData.LOCATION_MODE)) continue;
                playerIds.add(other.player.method_5667());
            }
            new SendVisiblePlayerListPacket(playerIds).sendTo(recipient.player);
        }
    }

    private record VisiblePlayerItem(class_3222 player, FTBChunksTeamData data) {
    }
}

