/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class SendGeneralDataPacket
extends BaseS2CMessage {
    public final int claimed;
    public final int loaded;
    public final int maxClaimChunks;
    public final int maxForceLoadChunks;

    public static void send(FTBChunksTeamData teamData, class_3222 player) {
        SendGeneralDataPacket.send(teamData, List.of(player));
    }

    public static void send(FTBChunksTeamData teamData, Collection<class_3222> players) {
        Collection<ClaimedChunk> cc = teamData.getClaimedChunks();
        int loaded = (int)cc.stream().filter(ClaimedChunk::isForceLoaded).count();
        SendGeneralDataPacket data = new SendGeneralDataPacket(cc.size(), loaded, teamData.getMaxClaimChunks(), teamData.getMaxForceLoadChunks());
        players.forEach(player -> {
            if (FTBTeamsAPI.getPlayerTeam((class_3222)player).getId().equals(teamData.getTeamId())) {
                data.sendTo((class_3222)player);
            }
        });
    }

    private SendGeneralDataPacket(int claimed, int loaded, int maxClaimChunks, int maxForceLoadChunks) {
        this.claimed = claimed;
        this.loaded = loaded;
        this.maxClaimChunks = maxClaimChunks;
        this.maxForceLoadChunks = maxForceLoadChunks;
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_GENERAL_DATA;
    }

    SendGeneralDataPacket(class_2540 buf) {
        this.claimed = buf.method_10816();
        this.loaded = buf.method_10816();
        this.maxClaimChunks = buf.method_10816();
        this.maxForceLoadChunks = buf.method_10816();
    }

    public void write(class_2540 buf) {
        buf.method_10804(this.claimed);
        buf.method_10804(this.loaded);
        buf.method_10804(this.maxClaimChunks);
        buf.method_10804(this.maxForceLoadChunks);
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunks.PROXY.updateGeneralData(this);
    }
}

