/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class SendChunkPacket
extends BaseS2CMessage {
    public final class_5321<class_1937> dimension;
    public final UUID teamId;
    public final SingleChunk chunk;

    public SendChunkPacket(class_5321<class_1937> dimension, UUID teamId, SingleChunk chunk) {
        this.dimension = dimension;
        this.teamId = teamId;
        this.chunk = chunk;
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_CHUNK;
    }

    SendChunkPacket(class_2540 buf) {
        this.dimension = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)buf.method_10810());
        this.teamId = buf.method_10790();
        this.chunk = new SingleChunk(buf, this.teamId);
    }

    public void write(class_2540 buf) {
        buf.method_10812(this.dimension.method_29177());
        buf.method_10797(this.teamId);
        this.chunk.write(buf, this.teamId);
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunks.PROXY.updateChunk(this);
    }

    public static class SingleChunk {
        public final int x;
        public final int z;
        public final long relativeTimeClaimed;
        public final boolean forceLoaded;
        public final long relativeTimeForceLoaded;
        public final boolean expires;
        public final long relativeForceLoadExpiryTime;

        public SingleChunk(long now, int x, int z, @Nullable ClaimedChunk claimedChunk) {
            this.x = x;
            this.z = z;
            if (claimedChunk != null) {
                this.relativeTimeClaimed = now - claimedChunk.getTimeClaimed();
                this.forceLoaded = claimedChunk.isForceLoaded();
                this.expires = claimedChunk.getForceLoadExpiryTime() > 0L;
                this.relativeTimeForceLoaded = this.forceLoaded ? now - claimedChunk.getForceLoadedTime() : 0L;
                this.relativeForceLoadExpiryTime = this.expires ? claimedChunk.getForceLoadExpiryTime() - now : 0L;
            } else {
                this.relativeForceLoadExpiryTime = 0L;
                this.relativeTimeForceLoaded = 0L;
                this.relativeTimeClaimed = 0L;
                this.expires = false;
                this.forceLoaded = false;
            }
        }

        public SingleChunk(class_2540 buf, UUID teamId) {
            this.x = buf.method_10816();
            this.z = buf.method_10816();
            if (!teamId.equals(class_156.field_25140)) {
                this.relativeTimeClaimed = buf.method_10792();
                this.forceLoaded = buf.readBoolean();
                this.expires = buf.readBoolean();
                this.relativeTimeForceLoaded = this.forceLoaded ? buf.method_10792() : 0L;
                this.relativeForceLoadExpiryTime = this.expires ? buf.method_10792() : 0L;
            } else {
                this.relativeForceLoadExpiryTime = 0L;
                this.relativeTimeForceLoaded = 0L;
                this.relativeTimeClaimed = 0L;
                this.expires = false;
                this.forceLoaded = false;
            }
        }

        public void write(class_2540 buf, UUID teamId) {
            buf.method_10804(this.x);
            buf.method_10804(this.z);
            if (!teamId.equals(class_156.field_25140)) {
                buf.method_10791(this.relativeTimeClaimed);
                buf.writeBoolean(this.forceLoaded);
                buf.writeBoolean(this.expires);
                if (this.forceLoaded) {
                    buf.method_10791(this.relativeTimeForceLoaded);
                }
                if (this.expires) {
                    buf.method_10791(this.relativeForceLoadExpiryTime);
                }
            }
        }
    }
}

