/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.integration.luckperms;

import dev.ftb.mods.ftbchunks.integration.PermissionsProvider;
import java.util.Optional;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;
import net.minecraft.class_3222;

public class LuckPermsIntegration
implements PermissionsProvider {
    @Override
    public int getMaxClaimedChunks(class_3222 player, int def) {
        return Math.max(LuckPermsIntegration.getMetaData(player.method_5667(), "ftbchunks.max_claimed").map(Integer::parseInt).orElse(def), 0);
    }

    @Override
    public int getMaxForceLoadedChunks(class_3222 player, int def) {
        return Math.max(LuckPermsIntegration.getMetaData(player.method_5667(), "ftbchunks.max_force_loaded").map(Integer::parseInt).orElse(def), 0);
    }

    @Override
    public boolean getChunkLoadOffline(class_3222 player, boolean def) {
        return LuckPermsIntegration.getMetaData(player.method_5667(), "ftbchunks.chunk_load_offline").map(Boolean::parseBoolean).orElse(def);
    }

    @Override
    public boolean getNoWilderness(class_3222 player, boolean def) {
        return LuckPermsIntegration.getMetaData(player.method_5667(), "ftbchunks.no_wilderness").map(Boolean::parseBoolean).orElse(def);
    }

    private static Optional<String> getMetaData(UUID uuid, String meta) {
        LuckPerms luckperms = LuckPermsProvider.get();
        Optional<String> metaValue = Optional.empty();
        try {
            Optional context;
            User user = luckperms.getUserManager().getUser(uuid);
            if (user != null && (context = luckperms.getContextManager().getQueryOptions(user)).isPresent()) {
                metaValue = Optional.ofNullable(user.getCachedData().getMetaData((QueryOptions)context.get()).getMetaValue(meta));
            }
        }
        catch (IllegalStateException e) {
            System.err.println("Error on fetching user with luckperms");
            System.err.println(e.getMessage());
        }
        return metaValue;
    }
}

