/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.integration.ftbranks;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.integration.PermissionsHelper;
import dev.ftb.mods.ftbchunks.integration.PermissionsProvider;
import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import dev.ftb.mods.ftbranks.api.RankManager;
import dev.ftb.mods.ftbranks.api.event.ConditionChangedEvent;
import dev.ftb.mods.ftbranks.api.event.PermissionNodeChangedEvent;
import dev.ftb.mods.ftbranks.api.event.PlayerAddedToRankEvent;
import dev.ftb.mods.ftbranks.api.event.PlayerRemovedFromRankEvent;
import dev.ftb.mods.ftbranks.api.event.RankEvent;
import dev.ftb.mods.ftbranks.api.event.RanksReloadedEvent;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import java.util.UUID;
import net.minecraft.class_3222;

public class FTBRanksIntegration
implements PermissionsProvider {
    @Override
    public int getMaxClaimedChunks(class_3222 player, int def) {
        return Math.max(FTBRanksAPI.getPermissionValue((class_3222)player, (String)"ftbchunks.max_claimed").asInteger().orElse(def), 0);
    }

    @Override
    public int getMaxForceLoadedChunks(class_3222 player, int def) {
        return Math.max(FTBRanksAPI.getPermissionValue((class_3222)player, (String)"ftbchunks.max_force_loaded").asInteger().orElse(def), 0);
    }

    @Override
    public boolean getChunkLoadOffline(class_3222 player, boolean def) {
        return FTBRanksAPI.getPermissionValue((class_3222)player, (String)"ftbchunks.chunk_load_offline").asBoolean().orElse(def);
    }

    @Override
    public boolean getNoWilderness(class_3222 player, boolean def) {
        return FTBRanksAPI.getPermissionValue((class_3222)player, (String)"ftbchunks.no_wilderness").asBoolean().orElse(def);
    }

    public static void registerEvents() {
        RankEvent.ADD_PLAYER.register(FTBRanksIntegration::playerAdded);
        RankEvent.REMOVE_PLAYER.register(FTBRanksIntegration::playerRemoved);
        RankEvent.PERMISSION_CHANGED.register(FTBRanksIntegration::permissionSet);
        RankEvent.RELOADED.register(FTBRanksIntegration::ranksReloaded);
        RankEvent.CONDITION_CHANGED.register(FTBRanksIntegration::conditionChanged);
    }

    private static void playerAdded(PlayerAddedToRankEvent event) {
        FTBRanksIntegration.updateForPlayer(event.getManager(), event.getPlayer());
    }

    private static void playerRemoved(PlayerRemovedFromRankEvent event) {
        FTBRanksIntegration.updateForPlayer(event.getManager(), event.getPlayer());
    }

    private static void permissionSet(PermissionNodeChangedEvent event) {
        String node = event.getNode();
        if (node.equals("ftbchunks.max_claimed") || node.equals("ftbchunks.max_force_loaded") || node.equals("ftbchunks.chunk_load_offline")) {
            FTBRanksIntegration.updateAll(event.getManager());
        }
    }

    private static void ranksReloaded(RanksReloadedEvent event) {
        FTBRanksIntegration.updateAll(event.getManager());
    }

    private static void conditionChanged(ConditionChangedEvent event) {
        FTBRanksIntegration.updateAll(event.getManager());
    }

    private static void updateAll(RankManager manager) {
        if (FTBChunksAPI.isManagerLoaded()) {
            manager.getServer().method_3760().method_14571().forEach(player -> {
                FTBChunksTeamData data = FTBChunksAPI.getManager().getData((class_3222)player);
                data.setForceLoadMember(player.method_5667(), PermissionsHelper.getInstance().getChunkLoadOffline((class_3222)player, false));
            });
            FTBTeamsAPI.getManager().getTeams().forEach(team -> FTBChunksAPI.getManager().getData((Team)team).updateLimits());
        }
    }

    private static void updateForPlayer(RankManager manager, GameProfile profile) {
        Team team = FTBTeamsAPI.getPlayerTeam((UUID)profile.getId());
        if (team != null) {
            FTBChunksTeamData teamData = FTBChunksAPI.getManager().getData(team);
            class_3222 player = manager.getServer().method_3760().method_14602(profile.getId());
            if (player != null) {
                teamData.setForceLoadMember(player.method_5667(), PermissionsHelper.getInstance().getChunkLoadOffline(player, false));
            }
            teamData.updateLimits();
        }
    }
}

