/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.compat.commonprot;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.Protection;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.common.protection.api.ProtectionProvider;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class FTBChunksProtectionProvider
implements ProtectionProvider {
    public static class_2960 ID = new class_2960("ftbchunks", "provider");
    private static LoadingCache<GameProfile, class_3222> FAKE_PLAYERS = null;

    public static void init() {
        CommonProtection.register((class_2960)ID, (ProtectionProvider)new FTBChunksProtectionProvider());
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            FAKE_PLAYERS = CacheBuilder.newBuilder().initialCapacity(64).expireAfterWrite(30L, TimeUnit.SECONDS).softValues().build(CacheLoader.from(profile -> new OfflineServerPlayer(server.method_30002(), (GameProfile)profile)));
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            FAKE_PLAYERS = null;
        });
    }

    public boolean isProtected(class_1937 world, class_2338 pos) {
        return FTBChunksAPI.getManager().getChunk(new ChunkDimPos(world, pos)) != null;
    }

    public boolean isAreaProtected(class_1937 world, class_238 area) {
        int minCX = (int)Math.floor(area.field_1323 / 16.0);
        int minCZ = (int)Math.floor(area.field_1323 / 16.0);
        int maxCX = (int)Math.ceil(area.field_1320 / 16.0);
        int maxCZ = (int)Math.ceil(area.field_1324 / 16.0);
        for (int cx = minCX; cx < maxCX; ++cx) {
            for (int cz = minCZ; cz < maxCZ; ++cz) {
                if (FTBChunksAPI.getManager().getChunk(new ChunkDimPos(world.method_27983(), cx, cz)) == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canBreakBlock(class_1937 world, class_2338 pos, GameProfile profile, class_1657 player) {
        player = FTBChunksProtectionProvider.tryResolvePlayer(world, profile);
        if (player == null) {
            return true;
        }
        return !FTBChunksAPI.getManager().protect((class_1297)player, class_1268.field_5808, pos, FTBChunksExpected.getBlockBreakProtection(), null);
    }

    public boolean canExplodeBlock(class_1937 world, class_2338 pos, class_1927 explosion, GameProfile profile, class_1657 player) {
        if (explosion.field_9185 == null && !((Boolean)FTBChunksWorldConfig.PROTECT_UNKNOWN_EXPLOSIONS.get()).booleanValue()) {
            return true;
        }
        ChunkDimPos chunkPos = new ChunkDimPos(world, pos);
        ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(chunkPos);
        return chunk == null || chunk.allowExplosions();
    }

    public boolean canPlaceBlock(class_1937 world, class_2338 pos, GameProfile profile, class_1657 player) {
        player = FTBChunksProtectionProvider.tryResolvePlayer(world, profile);
        if (player == null) {
            return true;
        }
        return !FTBChunksAPI.getManager().protect((class_1297)player, class_1268.field_5808, pos, FTBChunksExpected.getBlockPlaceProtection(), null);
    }

    public boolean canInteractBlock(class_1937 world, class_2338 pos, GameProfile profile, class_1657 player) {
        player = FTBChunksProtectionProvider.tryResolvePlayer(world, profile);
        if (player == null) {
            return true;
        }
        return !FTBChunksAPI.getManager().protect((class_1297)player, class_1268.field_5808, pos, FTBChunksExpected.getBlockInteractProtection(), null);
    }

    public boolean canInteractEntity(class_1937 world, class_1297 entity, GameProfile profile, class_1657 player) {
        player = FTBChunksProtectionProvider.tryResolvePlayer(world, profile);
        if (player == null) {
            return true;
        }
        return !FTBChunksAPI.getManager().protect((class_1297)player, class_1268.field_5808, entity.method_24515(), Protection.INTERACT_ENTITY, entity);
    }

    public boolean canDamageEntity(class_1937 world, class_1297 entity, GameProfile profile, class_1657 player) {
        if (entity instanceof class_1309) {
            return true;
        }
        player = FTBChunksProtectionProvider.tryResolvePlayer(world, profile);
        if (player == null) {
            return true;
        }
        return !FTBChunksAPI.getManager().protect((class_1297)player, class_1268.field_5808, entity.method_24515(), Protection.ATTACK_NONLIVING_ENTITY, entity);
    }

    @Nullable
    public static class_3222 tryResolvePlayer(class_1937 l, GameProfile profile) {
        if (!(l instanceof class_3218)) {
            return null;
        }
        class_3218 sl = (class_3218)l;
        class_3222 online = sl.method_8503().method_3760().method_14602(profile.getId());
        if (online != null) {
            return online;
        }
        return (class_3222)FAKE_PLAYERS.getUnchecked((Object)profile);
    }

    private static class OfflineServerPlayer
    extends class_3222 {
        public OfflineServerPlayer(class_3218 serverLevel, GameProfile gameProfile) {
            super(serverLevel.method_8503(), serverLevel, gameProfile, null);
        }
    }
}

