/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.ExplosionEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.Registries;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftbchunks.FTBCUtils;
import dev.ftb.mods.ftbchunks.FTBChunksCommands;
import dev.ftb.mods.ftbchunks.FTBChunksCommon;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.LongRangePlayerTracker;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.data.ClaimExpirationManager;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.data.Protection;
import dev.ftb.mods.ftbchunks.integration.ftbranks.FTBRanksIntegration;
import dev.ftb.mods.ftbchunks.integration.stages.StageHelper;
import dev.ftb.mods.ftbchunks.integration.waystones.WaystonesCommon;
import dev.ftb.mods.ftbchunks.net.ChunkSendingUtils;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.LoginDataPacket;
import dev.ftb.mods.ftbchunks.net.PlayerDeathPacket;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftbchunks.net.SendVisiblePlayerListPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.event.PlayerJoinedPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerLeftPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerTransferredTeamOwnershipEvent;
import dev.ftb.mods.ftbteams.event.TeamAllyEvent;
import dev.ftb.mods.ftbteams.event.TeamCollectPropertiesEvent;
import dev.ftb.mods.ftbteams.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.event.TeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1917;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FTBChunks {
    public static final String MOD_ID = "ftbchunks";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Chunks");
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().create();
    public static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    public static FTBChunks instance;
    public static FTBChunksCommon PROXY;
    public static final int TILES = 15;
    public static final int TILE_SIZE = 16;
    public static final int TILE_OFFSET = 7;
    public static final int MINIMAP_SIZE = 240;
    public static final XZ[] RELATIVE_SPIRAL_POSITIONS;
    public static final Registrar<class_2248> BLOCK_REGISTRY;

    public FTBChunks() {
        PROXY = (FTBChunksCommon)EnvExecutor.getEnvSpecific(() -> FTBChunksClient::new, () -> FTBChunksCommon::new);
        FTBChunksNet.init();
        for (int i = 0; i < RELATIVE_SPIRAL_POSITIONS.length; ++i) {
            FTBChunks.RELATIVE_SPIRAL_POSITIONS[i] = MathUtils.getSpiralPoint((int)(i + 1));
        }
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverBeforeStart);
        LifecycleEvent.SERVER_LEVEL_LOAD.register(this::serverLevelLoad);
        TeamManagerEvent.CREATED.register(this::teamManagerCreated);
        TeamManagerEvent.DESTROYED.register(this::teamManagerDestroyed);
        TeamEvent.PLAYER_LOGGED_IN.register(this::loggedIn);
        TeamEvent.CREATED.register(this::teamCreated);
        TeamEvent.LOADED.register(this::teamLoaded);
        TeamEvent.SAVED.register(this::teamSaved);
        TeamEvent.COLLECT_PROPERTIES.register(this::teamConfig);
        TeamEvent.PLAYER_JOINED_PARTY.register(this::playerJoinedParty);
        TeamEvent.PLAYER_LEFT_PARTY.register(this::playerLeftParty);
        TeamEvent.OWNERSHIP_TRANSFERRED.register(this::teamOwnershipTransferred);
        TeamEvent.PROPERTIES_CHANGED.register(this::teamPropertiesChanged);
        TeamEvent.ADD_ALLY.register(this::playerAllianceChange);
        TeamEvent.REMOVE_ALLY.register(this::playerAllianceChange);
        InteractionEvent.LEFT_CLICK_BLOCK.register(this::blockLeftClick);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(this::blockRightClick);
        InteractionEvent.RIGHT_CLICK_ITEM.register(this::itemRightClick);
        InteractionEvent.INTERACT_ENTITY.register(this::interactEntity);
        InteractionEvent.FARMLAND_TRAMPLE.register(this::farmlandTrample);
        BlockEvent.BREAK.register(this::blockBreak);
        BlockEvent.PLACE.register(this::blockPlace);
        PlayerEvent.PLAYER_QUIT.register(this::loggedOut);
        PlayerEvent.FILL_BUCKET.register(this::fillBucket);
        PlayerEvent.PLAYER_CLONE.register(this::playerCloned);
        PlayerEvent.CHANGE_DIMENSION.register(this::playerChangedDimension);
        PlayerEvent.ATTACK_ENTITY.register(this::playerAttackEntity);
        EntityEvent.ENTER_SECTION.register(this::enterSection);
        EntityEvent.LIVING_CHECK_SPAWN.register(this::checkSpawn);
        ExplosionEvent.DETONATE.register(this::explosionDetonate);
        CommandRegistrationEvent.EVENT.register(FTBChunksCommands::registerCommands);
        TickEvent.SERVER_POST.register(this::serverTickPost);
        TickEvent.PLAYER_POST.register(this::playerTickPost);
        if (Platform.isModLoaded((String)"ftbranks")) {
            FTBRanksIntegration.registerEvents();
        }
        if (Platform.isModLoaded((String)"waystones")) {
            WaystonesCommon.init();
        }
        PROXY.init();
    }

    private EventResult playerAttackEntity(class_1657 player, class_1937 level, class_1297 entity, class_1268 interactionHand, @Nullable class_3966 entityHitResult) {
        if (player instanceof class_3222 && !(entity instanceof class_1309) && FTBChunksAPI.getManager().protect((class_1297)player, interactionHand, entity.method_24515(), Protection.ATTACK_NONLIVING_ENTITY, entity)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private void playerTickPost(class_1657 player) {
        if (player.field_6002.field_9236 && player.field_6002.method_8510() % 20L == 0L) {
            PROXY.maybeClearDeathpoint(player);
        }
    }

    private void serverBeforeStart(MinecraftServer server) {
        Path configPath = server.method_27050(ConfigUtil.SERVER_CONFIG_DIR);
        ConfigUtil.loadDefaulted((SNBTConfig)FTBChunksWorldConfig.CONFIG, (Path)configPath, (String)MOD_ID);
    }

    private void serverLevelLoad(class_3218 level) {
        if (FTBChunksAPI.manager != null) {
            FTBChunksAPI.manager.initForceLoadedChunks(level);
        } else {
            LOGGER.warn("Level " + level.method_27983().method_29177() + " loaded before FTB Chunks manager was initialized! Unable to force-load chunks");
        }
    }

    private void teamManagerCreated(TeamManagerEvent event) {
        FTBChunksAPI.manager = new ClaimedChunkManager(event.getManager());
    }

    private void teamManagerDestroyed(TeamManagerEvent event) {
        FTBChunksAPI.manager = null;
    }

    private void loggedIn(PlayerLoggedInAfterTeamEvent event) {
        class_3222 player = event.getPlayer();
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.updateLimits();
        String playerId = event.getPlayer().method_5667().toString();
        LOGGER.debug("handling player team login: player = {}, team = {}", (Object)playerId, (Object)data.getTeamId());
        SNBTCompoundTag config = new SNBTCompoundTag();
        FTBChunksWorldConfig.CONFIG.write(config);
        new LoginDataPacket(event.getTeam().manager.getId(), config).sendTo(player);
        SendGeneralDataPacket.send(data, player);
        LOGGER.debug("server config and team data sent to {}", (Object)playerId);
        long now = System.currentTimeMillis();
        HashMap<Pair, List> chunksToSend = new HashMap<Pair, List>();
        for (ClaimedChunk chunk : FTBChunksAPI.getManager().getAllClaimedChunks()) {
            chunksToSend.computeIfAbsent(Pair.of((Object)chunk.pos.dimension, (Object)chunk.teamData.getTeamId()), s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, chunk.pos.x, chunk.pos.z, chunk));
        }
        chunksToSend.forEach((dimensionAndId, chunkPackets) -> {
            Team team = FTBTeamsAPI.getManager().getTeamByID((UUID)dimensionAndId.getRight());
            FTBChunksTeamData teamData = FTBChunksAPI.getManager().getData(team);
            if (teamData.canUse(player, FTBChunksTeamData.CLAIM_VISIBILITY)) {
                SendManyChunksPacket packet = new SendManyChunksPacket((class_5321<class_1937>)((class_5321)dimensionAndId.getLeft()), (UUID)dimensionAndId.getRight(), (List<SendChunkPacket.SingleChunk>)chunkPackets);
                packet.sendTo(player);
            }
        });
        LOGGER.debug("claimed chunk data sent to {}", (Object)playerId);
        data.setLastLoginTime(now);
        data.setForceLoadMember(player.method_5667(), FTBChunksWorldConfig.canPlayerOfflineForceload(player));
        if (data.getTeam().getOnlineMembers().size() == 1 && !data.canForceLoadChunks()) {
            data.updateChunkTickets(true);
        }
        SendVisiblePlayerListPacket.syncToLevel(player.field_6002);
        LOGGER.debug("visible player list sent to {}", (Object)playerId);
    }

    public void loggedOut(class_3222 player) {
        if (!(FTBTeamsAPI.isManagerLoaded() && FTBChunksAPI.isManagerLoaded() && FTBChunksAPI.getManager().hasData(player))) {
            return;
        }
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.setForceLoadMember(player.method_5667(), FTBChunksWorldConfig.canPlayerOfflineForceload(player));
        FTBChunksAPI.getManager().clearForceLoadedCache();
        LongRangePlayerTracker.INSTANCE.stopTracking(player);
        if (data.getTeam().getOnlineMembers().size() == 1 && !data.canForceLoadChunks()) {
            data.updateChunkTickets(false);
        }
    }

    private void teamCreated(TeamCreatedEvent teamEvent) {
        FTBChunksAPI.manager.getData(teamEvent.getTeam());
    }

    private void teamLoaded(TeamEvent teamEvent) {
        FTBChunksAPI.manager.getData(teamEvent.getTeam());
    }

    private void teamSaved(TeamEvent teamEvent) {
        FTBChunksAPI.manager.getData(teamEvent.getTeam()).saveNow();
    }

    public EventResult blockLeftClick(class_1657 player, class_1268 hand, class_2338 pos, class_2350 face) {
        if (player instanceof class_3222 && FTBChunksAPI.getManager().protect((class_1297)player, hand, pos, FTBChunksExpected.getBlockBreakProtection(), null)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult blockRightClick(class_1657 player, class_1268 hand, class_2338 pos, class_2350 face) {
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            if (FTBChunksAPI.getManager().protect((class_1297)player, hand, pos, FTBChunksExpected.getBlockInteractProtection(), null)) {
                FTBCUtils.forceHeldItemSync(sp, hand);
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    public CompoundEventResult<class_1799> itemRightClick(class_1657 player, class_1268 hand) {
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            if (FTBChunksAPI.getManager().protect((class_1297)player, hand, new class_2338(player.method_5836(1.0f)), Protection.RIGHT_CLICK_ITEM, null)) {
                FTBCUtils.forceHeldItemSync(sp, hand);
                return CompoundEventResult.interruptFalse((Object)player.method_5998(hand));
            }
        }
        return CompoundEventResult.pass();
    }

    private EventResult interactEntity(class_1657 player, class_1297 entity, class_1268 hand) {
        if (player instanceof class_3222 && FTBChunksAPI.getManager().protect((class_1297)player, hand, entity.method_24515(), Protection.INTERACT_ENTITY, entity)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult blockBreak(class_1937 level, class_2338 pos, class_2680 blockState, class_3222 player, @Nullable IntValue intValue) {
        if (FTBChunksAPI.getManager().protect((class_1297)player, class_1268.field_5808, pos, FTBChunksExpected.getBlockBreakProtection(), null)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult blockPlace(class_1937 level, class_2338 pos, class_2680 blockState, @Nullable class_1297 entity) {
        if (entity instanceof class_3222) {
            class_3222 sp = (class_3222)entity;
            if (FTBChunksAPI.getManager().protect(entity, class_1268.field_5808, pos, FTBChunksExpected.getBlockPlaceProtection(), null)) {
                FTBCUtils.forceHeldItemSync(sp, class_1268.field_5808);
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    public CompoundEventResult<class_1799> fillBucket(class_1657 player, class_1937 level, class_1799 emptyBucket, @Nullable class_239 target) {
        if (player instanceof class_3222 && target instanceof class_3965) {
            class_3965 hitResult = (class_3965)target;
            class_1268 hand = player.method_6058();
            if (FTBChunksAPI.getManager().protect((class_1297)player, hand, hitResult.method_17777(), Protection.EDIT_FLUID, null)) {
                return CompoundEventResult.interrupt((Boolean)false, (Object)player.method_5998(hand));
            }
        }
        return CompoundEventResult.pass();
    }

    public EventResult farmlandTrample(class_1937 world, class_2338 pos, class_2680 blockState, float distance, class_1297 entity) {
        if (entity instanceof class_3222 && FTBChunksAPI.getManager().protect(entity, class_1268.field_5808, pos, Protection.EDIT_BLOCK, null)) {
            return EventResult.interrupt((Boolean)false);
        }
        return EventResult.pass();
    }

    public void enterSection(class_1297 entity, int chunkX, int chunkY, int chunkZ, int prevX, int prevY, int prevZ) {
        class_3222 player;
        block11: {
            block10: {
                if (chunkX == prevX && chunkZ == prevZ && chunkY != prevY) {
                    return;
                }
                if (!(entity instanceof class_3222)) break block10;
                player = (class_3222)entity;
                if (!PlayerHooks.isFake((class_1657)((class_3222)entity))) break block11;
            }
            return;
        }
        if (!FTBTeamsAPI.isManagerLoaded() || !FTBChunksAPI.isManagerLoaded()) {
            return;
        }
        Team team = FTBTeamsAPI.getPlayerTeam((UUID)player.method_5667());
        if (team == null) {
            return;
        }
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(team);
        if (data.prevChunkX != chunkX || data.prevChunkZ != chunkZ) {
            String s;
            ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos((class_1297)player));
            String string = s = chunk == null ? "-" : chunk.getTeamData().getTeamId().toString();
            if (!data.lastChunkID.equals(s)) {
                data.lastChunkID = s;
                if (chunk != null) {
                    player.method_7353(chunk.getTeamData().getTeam().getColoredName(), true);
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"wilderness").method_27692(class_124.field_1077), true);
                }
            }
            data.prevChunkX = chunkX;
            data.prevChunkZ = chunkZ;
        }
    }

    public EventResult checkSpawn(class_1309 entity, class_1936 level, double x, double y, double z, class_3730 type, @Nullable class_1917 spawner) {
        if (!level.method_8608() && !(entity instanceof class_1657) && level instanceof class_1937) {
            switch (type) {
                case field_16459: 
                case field_16472: 
                case field_16469: 
                case field_16474: 
                case field_16460: 
                case field_16527: {
                    ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos((class_1937)level, new class_2338(x, y, z)));
                    if (chunk == null || chunk.canEntitySpawn((class_1297)entity)) break;
                    return EventResult.interrupt((Boolean)false);
                }
            }
        }
        return EventResult.pass();
    }

    private boolean ignoreExplosion(class_1937 level, class_1927 explosion) {
        if (level.method_8608() || explosion.method_8346().isEmpty()) {
            return true;
        }
        return explosion.field_9185 == null && (Boolean)FTBChunksWorldConfig.PROTECT_UNKNOWN_EXPLOSIONS.get() == false;
    }

    public void explosionDetonate(class_1937 level, class_1927 explosion, List<class_1297> affectedEntities) {
        if (this.ignoreExplosion(level, explosion)) {
            return;
        }
        ArrayList list = new ArrayList(explosion.method_8346());
        explosion.method_8352();
        HashMap<ChunkDimPos, Boolean> map = new HashMap<ChunkDimPos, Boolean>();
        for (class_2338 pos : list) {
            if (!map.computeIfAbsent(new ChunkDimPos(level, pos), cpos -> {
                ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk((ChunkDimPos)cpos);
                return chunk == null || chunk.allowExplosions();
            }).booleanValue()) continue;
            explosion.method_8346().add(pos);
        }
    }

    private void playerCloned(class_3222 oldPlayer, class_3222 newPlayer, boolean wonGame) {
        if (!wonGame) {
            newPlayer.method_43122().ifPresent(loc -> {
                class_5321 dim = loc.method_19442();
                int x = loc.method_19446().method_10263();
                int y = loc.method_19446().method_10264();
                int z = loc.method_19446().method_10260();
                int num = newPlayer.method_14248().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15421));
                new PlayerDeathPacket((class_5321<class_1937>)dim, x, y, z, num).sendTo(newPlayer);
            });
        }
    }

    private void playerChangedDimension(class_3222 serverPlayer, class_5321<class_1937> oldLevel, class_5321<class_1937> newLevel) {
        LongRangePlayerTracker.INSTANCE.stopTracking(serverPlayer);
        StageHelper.INSTANCE.get().sync(serverPlayer);
    }

    private void teamConfig(TeamCollectPropertiesEvent event) {
        event.add((TeamProperty)FTBChunksTeamData.ALLOW_EXPLOSIONS);
        event.add((TeamProperty)FTBChunksTeamData.ALLOW_MOB_GRIEFING);
        event.add((TeamProperty)FTBChunksTeamData.ALLOW_ALL_FAKE_PLAYERS);
        event.add((TeamProperty)FTBChunksTeamData.ALLOW_NAMED_FAKE_PLAYERS);
        event.add((TeamProperty)FTBChunksTeamData.ALLOW_FAKE_PLAYERS_BY_ID);
        FTBChunksExpected.getPlatformSpecificProperties(event);
        event.add((TeamProperty)FTBChunksTeamData.ENTITY_INTERACT_MODE);
        event.add((TeamProperty)FTBChunksTeamData.NONLIVING_ENTITY_ATTACK_MODE);
        event.add((TeamProperty)FTBChunksTeamData.CLAIM_VISIBILITY);
        event.add((TeamProperty)FTBChunksTeamData.LOCATION_MODE);
    }

    private void playerJoinedParty(PlayerJoinedPartyTeamEvent event) {
        FTBChunksTeamData playerData = FTBChunksAPI.getManager().getData((Team)event.getPreviousTeam());
        FTBChunksTeamData partyData = FTBChunksAPI.getManager().getData(event.getTeam());
        partyData.addMemberData(event.getPlayer(), playerData);
        partyData.updateLimits();
        this.transferClaims(playerData, partyData, playerData.getClaimedChunks());
        partyData.setForceLoadMember(event.getPlayer().method_5667(), FTBChunksWorldConfig.canPlayerOfflineForceload(event.getPlayer()));
        SendVisiblePlayerListPacket.syncToLevel(event.getPlayer().field_6002);
        partyData.syncChunksToPlayer(event.getPlayer());
    }

    private void playerLeftParty(PlayerLeftPartyTeamEvent event) {
        FTBChunksTeamData partyData = FTBChunksAPI.getManager().getData(event.getTeam());
        PlayerTeam personalTeam = FTBTeamsAPI.getManager().getInternalPlayerTeam(event.getPlayerId());
        if (personalTeam != null) {
            FTBChunksTeamData playerData = FTBChunksAPI.getManager().getData((Team)personalTeam);
            if (event.getTeamDeleted()) {
                this.transferClaims(partyData, playerData, partyData.getClaimedChunks());
                FTBChunksAPI.getManager().deleteTeam(event.getTeam());
            } else {
                this.transferClaims(partyData, playerData, partyData.getOriginalClaims(event.getPlayerId()));
            }
        }
        partyData.deleteMemberData(event.getPlayerId());
        partyData.updateLimits();
        if (event.getPlayer() != null) {
            SendVisiblePlayerListPacket.syncToLevel(event.getPlayer().field_6002);
            partyData.syncChunksToPlayer(event.getPlayer());
        }
    }

    private void transferClaims(FTBChunksTeamData transferFrom, FTBChunksTeamData transferTo, Collection<ClaimedChunk> chunksToTransfer) {
        class_2168 sourceStack = FTBTeamsAPI.getManager().server.method_3739();
        HashMap<class_5321, List> chunksToSend = new HashMap<class_5321, List>();
        HashMap<class_5321, List> chunksToUnclaim = new HashMap<class_5321, List>();
        int chunks = 0;
        long now = System.currentTimeMillis();
        int total = transferTo.getClaimedChunks().size();
        for (ClaimedChunk chunk : chunksToTransfer) {
            class_3218 level;
            if (total >= transferTo.getMaxClaimChunks()) {
                chunk.unclaim(sourceStack, false);
                chunksToUnclaim.computeIfAbsent(chunk.pos.dimension, s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, chunk.pos.x, chunk.pos.z, null));
            } else {
                chunk.teamData = transferTo;
                chunksToSend.computeIfAbsent(chunk.pos.dimension, s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, chunk.pos.x, chunk.pos.z, chunk));
                ++chunks;
            }
            if (chunk.isForceLoaded() && (level = FTBChunksAPI.getManager().getMinecraftServer().method_3847(chunk.pos.dimension)) != null) {
                FTBChunksExpected.addChunkToForceLoaded(level, MOD_ID, transferFrom.getTeamId(), chunk.pos.x, chunk.pos.z, false);
                if (chunk.isActuallyForceLoaded()) {
                    FTBChunksExpected.addChunkToForceLoaded(level, MOD_ID, transferTo.getTeamId(), chunk.pos.x, chunk.pos.z, true);
                }
            }
            ++total;
        }
        transferFrom.save();
        transferTo.save();
        if (chunks > 0) {
            chunksToSend.forEach((dimension, chunkPackets) -> {
                if (!chunkPackets.isEmpty()) {
                    ChunkSendingUtils.sendManyChunksToAll(sourceStack.method_9211(), transferTo, new SendManyChunksPacket((class_5321<class_1937>)dimension, transferTo.getTeamId(), (List<SendChunkPacket.SingleChunk>)chunkPackets));
                }
            });
            chunksToUnclaim.forEach((dimension, chunkPackets) -> {
                if (!chunkPackets.isEmpty()) {
                    new SendManyChunksPacket((class_5321<class_1937>)dimension, class_156.field_25140, (List<SendChunkPacket.SingleChunk>)chunkPackets).sendToAll(sourceStack.method_9211());
                }
            });
            LOGGER.info("Transferred " + chunks + "/" + total + " chunks from " + transferFrom + " to " + transferTo);
        }
    }

    private void teamOwnershipTransferred(PlayerTransferredTeamOwnershipEvent event) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(event.getTeam());
        data.updateLimits();
    }

    private void teamPropertiesChanged(TeamPropertiesChangedEvent event) {
        MinecraftServer server = FTBChunksAPI.getManager().getMinecraftServer();
        if (server == null) {
            return;
        }
        if (event.getOldProperties().get((TeamProperty)FTBChunksTeamData.LOCATION_MODE) != event.getTeam().getProperty((TeamProperty)FTBChunksTeamData.LOCATION_MODE)) {
            SendVisiblePlayerListPacket.syncToAll();
        }
        if (event.getOldProperties().get((TeamProperty)FTBChunksTeamData.CLAIM_VISIBILITY) != event.getTeam().getProperty((TeamProperty)FTBChunksTeamData.CLAIM_VISIBILITY)) {
            FTBChunksTeamData teamData = FTBChunksAPI.getManager().getData(event.getTeam());
            teamData.syncChunksToAll(server);
        }
        FTBChunksAPI.getManager().getData(event.getTeam()).clearFakePlayerNameCache();
    }

    private void playerAllianceChange(TeamAllyEvent event) {
        FTBChunksTeamData teamData = FTBChunksAPI.getManager().getData(event.getTeam());
        ArrayList<class_3222> players = new ArrayList<class_3222>();
        event.getPlayers().forEach(profile -> {
            class_3222 p = FTBChunksAPI.getManager().getMinecraftServer().method_3760().method_14602(profile.getId());
            if (p != null) {
                teamData.syncChunksToPlayer(p);
                players.add(p);
            }
        });
        SendVisiblePlayerListPacket.syncToPlayers(players);
    }

    private void serverTickPost(MinecraftServer minecraftServer) {
        ClaimExpirationManager.INSTANCE.tick(minecraftServer);
        LongRangePlayerTracker.INSTANCE.tick(minecraftServer);
    }

    static {
        RELATIVE_SPIRAL_POSITIONS = new XZ[225];
        BLOCK_REGISTRY = Registries.get((String)MOD_ID).get(class_2378.field_25105);
    }
}

