/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdar.mixin;

import chronosacaria.mcdar.api.interfaces.Summonable;
import chronosacaria.mcdar.config.McdarConfig;
import chronosacaria.mcdar.effects.ArtifactEffects;
import chronosacaria.mcdar.effects.EnchantmentEffects;
import chronosacaria.mcdar.enchants.EnchantID;
import chronosacaria.mcdar.enums.DamagingArtifactID;
import chronosacaria.mcdar.init.StatusEffectInit;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    @Inject(method={"tryUseTotem"}, at={@At(value="HEAD")}, cancellable=true)
    public void onSoulProtectionDeath(class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        class_1309 livingEntity = (class_1309)this;
        if (livingEntity.method_6059(StatusEffectInit.SOUL_PROTECTION)) {
            livingEntity.method_6033(1.0f);
            livingEntity.method_6012();
            livingEntity.method_6092(new class_1293(class_1294.field_5924, 900, 1));
            livingEntity.method_6092(new class_1293(class_1294.field_5918, 900, 1));
            livingEntity.method_6092(new class_1293(class_1294.field_5898, 100, 1));
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"swingHand(Lnet/minecraft/util/Hand;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onAttackWhilstStunnedNoTarget(class_1268 hand, CallbackInfo ci) {
        class_1309 livingEntity = (class_1309)this;
        if (livingEntity.method_6059(StatusEffectInit.STUNNED)) {
            ci.cancel();
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    public void onPowershakerExplodingKill(class_1282 source, CallbackInfo ci) {
        class_1297 class_12972 = source.method_5529();
        if (!(class_12972 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_12972;
        class_1309 target = (class_1309)this;
        if (McdarConfig.CONFIG.ENABLE_DAMAGING_ARTIFACT.get(DamagingArtifactID.POWERSHAKER).booleanValue()) {
            ArtifactEffects.activatePowerShaker(player, target);
        }
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true)
    public float mcdar$damageModifiers(float amount, class_1282 source) {
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof Summonable) {
            Summonable summonedEntity = (Summonable)class_12972;
            class_1937 class_19372 = source.method_5526().field_6002;
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                if (McdarConfig.CONFIG.ENABLE_ENCHANTMENT.get((Object)EnchantID.BEAST_BOSS).booleanValue()) {
                    amount *= EnchantmentEffects.beastBossDamage(summonedEntity, serverWorld);
                }
            }
        }
        return amount;
    }

    @Inject(method={"consumeItem"}, at={@At(value="HEAD")})
    public void mcdar$onConsume(CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)livingEntityMixin;
        if (player.method_5805() && player.field_6002 instanceof class_3218) {
            if (McdarConfig.CONFIG.ENABLE_ENCHANTMENT.get((Object)EnchantID.BEAST_BURST).booleanValue()) {
                EnchantmentEffects.activateBeastBurst(player);
            }
            if (McdarConfig.CONFIG.ENABLE_ENCHANTMENT.get((Object)EnchantID.BEAST_SURGE).booleanValue()) {
                EnchantmentEffects.activateBeastSurge(player);
            }
        }
    }
}

