/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdar.config;

import chronosacaria.mcdar.enchants.EnchantID;
import chronosacaria.mcdar.enums.AgilityArtifactID;
import chronosacaria.mcdar.enums.DamagingArtifactID;
import chronosacaria.mcdar.enums.DefensiveArtifactID;
import chronosacaria.mcdar.enums.QuiverArtifactID;
import chronosacaria.mcdar.enums.StatusInflictingArtifactID;
import chronosacaria.mcdar.enums.SummoningArtifactID;
import java.util.EnumMap;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="mcdar")
public class McdarConfig
implements ConfigData {
    public static final McdarConfig CONFIG;
    public final EnumMap<EnchantID, Boolean> ENABLE_ENCHANTMENT = new EnumMap(EnchantID.class);
    public final EnumMap<DamagingArtifactID, Boolean> ENABLE_DAMAGING_ARTIFACT = new EnumMap(DamagingArtifactID.class);
    public final EnumMap<StatusInflictingArtifactID, Boolean> ENABLE_STATUS_INFLICTING_ARTIFACT = new EnumMap(StatusInflictingArtifactID.class);
    public final EnumMap<QuiverArtifactID, Boolean> ENABLE_QUIVER_ARTIFACT = new EnumMap(QuiverArtifactID.class);
    public final EnumMap<SummoningArtifactID, Boolean> ENABLE_SUMMONING_ARTIFACT = new EnumMap(SummoningArtifactID.class);
    public final EnumMap<AgilityArtifactID, Boolean> ENABLE_AGILITY_ARTIFACT = new EnumMap(AgilityArtifactID.class);
    public final EnumMap<DefensiveArtifactID, Boolean> ENABLE_DEFENSIVE_ARTIFACT = new EnumMap(DefensiveArtifactID.class);
    @Comment(value="Artifact Durability")
    public final int AGILITY_ARTIFACT_DURABILITY = 64;
    public final int DAMAGING_ARTIFACT_DURABILITY = 64;
    public final int DEFENSIVE_ARTIFACT_DURABILITY = 64;
    public final int QUIVER_ARTIFACT_DURABILITY = 7;
    public final int STATUS_ARTIFACT_DURABILITY = 64;
    public final int SUMMONING_ARTIFACT_DURABILITY = 8;
    @Comment(value="Villager Artifact Spawn Rate (Percentage where 1.0 = 100%)")
    public final float VILLAGER_ARTIFACT_SPAWN_RATE = 0.25f;
    @Comment(value="Illager Artifact Spawn Rate (Percentage where 1.0 = 100%)")
    public final float ILLAGER_ARTIFACT_SPAWN_RATE = 0.25f;
    @Comment(value="World Artifact Spawn Rate (Percentage where 1.0 = 100%)")
    public final float WORLD_ARTIFACT_SPAWN_RATE = 0.1f;

    public int getAgilityArtifactDurability() {
        return 64;
    }

    public int getDamagingArtifactDurability() {
        return 64;
    }

    public int getDefensiveArtifactDurability() {
        return 64;
    }

    public int getQuiverArtifactDurability() {
        return 7;
    }

    public int getStatusArtifactDurability() {
        return 64;
    }

    public int getSummoningArtifactDurability() {
        return 8;
    }

    public float getVillagerArtifactSpawnRate() {
        return 0.25f;
    }

    public float getIllagerArtifactSpawnRate() {
        return 0.25f;
    }

    public float getWorldArtifactSpawnRate() {
        return 0.1f;
    }

    public McdarConfig() {
        for (EnchantID enchantID : EnchantID.values()) {
            this.ENABLE_ENCHANTMENT.put(enchantID, true);
        }
        for (Enum enum_ : AgilityArtifactID.values()) {
            this.ENABLE_AGILITY_ARTIFACT.put((AgilityArtifactID)enum_, true);
        }
        for (Enum enum_ : DamagingArtifactID.values()) {
            this.ENABLE_DAMAGING_ARTIFACT.put((DamagingArtifactID)enum_, true);
        }
        for (Enum enum_ : DefensiveArtifactID.values()) {
            this.ENABLE_DEFENSIVE_ARTIFACT.put((DefensiveArtifactID)enum_, true);
        }
        for (Enum enum_ : QuiverArtifactID.values()) {
            this.ENABLE_QUIVER_ARTIFACT.put((QuiverArtifactID)enum_, true);
        }
        for (Enum enum_ : StatusInflictingArtifactID.values()) {
            this.ENABLE_STATUS_INFLICTING_ARTIFACT.put((StatusInflictingArtifactID)enum_, true);
        }
        for (Enum enum_ : SummoningArtifactID.values()) {
            this.ENABLE_SUMMONING_ARTIFACT.put((SummoningArtifactID)enum_, true);
        }
    }

    static {
        AutoConfig.register(McdarConfig.class, JanksonConfigSerializer::new);
        CONFIG = (McdarConfig)AutoConfig.getConfigHolder(McdarConfig.class).getConfig();
    }
}

