/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.gui.biomepedia.screen;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_474;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5321;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import potionstudios.byg.client.gui.biomepedia.screen.AbstractBiomepediaScreen;
import potionstudios.byg.client.gui.biomepedia.screen.BiomeAboutScreen;
import potionstudios.byg.client.gui.biomepedia.widget.BiomeWidget;
import potionstudios.byg.mixin.access.client.EditBoxAccess;

public class BiomeListScreen
extends AbstractBiomepediaScreen {
    private final class_437 parent;
    private int pagePair;
    private class_344 searchButton;
    private class_474 next;
    private class_474 back;
    private class_342 search;
    private int pagePairsCount;
    private final Mutable<String> lastSearchInput = new MutableObject((Object)"");
    private List<class_5321<class_1959>> lastInput = new ArrayList<class_5321<class_1959>>();
    private BiomeWidget[][][] widgets;

    protected BiomeListScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)""));
        this.parent = parent;
    }

    public void method_25393() {
        super.method_25393();
        if (this.search != null) {
            this.search.method_1865();
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        class_2378 biomeRegistry = class_310.method_1551().field_1687.method_30349().method_30530(class_2378.field_25114);
        List<class_5321<class_1959>> resourceKeys = biomeRegistry.method_29722().stream().map(Map.Entry::getKey).filter(biomeResourceKey -> biomeResourceKey.method_29177().method_12836().equals("byg")).sorted(Comparator.comparing(class_5321::method_29177)).collect(Collectors.toList());
        if (this.widgets == null) {
            this.createMenu(resourceKeys, false);
            this.lastInput = resourceKeys;
        } else {
            this.createMenu(this.lastInput, false);
        }
        class_474 back = new class_474(this.pageBackButtonX, this.pageButtonY, false, button -> {
            if (this.pagePairsCount == 0) {
                return;
            }
            this.unload(this.pagePair);
            this.pagePair = this.pagePair == 0 ? this.pagePairsCount - 1 : (this.pagePair - 1) % this.pagePairsCount;
            this.load(this.pagePair);
        }, true);
        if (this.back != null) {
            back.field_22763 = this.back.field_22763;
            back.field_22764 = this.back.field_22764;
        }
        this.back = back;
        this.method_37063((class_364)this.back);
        this.back.field_22760 = this.leftPos + 15;
        this.back.field_22761 = this.topPos - this.back.method_25364() - 13;
        class_474 next = new class_474(this.pageButtonForwardX, this.pageButtonY, true, button -> {
            if (this.pagePairsCount == 0) {
                return;
            }
            this.unload(this.pagePair);
            this.pagePair = (this.pagePair + 1) % this.pagePairsCount;
            this.load(this.pagePair);
        }, true);
        if (this.next != null) {
            next.field_22763 = this.next.field_22763;
            next.field_22764 = this.next.field_22764;
        }
        this.next = next;
        this.method_37063((class_364)this.next);
        this.next.field_22760 = this.rightPos - this.back.method_25368() - 22;
        this.next.field_22761 = this.topPos - this.back.method_25364() - 13;
        this.load(this.pagePair);
        MutableBoolean snapToFront = new MutableBoolean(false);
        class_342 search = new class_342(this.field_22787.field_1772, this.leftPos + 15, this.bottomPos + 208 - 22, 150, 15, (class_2561)class_2561.method_43470((String)""));
        if (this.search != null) {
            search.field_22763 = this.search.field_22763;
            search.field_22764 = this.search.field_22764;
            search.method_1852(this.search.method_1882());
            search.method_1868(((EditBoxAccess)this.search).byg_getTextColor());
            snapToFront.setValue(true);
        } else {
            search.field_22763 = false;
            search.field_22764 = false;
        }
        this.search = search;
        this.search.method_1863(s -> this.updateForSearchValue(resourceKeys, (String)s, snapToFront.booleanValue()));
        this.searchButton = new class_344(this.leftPos + 15, this.bottomPos + 208 - 5, 20, 18, 0, 220, 18, new class_2960("byg", "textures/gui/biomepedia.png"), 256, 256, button -> {
            this.search.field_22764 = !this.search.field_22764;
            boolean bl = this.search.field_22763 = !this.search.field_22763;
            if (this.search.field_22764) {
                this.search.method_1876(true);
                this.back.field_22764 = false;
                this.back.field_22763 = false;
            } else {
                this.back.field_22764 = true;
                this.back.field_22763 = true;
            }
        }, (button, poseStack, mouseX, mouseZ) -> this.method_25424(poseStack, (class_2561)class_2561.method_43471((String)"biomepedia.biomelist.search"), mouseX, mouseZ), (class_2561)class_2561.method_43473());
        this.method_37063((class_364)this.searchButton);
        this.method_37063((class_364)this.search);
    }

    private void updateForSearchValue(List<class_5321<class_1959>> resourceKeys, String s, boolean snapToFront) {
        if (s.equals(this.lastSearchInput.getValue())) {
            return;
        }
        this.lastSearchInput.setValue((Object)s);
        if (s.isBlank()) {
            this.search.method_1868(class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
            this.createMenu(resourceKeys, snapToFront);
            this.lastInput = resourceKeys;
            return;
        }
        List<class_5321<class_1959>> searchResult = resourceKeys.stream().filter(biomeResourceKey -> biomeResourceKey.method_29177().method_12836().equals("byg")).sorted(Comparator.comparing(class_5321::method_29177)).filter(biome -> {
            class_5250 translatedComponent = class_2561.method_43471((String)("biome." + biome.method_29177().method_12836() + "." + biome.method_29177().method_12832()));
            return translatedComponent.getString().toLowerCase().contains(s.toLowerCase());
        }).toList();
        this.lastInput = searchResult;
        if (searchResult.isEmpty()) {
            this.search.method_1868(class_5253.class_5254.method_27764((int)255, (int)255, (int)0, (int)0));
        } else {
            this.search.method_1868(class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
        }
        this.createMenu(searchResult, snapToFront);
    }

    private void createMenu(List<class_5321<class_1959>> biomes, boolean snapToFront) {
        this.pagePairsCount = (int)Math.ceil((double)biomes.size() / 4.0);
        int registryIdx = 0;
        int offsetFromEdge = 14;
        if (this.widgets != null) {
            this.forEachWidget(biomeWidget -> this.method_25396().remove(biomeWidget));
        }
        this.widgets = new BiomeWidget[Math.max(this.pagePairsCount, 1)][2][2];
        int xOffset = this.leftPos + offsetFromEdge + 4;
        for (BiomeWidget[][] pagePairs : this.widgets) {
            for (int pageSide = 0; pageSide < pagePairs.length; ++pageSide) {
                int startX = 136 * pageSide;
                int yOffset = this.bottomPos + offsetFromEdge;
                BiomeWidget[] page = pagePairs[pageSide];
                for (int yPos = 0; yPos < page.length && registryIdx <= biomes.size() - 1; ++registryIdx, ++yPos) {
                    class_5321<class_1959> biome = biomes.get(registryIdx);
                    page[yPos] = (BiomeWidget)this.method_25429((class_364)new BiomeWidget(biome, xOffset + startX, yOffset, 115, 77, button -> this.field_22787.method_1507((class_437)new BiomeAboutScreen(biome, this))));
                    yOffset = (int)((double)yOffset + 87.03703703703704);
                }
            }
        }
        if (this.widgets.length - 1 < this.pagePair || snapToFront) {
            this.pagePair = 0;
        }
        if (this.back != null && this.next != null) {
            if (this.pagePairsCount > 1) {
                this.back.field_22763 = true;
                this.back.field_22764 = true;
                this.next.field_22763 = true;
                this.next.field_22764 = true;
            } else {
                this.back.field_22763 = false;
                this.back.field_22764 = false;
                this.next.field_22763 = false;
                this.next.field_22764 = false;
            }
            this.forEachWidget(biomeWidget -> {
                biomeWidget.field_22764 = false;
                biomeWidget.field_22763 = false;
            });
            this.load(this.pagePair);
        }
    }

    private void forEachWidget(Consumer<BiomeWidget> widget) {
        BiomeWidget[][][] biomeWidgetArray = this.widgets;
        int n = biomeWidgetArray.length;
        for (int i = 0; i < n; ++i) {
            BiomeWidget[][] widgetsForPage;
            BiomeWidget[][] biomeWidgetArray2 = widgetsForPage = biomeWidgetArray[i];
            int n2 = biomeWidgetArray2.length;
            for (int j = 0; j < n2; ++j) {
                BiomeWidget[] biomeWidgets;
                for (BiomeWidget biomeWidget : biomeWidgets = biomeWidgetArray2[j]) {
                    if (biomeWidget == null) continue;
                    widget.accept(biomeWidget);
                }
            }
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    @Override
    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        this.forEachWidget(biomeWidget -> biomeWidget.method_25394(poseStack, mouseX, mouseY, partialTick));
    }

    private void unload(int page) {
        BiomeWidget[][] biomeWidgets;
        BiomeWidget[][] biomeWidgetArray = biomeWidgets = this.widgets[page];
        int n = biomeWidgetArray.length;
        for (int i = 0; i < n; ++i) {
            BiomeWidget[] biomeWidgetsByPage;
            for (BiomeWidget biomeWidget : biomeWidgetsByPage = biomeWidgetArray[i]) {
                if (biomeWidget == null) continue;
                biomeWidget.field_22764 = false;
                biomeWidget.field_22763 = false;
            }
        }
    }

    private void load(int page) {
        BiomeWidget[][] biomeWidgets;
        BiomeWidget[][] biomeWidgetArray = biomeWidgets = this.widgets[page];
        int n = biomeWidgetArray.length;
        for (int i = 0; i < n; ++i) {
            BiomeWidget[] biomeWidgetsByPage;
            for (BiomeWidget biomeWidget : biomeWidgetsByPage = biomeWidgetArray[i]) {
                if (biomeWidget == null) continue;
                biomeWidget.field_22764 = true;
                biomeWidget.field_22763 = true;
            }
        }
    }
}

