/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.worldgen.AllPlacementModifiers;
import com.simibubi.create.foundation.worldgen.OreFeatureConfigEntry;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_5444;
import net.minecraft.class_5819;
import net.minecraft.class_6797;
import net.minecraft.class_6798;

public class ConfigDrivenPlacement
extends class_6797 {
    public static final Codec<ConfigDrivenPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OreFeatureConfigEntry.CODEC.fieldOf("entry").forGetter(ConfigDrivenPlacement::getEntry)).apply((Applicative)instance, ConfigDrivenPlacement::new));
    private final OreFeatureConfigEntry entry;

    public ConfigDrivenPlacement(OreFeatureConfigEntry entry) {
        this.entry = entry;
    }

    public Stream<class_2338> method_14452(class_5444 context, class_5819 random, class_2338 pos) {
        int count = this.getCount(this.getFrequency(), random);
        if (count == 0) {
            return Stream.empty();
        }
        int minY = this.getMinY();
        int maxY = this.getMaxY();
        return IntStream.range(0, count).mapToObj(i -> pos).map(p -> {
            int x = random.method_43048(16) + p.method_10263();
            int z = random.method_43048(16) + p.method_10260();
            int y = class_3532.method_32751((class_5819)random, (int)minY, (int)maxY);
            return new class_2338(x, y, z);
        });
    }

    public int getCount(float frequency, class_5819 random) {
        int floored = class_3532.method_15375((float)frequency);
        return floored + (random.method_43057() < frequency - (float)floored ? 1 : 0);
    }

    public class_6798<?> method_39615() {
        return (class_6798)AllPlacementModifiers.CONFIG_DRIVEN.get();
    }

    public OreFeatureConfigEntry getEntry() {
        return this.entry;
    }

    public float getFrequency() {
        if (((Boolean)AllConfigs.COMMON.worldGen.disable.get()).booleanValue()) {
            return 0.0f;
        }
        return this.entry.frequency.getF();
    }

    public int getMinY() {
        return (Integer)this.entry.minHeight.get();
    }

    public int getMaxY() {
        return (Integer)this.entry.maxHeight.get();
    }
}

