/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.element;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.element.AnimatedSceneElement;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.AngleHelper;
import java.util.function.Supplier;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1453;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_898;

public class ParrotElement
extends AnimatedSceneElement {
    private class_243 location;
    private class_1453 entity;
    private ParrotPose pose;
    private boolean deferConductor = false;
    private Supplier<? extends ParrotPose> initialPose;

    public static ParrotElement create(class_243 location, Supplier<? extends ParrotPose> pose) {
        return new ParrotElement(location, pose);
    }

    protected ParrotElement(class_243 location, Supplier<? extends ParrotPose> pose) {
        this.location = location;
        this.initialPose = pose;
        this.setPose(this.initialPose.get());
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        this.setPose(this.initialPose.get());
        this.entity.method_23327(0.0, 0.0, 0.0);
        this.entity.field_6014 = 0.0;
        this.entity.field_6036 = 0.0;
        this.entity.field_5969 = 0.0;
        this.entity.field_6038 = 0.0;
        this.entity.field_5971 = 0.0;
        this.entity.field_5989 = 0.0;
        this.entity.field_6004 = 0.0f;
        this.entity.method_36457(0.0f);
        this.entity.field_5982 = 180.0f;
        this.entity.method_36456(180.0f);
        this.entity.getExtraCustomData().method_10551("TrainHat");
        this.deferConductor = false;
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.entity == null) {
            this.entity = this.pose.create(scene.getWorld());
            this.entity.field_5982 = 180.0f;
            this.entity.method_36456(180.0f);
            if (this.deferConductor) {
                this.setConductor(this.deferConductor);
            }
            this.deferConductor = false;
        }
        ++this.entity.field_6012;
        this.entity.field_6259 = this.entity.field_6241;
        this.entity.field_6827 = this.entity.field_6819;
        this.entity.field_6829 = this.entity.field_6818;
        this.entity.method_24830(true);
        this.entity.field_6014 = this.entity.method_23317();
        this.entity.field_6036 = this.entity.method_23318();
        this.entity.field_5969 = this.entity.method_23321();
        this.entity.field_5982 = this.entity.method_36454();
        this.entity.field_6004 = this.entity.method_36455();
        this.pose.tick(scene, this.entity, this.location);
        this.entity.field_6038 = this.entity.method_23317();
        this.entity.field_5971 = this.entity.method_23318();
        this.entity.field_5989 = this.entity.method_23321();
    }

    public void setPositionOffset(class_243 position, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.entity.method_5814(position.field_1352, position.field_1351, position.field_1350);
        if (!immediate) {
            return;
        }
        this.entity.field_6014 = position.field_1352;
        this.entity.field_6036 = position.field_1351;
        this.entity.field_5969 = position.field_1350;
    }

    public void setRotation(class_243 eulers, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.entity.method_36457((float)eulers.field_1352);
        this.entity.method_36456((float)eulers.field_1351);
        if (!immediate) {
            return;
        }
        this.entity.field_6004 = this.entity.method_36455();
        this.entity.field_5982 = this.entity.method_36454();
    }

    public void setConductor(boolean isConductor) {
        if (this.entity == null) {
            this.deferConductor = isConductor;
            return;
        }
        class_2487 data = this.entity.getExtraCustomData();
        if (isConductor) {
            data.method_10556("TrainHat", true);
        } else {
            data.method_10551("TrainHat");
        }
    }

    public class_243 getPositionOffset() {
        return this.entity != null ? this.entity.method_19538() : class_243.field_1353;
    }

    public class_243 getRotation() {
        return this.entity != null ? new class_243((double)this.entity.method_36455(), (double)this.entity.method_36454(), 0.0) : class_243.field_1353;
    }

    @Override
    protected void renderLast(PonderWorld world, class_4597 buffer, class_4587 ms, float fade, float pt) {
        class_898 entityrenderermanager = class_310.method_1551().method_1561();
        if (this.entity == null) {
            this.entity = this.pose.create(world);
            this.entity.field_5982 = 180.0f;
            this.entity.method_36456(180.0f);
        }
        ms.method_22903();
        ms.method_22904(this.location.field_1352, this.location.field_1351, this.location.field_1350);
        ms.method_22904(class_3532.method_16436((double)pt, (double)this.entity.field_6014, (double)this.entity.method_23317()), class_3532.method_16436((double)pt, (double)this.entity.field_6036, (double)this.entity.method_23318()), class_3532.method_16436((double)pt, (double)this.entity.field_5969, (double)this.entity.method_23321()));
        TransformStack.cast((class_4587)ms).rotateY((double)AngleHelper.angleLerp(pt, this.entity.field_5982, this.entity.method_36454()));
        entityrenderermanager.method_3954((class_1297)this.entity, 0.0, 0.0, 0.0, 0.0f, pt, ms, buffer, this.lightCoordsFromFade(fade));
        ms.method_22909();
    }

    public void setPose(ParrotPose pose) {
        this.pose = pose;
    }

    public static abstract class ParrotPose {
        abstract void tick(PonderScene var1, class_1453 var2, class_243 var3);

        class_1453 create(PonderWorld world) {
            class_1453 entity = new class_1453(class_1299.field_6104, (class_1937)world);
            int nextInt = Create.RANDOM.nextInt(5);
            entity.method_6585(nextInt == 1 ? 0 : nextInt);
            return entity;
        }
    }

    public static class FaceCursorPose
    extends FaceVecPose {
        @Override
        protected class_243 getFacedVec(PonderScene scene) {
            class_310 minecraft = class_310.method_1551();
            class_1041 w = minecraft.method_22683();
            double mouseX = minecraft.field_1729.method_1603() * (double)w.method_4486() / (double)w.method_4480();
            double mouseY = minecraft.field_1729.method_1604() * (double)w.method_4502() / (double)w.method_4507();
            return scene.getTransform().screenToScene(mouseX, mouseY, 300, 0.0f);
        }
    }

    public static class FacePointOfInterestPose
    extends FaceVecPose {
        @Override
        protected class_243 getFacedVec(PonderScene scene) {
            return scene.getPointOfInterest();
        }
    }

    public static abstract class FaceVecPose
    extends ParrotPose {
        @Override
        void tick(PonderScene scene, class_1453 entity, class_243 location) {
            class_243 p_200602_2_ = this.getFacedVec(scene);
            class_243 Vector3d = location.method_1019(entity.method_5836(0.0f));
            double d0 = p_200602_2_.field_1352 - Vector3d.field_1352;
            double d1 = p_200602_2_.field_1351 - Vector3d.field_1351;
            double d2 = p_200602_2_.field_1350 - Vector3d.field_1350;
            double d3 = class_3532.method_15355((float)((float)(d0 * d0 + d2 * d2)));
            float targetPitch = class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)d1, (double)d3) * 57.2957763671875))));
            float targetYaw = class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)d2, (double)d0) * 57.2957763671875)) + 90.0f));
            entity.method_36457(AngleHelper.angleLerp(0.4f, entity.method_36455(), targetPitch));
            entity.method_36456(AngleHelper.angleLerp(0.4f, entity.method_36454(), targetYaw));
        }

        protected abstract class_243 getFacedVec(PonderScene var1);
    }

    public static class SpinOnComponentPose
    extends ParrotPose {
        private class_2338 componentPos;

        public SpinOnComponentPose(class_2338 componentPos) {
            this.componentPos = componentPos;
        }

        @Override
        void tick(PonderScene scene, class_1453 entity, class_243 location) {
            class_2586 tileEntity = scene.getWorld().method_8321(this.componentPos);
            if (!(tileEntity instanceof KineticTileEntity)) {
                return;
            }
            float rpm = ((KineticTileEntity)tileEntity).getSpeed();
            entity.field_5982 = entity.method_36454();
            entity.method_36456(entity.method_36454() + rpm * 0.3f);
        }
    }

    public static class FlappyPose
    extends ParrotPose {
        @Override
        void tick(PonderScene scene, class_1453 entity, class_243 location) {
            double length = entity.method_19538().method_1023(entity.field_6038, entity.field_5971, entity.field_5989).method_1033();
            entity.method_24830(false);
            double phase = Math.min(length * 15.0, 8.0);
            float f = (float)((double)(PonderUI.ponderTicks % 100) * phase);
            entity.field_6819 = class_3532.method_15374((float)f) + 1.0f;
            if (length == 0.0) {
                entity.field_6819 = 0.0f;
            }
        }
    }

    public static class DancePose
    extends ParrotPose {
        @Override
        class_1453 create(PonderWorld world) {
            class_1453 entity = super.create(world);
            entity.method_6006(class_2338.field_10980, true);
            return entity;
        }

        @Override
        void tick(PonderScene scene, class_1453 entity, class_243 location) {
            entity.field_5982 = entity.method_36454();
            entity.method_36456(entity.method_36454() - 2.0f);
        }
    }
}

