/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class PonderTag
implements ScreenElement {
    public static final PonderTag KINETIC_RELAYS = PonderTag.create("kinetic_relays").item((class_1935)AllBlocks.COGWHEEL.get(), true, false).defaultLang("Kinetic Blocks", "Components which help relaying Rotational Force elsewhere").addToIndex();
    public static final PonderTag KINETIC_SOURCES = PonderTag.create("kinetic_sources").item((class_1935)AllBlocks.WATER_WHEEL.get(), true, false).defaultLang("Kinetic Sources", "Components which generate Rotational Force").addToIndex();
    public static final PonderTag KINETIC_APPLIANCES = PonderTag.create("kinetic_appliances").item((class_1935)AllBlocks.MECHANICAL_PRESS.get(), true, false).defaultLang("Kinetic Appliances", "Components which make use of Rotational Force").addToIndex();
    public static final PonderTag FLUIDS = PonderTag.create("fluids").item((class_1935)AllBlocks.FLUID_PIPE.get(), true, false).defaultLang("Fluid Manipulators", "Components which help relaying and making use of Fluids").addToIndex();
    public static final PonderTag LOGISTICS = PonderTag.create("logistics").item((class_1935)class_2246.field_10034, true, false).defaultLang("Item Transportation", "Components which help moving items around").addToIndex();
    public static final PonderTag REDSTONE = PonderTag.create("redstone").item((class_1935)class_1802.field_8725, true, false).defaultLang("Logic Components", "Components which help with redstone engineering").addToIndex();
    public static final PonderTag DECORATION = PonderTag.create("decoration").item((class_1935)class_1802.field_17527, true, false).defaultLang("Aesthetics", "Components used mostly for decorative purposes");
    public static final PonderTag CREATIVE = PonderTag.create("creative").item((class_1935)AllBlocks.CREATIVE_CRATE.get(), true, false).defaultLang("Creative Mode", "Components not usually available for Survival Mode").addToIndex();
    public static final PonderTag MOVEMENT_ANCHOR = PonderTag.create("movement_anchor").item((class_1935)AllBlocks.MECHANICAL_PISTON.get(), true, false).defaultLang("Movement Anchors", "Components which allow the creation of moving contraptions, animating an attached structure in a variety of ways").addToIndex();
    public static final PonderTag CONTRAPTION_ACTOR = PonderTag.create("contraption_actor").item((class_1935)AllBlocks.MECHANICAL_HARVESTER.get(), true, false).defaultLang("Contraption Actors", "Components which expose special behaviour when attached to a moving contraption").addToIndex();
    public static final PonderTag CONTRAPTION_ASSEMBLY = PonderTag.create("contraption_assembly").item((class_1935)AllItems.SUPER_GLUE.get(), true, false).defaultLang("Block Attachment Utility", "Tools and Components used to assemble structures moved as an animated Contraption").addToIndex();
    public static final PonderTag SAILS = PonderTag.create("windmill_sails").item((class_1935)AllBlocks.WINDMILL_BEARING.get()).defaultLang("Sails for Windmill Bearings", "Blocks that count towards the strength of a Windmill Contraption when assembled. Each of these have equal efficiency in doing so.");
    public static final PonderTag ARM_TARGETS = PonderTag.create("arm_targets").item((class_1935)AllBlocks.MECHANICAL_ARM.get()).defaultLang("Targets for Mechanical Arms", "Components which can be selected as inputs or outputs to the Mechanical Arm");
    public static final PonderTag TRAIN_RELATED = PonderTag.create("train_related").item((class_1935)AllBlocks.TRACK.get()).defaultLang("Railway Equipment", "Components used in the construction or management of Train Contraptions").addToIndex();
    public static final PonderTag DISPLAY_SOURCES = PonderTag.create("display_sources").item((class_1935)AllBlocks.DISPLAY_LINK.get(), true, false).item((class_1935)AllBlocks.DISPLAY_LINK.get(), false, true).defaultLang("Sources for Display Links", "Components or Blocks which offer some data that can be read with a Display Link");
    public static final PonderTag DISPLAY_TARGETS = PonderTag.create("display_targets").item((class_1935)AllBlocks.DISPLAY_LINK.get(), true, false).item((class_1935)AllBlocks.DISPLAY_LINK.get(), false, true).defaultLang("Targets for Display Links", "Components or Blocks which can process and display the data received from a Display Link");
    private final class_2960 id;
    private class_2960 icon;
    private class_1799 itemIcon = class_1799.field_8037;
    private class_1799 mainItem = class_1799.field_8037;

    public PonderTag(class_2960 id) {
        this.id = id;
    }

    public class_2960 getId() {
        return this.id;
    }

    public class_1799 getMainItem() {
        return this.mainItem;
    }

    public String getTitle() {
        return PonderLocalization.getTag(this.id);
    }

    public String getDescription() {
        return PonderLocalization.getTagDescription(this.id);
    }

    public PonderTag defaultLang(String title, String description) {
        PonderLocalization.registerTag(this.id, title, description);
        return this;
    }

    public PonderTag addToIndex() {
        PonderRegistry.TAGS.listTag(this);
        return this;
    }

    public PonderTag icon(class_2960 location) {
        this.icon = new class_2960(location.method_12836(), "textures/ponder/tag/" + location.method_12832() + ".png");
        return this;
    }

    public PonderTag icon(String location) {
        this.icon = new class_2960(this.id.method_12836(), "textures/ponder/tag/" + location + ".png");
        return this;
    }

    public PonderTag idAsIcon() {
        return this.icon(this.id);
    }

    public PonderTag item(class_1935 item, boolean useAsIcon, boolean useAsMainItem) {
        if (useAsIcon) {
            this.itemIcon = new class_1799(item);
        }
        if (useAsMainItem) {
            this.mainItem = new class_1799(item);
        }
        return this;
    }

    public PonderTag item(class_1935 item) {
        return this.item(item, true, true);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_4587 ms, int x, int y) {
        ms.method_22903();
        ms.method_22904((double)x, (double)y, 0.0);
        if (this.icon != null) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.icon);
            ms.method_22905(0.25f, 0.25f, 1.0f);
            class_332.method_25291((class_4587)ms, (int)0, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
        } else if (!this.itemIcon.method_7960()) {
            ms.method_22904(-4.0, -4.0, 0.0);
            ms.method_22905(1.5f, 1.5f, 1.5f);
            GuiGameElement.of(this.itemIcon).render(ms);
        }
        ms.method_22909();
    }

    private static PonderTag create(String id) {
        return new PonderTag(Create.asResource(id));
    }

    public static void register() {
    }

    public static class Highlight {
        public static final PonderTag ALL = PonderTag.create("_all");
    }
}

