/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import me.alphamode.forgetags.Tags;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2474;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;

public class TagGen {
    public static <T extends class_2248, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOrPickaxe() {
        return b -> b.tag(new class_6862[]{class_3481.field_33713}).tag(new class_6862[]{class_3481.field_33715});
    }

    public static <T extends class_2248, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOnly() {
        return b -> b.tag(new class_6862[]{class_3481.field_33713});
    }

    public static <T extends class_2248, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> pickaxeOnly() {
        return b -> b.tag(new class_6862[]{class_3481.field_33715});
    }

    public static <T extends class_2248, P> NonNullFunction<BlockBuilder<T, P>, ItemBuilder<class_1747, BlockBuilder<T, P>>> tagBlockAndItem(String ... path) {
        return b -> {
            for (String p : path) {
                b.tag(new class_6862[]{AllTags.forgeBlockTag(p)});
            }
            ItemBuilder item = b.item();
            for (String p : path) {
                item.tag(new class_6862[]{AllTags.forgeItemTag(p)});
            }
            return item;
        };
    }

    public static <T extends class_2474.class_5124<?>> T addOptional(T appender, Mods mod, String id) {
        appender.method_35922(mod.asResource(id));
        return appender;
    }

    public static <T extends class_2474.class_5124<?>> T addOptional(T appender, Mods mod, String ... ids) {
        for (String id : ids) {
            appender.method_35922(mod.asResource(id));
        }
        return appender;
    }

    public static void datagen() {
        Create.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, TagGen::genBlockTags);
        Create.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, TagGen::genItemTags);
        Create.REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, TagGen::genFluidTags);
    }

    private static void genBlockTags(RegistrateTagsProvider<class_2248> prov) {
        prov.tag(AllTags.AllBlockTags.BRITTLE.tag).add((Object[])new class_2248[]{class_2246.field_16332, class_2246.field_10302, class_2246.field_10495}).forceAddTag(class_3481.field_16443).forceAddTag(class_3481.field_15495);
        prov.tag(AllTags.AllBlockTags.MOVABLE_EMPTY_COLLIDER.tag).add((Object[])new class_2248[]{class_2246.field_10343, class_2246.field_27879}).forceAddTag(class_3481.field_25147);
        prov.tag(AllTags.AllBlockTags.FAN_TRANSPARENT.tag).add((Object)class_2246.field_10576).add((Object)class_2246.field_37546).forceAddTag(class_3481.field_23799).forceAddTag(class_3481.field_16584).forceAddTag(class_3481.field_15503);
        prov.tag(AllTags.AllBlockTags.ORE_OVERRIDE_STONE.tag).forceAddTag(class_3481.field_28992);
        prov.tag(AllTags.AllBlockTags.PASSIVE_BOILER_HEATERS.tag).add((Object[])new class_2248[]{class_2246.field_10092, class_2246.field_10164}).forceAddTag(class_3481.field_23799).forceAddTag(class_3481.field_21952);
        prov.tag(AllTags.AllBlockTags.SAFE_NBT.tag).forceAddTag(class_3481.field_15501).forceAddTag(class_3481.field_15500);
        prov.tag(AllTags.AllBlockTags.TREE_ATTACHMENTS.tag).add((Object[])new class_2248[]{class_2246.field_20421, class_2246.field_10302, class_2246.field_37544, class_2246.field_28680, class_2246.field_22122, class_2246.field_10597});
        prov.tag(AllTags.AllBlockTags.WINDMILL_SAILS.tag).forceAddTag(class_3481.field_15481);
        prov.tag(AllTags.AllBlockTags.WRENCH_PICKUP.tag).add((Object[])new class_2248[]{class_2246.field_10091, class_2246.field_10523, class_2246.field_10450, class_2246.field_10363, class_2246.field_10377, class_2246.field_10282, class_2246.field_10301, class_2246.field_10560, class_2246.field_10615, class_2246.field_10589, class_2246.field_10348, class_2246.field_10429, class_2246.field_22422, class_2246.field_10312}).forceAddTag(class_3481.field_15493).forceAddTag(class_3481.field_24076).forceAddTag(class_3481.field_15463);
        TagGen.addOptional(prov.tag(AllTags.AllBlockTags.NON_MOVABLE.tag), Mods.IE, "connector_lv", "connector_lv_relay", "connector_mv", "connector_mv_relay", "connector_hv", "connector_hv_relay", "connector_bundled", "connector_structural", "connector_redstone", "connector_probe", "breaker_switch");
        TagGen.addOptional(prov.tag(AllTags.AllBlockTags.NON_MOVABLE.tag), Mods.BC, "bits_block");
        for (AllTags.AllBlockTags tag : AllTags.AllBlockTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.method_27169(tag.tag);
        }
    }

    private static void genItemTags(RegistrateTagsProvider<class_1792> prov) {
        prov.tag(AllTags.AllItemTags.SLEEPERS.tag).add((Object[])new class_1792[]{class_1802.field_8595, class_1802.field_8291, class_1802.field_8742});
        prov.tag(AllTags.AllItemTags.STRIPPED_LOGS.tag).forceAddTag(AllTags.AllItemTags.VANILLA_STRIPPED_LOGS.tag).forceAddTag(AllTags.AllItemTags.MODDED_STRIPPED_LOGS.tag);
        prov.tag(AllTags.AllItemTags.STRIPPED_WOOD.tag).forceAddTag(AllTags.AllItemTags.VANILLA_STRIPPED_WOOD.tag).forceAddTag(AllTags.AllItemTags.MODDED_STRIPPED_WOOD.tag);
        prov.tag(AllTags.AllItemTags.DEPLOYABLE_DRINK.tag).add((Object[])new class_1792[]{class_1802.field_8103, class_1802.field_8574});
        prov.tag(AllTags.AllItemTags.UPRIGHT_ON_BELT.tag).add((Object[])new class_1792[]{class_1802.field_8469, class_1802.field_8574, class_1802.field_8436, class_1802.field_8150, class_1802.field_20417, class_1802.field_17534});
        prov.tag(AllTags.AllItemTags.VANILLA_STRIPPED_LOGS.tag).add((Object[])new class_1792[]{class_1802.field_8072, class_1802.field_8767, class_1802.field_21983, class_1802.field_8808, class_1802.field_8334, class_1802.field_37515, class_1802.field_8415, class_1802.field_8624, class_1802.field_21984});
        prov.tag(AllTags.AllItemTags.VANILLA_STRIPPED_WOOD.tag).add((Object[])new class_1792[]{class_1802.field_8284, class_1802.field_8472, class_1802.field_22487, class_1802.field_8219, class_1802.field_8785, class_1802.field_37509, class_1802.field_8248, class_1802.field_8362, class_1802.field_22488});
        prov.tag(class_3489.field_22277).forceAddTag(AllTags.AllItemTags.CREATE_INGOTS.tag);
        prov.tag(Tags.Items.INGOTS).forceAddTag(AllTags.AllItemTags.CREATE_INGOTS.tag);
        TagGen.genStrippedWood(prov);
        for (AllTags.AllItemTags tag : AllTags.AllItemTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.method_27169(tag.tag);
        }
    }

    private static void genStrippedWood(RegistrateTagsProvider<class_1792> prov) {
        FabricTagProvider.FabricTagBuilder logAppender = prov.tag(AllTags.AllItemTags.MODDED_STRIPPED_LOGS.tag);
        FabricTagProvider.FabricTagBuilder woodAppender = prov.tag(AllTags.AllItemTags.MODDED_STRIPPED_WOOD.tag);
        StrippedWoodHelper helper = new StrippedWoodHelper((class_2474.class_5124<class_1792>)logAppender, (class_2474.class_5124<class_1792>)woodAppender);
        helper.add(Mods.ARS_N, "blue_archwood", "purple_archwood", "green_archwood", "red_archwood");
        helper.add(Mods.BTN, "livingwood", "dreamwood");
        helper.add(Mods.FA, "cherrywood", "mysterywood");
        helper.add(Mods.HEX, "akashic");
        helper.add(Mods.ID, "menril");
        helper.add(Mods.BYG, "aspen", "baobab", "enchanted", "cherry", "cika", "cypress", "ebony", "ether", "fir", "green_enchanted", "holly", "jacaranda", "lament", "mahogany", "mangrove", "maple", "nightshade", "palm", "palo_verde", "pine", "rainbow_eucalyptus", "redwood", "skyris", "willow", "witch_hazel", "zelkova");
        helper.add(Mods.SG, "netherwood");
        helper.add(Mods.TF, "twilight_oak", "canopy", "mangrove", "dark", "time", "transformation", "mining", "sorting");
        helper.add(Mods.TIC, "greenheart", "skyroot", "bloodshroom");
        helper.add(Mods.AP, "twisted");
        helper.add(Mods.Q, "azalea", "blossom");
        helper.add(Mods.ECO, "coconut", "walnut", "azalea");
        helper.add(Mods.BOP, "fir", "redwood", "cherry", "mahogany", "jacaranda", "palm", "willow", "dead", "magic", "umbran", "hellbark");
        helper.add(Mods.BSK, "bluebright", "starlit", "frostbright", "lunar", "dusk", "maple", "cherry");
        TagGen.addOptional(logAppender, Mods.BYG, "stripped_bulbis_stem");
        TagGen.addOptional(woodAppender, Mods.BYG, "stripped_bulbis_wood");
    }

    private static void genFluidTags(RegistrateTagsProvider<class_3611> prov) {
        prov.tag(AllTags.AllFluidTags.BOTTOMLESS_ALLOW.tag).add((Object[])new class_3611[]{class_3612.field_15910, class_3612.field_15908});
        prov.tag(AllTags.AllFluidTags.DIVING_FLUIDS.tag).forceAddTag(class_3486.field_15517);
        for (AllTags.AllFluidTags tag : AllTags.AllFluidTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.method_27169(tag.tag);
        }
    }

    private static class StrippedWoodHelper {
        protected final class_2474.class_5124<class_1792> logAppender;
        protected final class_2474.class_5124<class_1792> woodAppender;

        public StrippedWoodHelper(class_2474.class_5124<class_1792> logAppender, class_2474.class_5124<class_1792> woodAppender) {
            this.logAppender = logAppender;
            this.woodAppender = woodAppender;
        }

        public void add(Mods mod, String ... woodTypes) {
            for (String type : woodTypes) {
                String strippedPre = mod.strippedIsSuffix ? "" : "stripped_";
                String strippedPost = mod.strippedIsSuffix ? "_stripped" : "";
                TagGen.addOptional(this.logAppender, mod, strippedPre + type + "_log" + strippedPost);
                TagGen.addOptional(this.woodAppender, mod, strippedPre + type + (mod.omitWoodSuffix ? "" : "_wood") + strippedPost);
            }
        }
    }
}

