/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config.ui.entries;

import com.google.common.base.Predicates;
import com.simibubi.create.foundation.config.ui.ConfigAnnotations;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.config.ui.ConfigScreen;
import com.simibubi.create.foundation.config.ui.ConfigScreenList;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.DelegatedStencilElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.BoxWidget;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Pair;
import io.github.fabricators_of_create.porting_lib.mixin.client.accessor.AbstractSelectionList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_350;
import net.minecraft.class_4587;
import net.minecraftforge.common.ForgeConfigSpec;

public class ValueEntry<T>
extends ConfigScreenList.LabeledEntry {
    protected static final int resetWidth = 28;
    protected ForgeConfigSpec.ConfigValue<T> value;
    protected ForgeConfigSpec.ValueSpec spec;
    protected BoxWidget resetButton;
    protected boolean editable = true;

    public ValueEntry(String label, ForgeConfigSpec.ConfigValue<T> value, ForgeConfigSpec.ValueSpec spec) {
        super(label);
        this.value = value;
        this.spec = spec;
        this.path = String.join((CharSequence)".", value.getPath());
        this.resetButton = (BoxWidget)((AbstractSimiWidget)new BoxWidget(0, 0, 16, 16).showingElement(AllIcons.I_CONFIG_RESET.asStencil())).withCallback(() -> {
            this.setValue(spec.getDefault());
            this.onReset();
        });
        this.resetButton.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BoxWidget.gradientFactory.apply(this.resetButton)));
        this.listeners.add(this.resetButton);
        List path = value.getPath();
        this.labelTooltip.add(Components.literal(label).method_27692(class_124.field_1068));
        String comment = spec.getComment();
        if (comment == null || comment.isEmpty()) {
            return;
        }
        ArrayList<String> commentLines = new ArrayList<String>(Arrays.asList(comment.split("\n")));
        Pair<String, Map<String, String>> metadata = ConfigHelper.readMetadataFromComment(commentLines);
        if (metadata.getFirst() != null) {
            this.unit = metadata.getFirst();
        }
        if (metadata.getSecond() != null && !metadata.getSecond().isEmpty()) {
            this.annotations.putAll(metadata.getSecond());
        }
        this.labelTooltip.addAll(commentLines.stream().filter(Predicates.not(s -> s.startsWith("Range"))).filter(s -> !s.equals(".")).map(Components::literal).flatMap(stc -> TooltipHelper.cutTextComponent((class_2561)stc, class_124.field_1080, class_124.field_1080).stream()).collect(Collectors.toList()));
        if (this.annotations.containsKey(ConfigAnnotations.RequiresRelog.TRUE.getName())) {
            this.labelTooltip.addAll(TooltipHelper.cutTextComponent((class_2561)Components.literal("Changing this value will require a _relog_ to take full effect"), class_124.field_1080, class_124.field_1065));
        }
        if (this.annotations.containsKey(ConfigAnnotations.RequiresRestart.CLIENT.getName())) {
            this.labelTooltip.addAll(TooltipHelper.cutTextComponent((class_2561)Components.literal("Changing this value will require a _restart_ to take full effect"), class_124.field_1080, class_124.field_1061));
        }
        this.labelTooltip.add(Components.literal(ConfigScreen.modID + ":" + (String)path.get(path.size() - 1)).method_27692(class_124.field_1063));
    }

    public ValueEntry(String label) {
        super(label);
    }

    @Override
    public void setEditable(boolean b) {
        this.editable = b;
        this.resetButton.field_22763 = this.editable && !this.isCurrentValueDefault();
        this.resetButton.animateGradientFromState();
    }

    @Override
    public void tick() {
        super.tick();
        this.resetButton.tick();
    }

    @Override
    public void method_25343(class_4587 ms, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
        super.method_25343(ms, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
        this.resetButton.field_22760 = x + width - 28 + 6;
        this.resetButton.field_22761 = y + 10;
        this.resetButton.method_25394(ms, mouseX, mouseY, partialTicks);
    }

    @Override
    protected int getLabelWidth(int totalWidth) {
        return (int)((float)totalWidth * 0.4f) + 30;
    }

    public void setValue(@Nonnull T value) {
        ConfigHelper.setValue(this.path, this.value, value, this.annotations);
        this.onValueChange(value);
    }

    @Nonnull
    public T getValue() {
        return ConfigHelper.getValue(this.path, this.value);
    }

    protected boolean isCurrentValueDefault() {
        return this.spec.getDefault().equals(this.getValue());
    }

    public void onReset() {
        this.onValueChange(this.getValue());
    }

    public void onValueChange() {
        this.onValueChange(this.getValue());
    }

    public void onValueChange(T newValue) {
        this.resetButton.field_22763 = this.editable && !this.isCurrentValueDefault();
        this.resetButton.animateGradientFromState();
    }

    protected void bumpCog() {
        this.bumpCog(10.0f);
    }

    protected void bumpCog(float force) {
        class_350 list = ((AbstractSelectionList.EntryAccessor)this).port_lib$getList();
        if (list != null && list instanceof ConfigScreenList) {
            ((ConfigScreenList)list).bumpCog(force);
        }
    }
}

