/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;

public class CouplingCommand {
    public static final SimpleCommandExceptionType ONLY_MINECARTS_ALLOWED = new SimpleCommandExceptionType((Message)Components.literal("Only Minecarts can be coupled"));
    public static final SimpleCommandExceptionType SAME_DIMENSION = new SimpleCommandExceptionType((Message)Components.literal("Minecarts have to be in the same Dimension"));
    public static final DynamicCommandExceptionType TWO_CARTS = new DynamicCommandExceptionType(a -> Components.literal("Your selector targeted " + a + " entities. You can only couple 2 Minecarts at a time."));

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"coupling").requires(cs -> cs.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"cart1", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"cart2", (ArgumentType)class_2186.method_9309()).executes(ctx -> {
            class_1297 cart1 = class_2186.method_9313((CommandContext)ctx, (String)"cart1");
            if (!(cart1 instanceof class_1688)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            class_1297 cart2 = class_2186.method_9313((CommandContext)ctx, (String)"cart2");
            if (!(cart2 instanceof class_1688)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            if (!cart1.method_5770().equals(cart2.method_5770())) {
                throw SAME_DIMENSION.create();
            }
            class_1297 source = ((class_2168)ctx.getSource()).method_9228();
            CouplingHandler.tryToCoupleCarts(source instanceof class_1657 ? (class_1657)source : null, cart1.method_5770(), cart1.method_5628(), cart2.method_5628());
            return 1;
        })))).then(class_2170.method_9244((String)"carts", (ArgumentType)class_2186.method_9306()).executes(ctx -> {
            Collection entities = class_2186.method_9317((CommandContext)ctx, (String)"carts");
            if (entities.size() != 2) {
                throw TWO_CARTS.create((Object)entities.size());
            }
            ArrayList eList = Lists.newArrayList((Iterable)entities);
            class_1297 cart1 = (class_1297)eList.get(0);
            if (!(cart1 instanceof class_1688)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            class_1297 cart2 = (class_1297)eList.get(1);
            if (!(cart2 instanceof class_1688)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            if (!cart1.method_5770().equals(cart2.method_5770())) {
                throw SAME_DIMENSION.create();
            }
            class_1297 source = ((class_2168)ctx.getSource()).method_9228();
            CouplingHandler.tryToCoupleCarts(source instanceof class_1657 ? (class_1657)source : null, cart1.method_5770(), cart1.method_5628(), cart2.method_5628());
            return 1;
        })))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"cart1", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"cart2", (ArgumentType)class_2186.method_9309()).executes(ctx -> {
            class_1297 cart1 = class_2186.method_9313((CommandContext)ctx, (String)"cart1");
            if (!(cart1 instanceof class_1688)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            class_1297 cart2 = class_2186.method_9313((CommandContext)ctx, (String)"cart2");
            if (!(cart2 instanceof class_1688)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            LazyOptional cart1Capability = ((class_1688)cart1).lazyController();
            if (!cart1Capability.isPresent()) {
                ((class_2168)ctx.getSource()).method_9226((class_2561)Components.literal("Minecart has no Couplings Attached"), true);
                return 0;
            }
            MinecartController cart1Controller = (MinecartController)cart1Capability.orElse(null);
            int cart1Couplings = (cart1Controller.isConnectedToCoupling() ? 1 : 0) + (cart1Controller.isLeadingCoupling() ? 1 : 0);
            if (cart1Couplings == 0) {
                ((class_2168)ctx.getSource()).method_9226((class_2561)Components.literal("Minecart has no Couplings Attached"), true);
                return 0;
            }
            for (boolean bool : Iterate.trueAndFalse) {
                UUID coupledCart = cart1Controller.getCoupledCart(bool);
                if (coupledCart == null || coupledCart != cart2.method_5667()) continue;
                MinecartController cart2Controller = CapabilityMinecartController.getIfPresent(cart1.method_5770(), coupledCart);
                if (cart2Controller == null) {
                    return 0;
                }
                cart1Controller.removeConnection(bool);
                cart2Controller.removeConnection(!bool);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9226((class_2561)Components.literal("The specified Carts are not coupled"), true);
            return 0;
        }))))).then(class_2170.method_9247((String)"removeAll").then(class_2170.method_9244((String)"cart", (ArgumentType)class_2186.method_9309()).executes(ctx -> {
            class_1297 cart = class_2186.method_9313((CommandContext)ctx, (String)"cart");
            if (!(cart instanceof class_1688)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            LazyOptional capability = ((class_1688)cart).lazyController();
            if (!capability.isPresent()) {
                ((class_2168)ctx.getSource()).method_9226((class_2561)Components.literal("Minecart has no Couplings Attached"), true);
                return 0;
            }
            MinecartController controller = (MinecartController)capability.orElse(null);
            int couplings = (controller.isConnectedToCoupling() ? 1 : 0) + (controller.isLeadingCoupling() ? 1 : 0);
            if (couplings == 0) {
                ((class_2168)ctx.getSource()).method_9226((class_2561)Components.literal("Minecart has no Couplings Attached"), true);
                return 0;
            }
            controller.decouple();
            ((class_2168)ctx.getSource()).method_9226((class_2561)Components.literal("Removed " + couplings + " couplings from the Minecart"), true);
            return couplings;
        })));
    }
}

