/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.edgePoint.station;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.GraphLocation;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationBlock;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import com.simibubi.create.foundation.networking.TileEntityConfigurationPacket;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;

public class StationEditPacket
extends TileEntityConfigurationPacket<StationTileEntity> {
    boolean dropSchedule;
    boolean assemblyMode;
    Boolean tryAssemble;
    String name;

    public static StationEditPacket dropSchedule(class_2338 pos) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.dropSchedule = true;
        return packet;
    }

    public static StationEditPacket tryAssemble(class_2338 pos) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.tryAssemble = true;
        return packet;
    }

    public static StationEditPacket tryDisassemble(class_2338 pos) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.tryAssemble = false;
        return packet;
    }

    public static StationEditPacket configure(class_2338 pos, boolean assemble, String name) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.assemblyMode = assemble;
        packet.tryAssemble = null;
        packet.name = name;
        return packet;
    }

    public StationEditPacket(class_2540 buffer) {
        super(buffer);
    }

    public StationEditPacket(class_2338 pos) {
        super(pos);
    }

    @Override
    protected void writeSettings(class_2540 buffer) {
        buffer.writeBoolean(this.dropSchedule);
        if (this.dropSchedule) {
            return;
        }
        buffer.writeBoolean(this.tryAssemble != null);
        if (this.tryAssemble != null) {
            buffer.writeBoolean(this.tryAssemble.booleanValue());
            return;
        }
        buffer.writeBoolean(this.assemblyMode);
        buffer.method_10814(this.name);
    }

    @Override
    protected void readSettings(class_2540 buffer) {
        if (buffer.readBoolean()) {
            this.dropSchedule = true;
            return;
        }
        this.name = "";
        if (buffer.readBoolean()) {
            this.tryAssemble = buffer.readBoolean();
            return;
        }
        this.assemblyMode = buffer.readBoolean();
        this.name = buffer.method_10800(256);
    }

    @Override
    protected void applySettings(class_3222 player, StationTileEntity te) {
        class_1937 level = te.method_10997();
        class_2338 blockPos = te.method_11016();
        class_2680 blockState = level.method_8320(blockPos);
        if (this.dropSchedule) {
            this.scheduleDropRequested(player, te);
            return;
        }
        if (!this.name.isBlank()) {
            GlobalStation station = te.getStation();
            GraphLocation graphLocation = te.edgePoint.determineGraphLocation();
            if (station != null && graphLocation != null) {
                station.name = this.name;
                Create.RAILWAYS.sync.pointAdded(graphLocation.graph, station);
                Create.RAILWAYS.markTracksDirty();
            }
        }
        if (!(blockState.method_26204() instanceof StationBlock)) {
            return;
        }
        Boolean isAssemblyMode = (Boolean)blockState.method_11654((class_2769)StationBlock.ASSEMBLING);
        boolean assemblyComplete = false;
        if (this.tryAssemble != null) {
            if (!isAssemblyMode.booleanValue()) {
                return;
            }
            if (this.tryAssemble.booleanValue()) {
                te.assemble(player.method_5667());
                assemblyComplete = te.getStation() != null && te.getStation().getPresentTrain() != null;
            } else if (this.disassembleAndEnterMode(player, te)) {
                te.refreshAssemblyInfo();
            }
            if (!assemblyComplete) {
                return;
            }
        }
        if (isAssemblyMode == this.assemblyMode) {
            return;
        }
        class_2680 newState = (class_2680)blockState.method_28493((class_2769)StationBlock.ASSEMBLING);
        Boolean nowAssembling = (Boolean)newState.method_11654((class_2769)StationBlock.ASSEMBLING);
        if (nowAssembling.booleanValue()) {
            if (!this.disassembleAndEnterMode(player, te)) {
                return;
            }
        } else {
            te.cancelAssembly();
        }
        level.method_8652(blockPos, newState, 3);
        te.refreshBlockState();
        if (nowAssembling.booleanValue()) {
            te.refreshAssemblyInfo();
        }
        GlobalStation station = te.getStation();
        GraphLocation graphLocation = te.edgePoint.determineGraphLocation();
        if (station != null && graphLocation != null) {
            station.assembling = nowAssembling;
            Create.RAILWAYS.sync.pointAdded(graphLocation.graph, station);
            Create.RAILWAYS.markTracksDirty();
            if (nowAssembling.booleanValue()) {
                for (Train train : Create.RAILWAYS.sided((class_1936)level).trains.values()) {
                    if (train.navigation.destination != station) continue;
                    GlobalStation preferredDestination = train.runtime.startCurrentInstruction();
                    if (preferredDestination != null) {
                        train.navigation.startNavigation(preferredDestination, Double.MAX_VALUE, false);
                        continue;
                    }
                    train.navigation.startNavigation(station, Double.MAX_VALUE, false);
                }
            }
        }
    }

    private void scheduleDropRequested(class_3222 sender, StationTileEntity te) {
        GlobalStation station = te.getStation();
        if (station == null) {
            return;
        }
        Train train = station.getPresentTrain();
        if (train == null) {
            return;
        }
        class_1799 schedule = train.runtime.returnSchedule();
        this.dropSchedule(sender, te, schedule);
    }

    private boolean disassembleAndEnterMode(class_3222 sender, StationTileEntity te) {
        GlobalStation station = te.getStation();
        if (station != null) {
            class_1799 schedule;
            Train train = station.getPresentTrain();
            class_2338 trackPosition = te.edgePoint.getGlobalPosition();
            class_1799 class_17992 = schedule = train == null ? class_1799.field_8037 : train.runtime.returnSchedule();
            if (train != null && !train.disassemble(te.getAssemblyDirection(), trackPosition.method_10084())) {
                return false;
            }
            this.dropSchedule(sender, te, schedule);
        }
        return te.tryEnterAssemblyMode();
    }

    private void dropSchedule(class_3222 sender, StationTileEntity te, class_1799 schedule) {
        if (schedule.method_7960()) {
            return;
        }
        if (sender.method_6047().method_7960()) {
            sender.method_31548().method_7398(schedule);
            return;
        }
        class_243 v = VecHelper.getCenterOf((class_2382)te.method_11016());
        class_1542 itemEntity = new class_1542(te.method_10997(), v.field_1352, v.field_1351, v.field_1350, schedule);
        itemEntity.method_18799(class_243.field_1353);
        te.method_10997().method_8649((class_1297)itemEntity);
    }

    @Override
    protected void applySettings(StationTileEntity te) {
    }
}

