/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.edgePoint.station;

import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SingleTileEdgePoint;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationBlock;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class GlobalStation
extends SingleTileEdgePoint {
    public String name = "Track Station";
    public WeakReference<Train> nearestTrain = new WeakReference<Object>(null);
    public boolean assembling;

    @Override
    public void tileAdded(class_2586 tile, boolean front) {
        super.tileAdded(tile, front);
        class_2680 state = tile.method_11010();
        this.assembling = state != null && state.method_28498((class_2769)StationBlock.ASSEMBLING) && (Boolean)state.method_11654((class_2769)StationBlock.ASSEMBLING) != false;
    }

    @Override
    public void read(class_2487 nbt, boolean migration, DimensionPalette dimensions) {
        super.read(nbt, migration, dimensions);
        this.name = nbt.method_10558("Name");
        this.assembling = nbt.method_10577("Assembling");
        this.nearestTrain = new WeakReference<Object>(null);
    }

    @Override
    public void read(class_2540 buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
        this.name = buffer.method_19772();
        this.assembling = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.tilePos = buffer.method_10811();
        }
    }

    @Override
    public void write(class_2487 nbt, DimensionPalette dimensions) {
        super.write(nbt, dimensions);
        nbt.method_10582("Name", this.name);
        nbt.method_10556("Assembling", this.assembling);
    }

    @Override
    public void write(class_2540 buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
        buffer.method_10814(this.name);
        buffer.writeBoolean(this.assembling);
        buffer.writeBoolean(this.tilePos != null);
        if (this.tilePos != null) {
            buffer.method_10807(this.tilePos);
        }
    }

    public boolean canApproachFrom(TrackNode side) {
        return this.isPrimary(side) && !this.assembling;
    }

    @Override
    public boolean canNavigateVia(TrackNode side) {
        return super.canNavigateVia(side) && !this.assembling;
    }

    public void reserveFor(Train train) {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null || nearestTrain.navigation.distanceToDestination > train.navigation.distanceToDestination) {
            this.nearestTrain = new WeakReference<Train>(train);
        }
    }

    public void cancelReservation(Train train) {
        if (this.nearestTrain.get() == train) {
            this.nearestTrain = new WeakReference<Object>(null);
        }
    }

    public void trainDeparted(Train train) {
        this.cancelReservation(train);
    }

    @Nullable
    public Train getPresentTrain() {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null || nearestTrain.getCurrentStation() != this) {
            return null;
        }
        return nearestTrain;
    }

    @Nullable
    public Train getImminentTrain() {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null) {
            return nearestTrain;
        }
        if (nearestTrain.getCurrentStation() == this) {
            return nearestTrain;
        }
        if (!nearestTrain.navigation.isActive()) {
            return null;
        }
        if (nearestTrain.navigation.distanceToDestination > 30.0) {
            return null;
        }
        return nearestTrain;
    }

    @Nullable
    public Train getNearestTrain() {
        return (Train)this.nearestTrain.get();
    }
}

