/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionRelocationPacket;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.entity.TrainRelocator;
import com.simibubi.create.content.logistics.trains.track.BezierTrackPointLocation;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.UUID;
import java.util.function.Supplier;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class TrainRelocationPacket
extends SimplePacketBase {
    UUID trainId;
    class_2338 pos;
    class_243 lookAngle;
    int entityId;
    private boolean direction;
    private BezierTrackPointLocation hoveredBezier;

    public TrainRelocationPacket(class_2540 buffer) {
        this.trainId = buffer.method_10790();
        this.pos = buffer.method_10811();
        this.lookAngle = VecHelper.read(buffer);
        this.entityId = buffer.readInt();
        this.direction = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.hoveredBezier = new BezierTrackPointLocation(buffer.method_10811(), buffer.readInt());
        }
    }

    public TrainRelocationPacket(UUID trainId, class_2338 pos, BezierTrackPointLocation hoveredBezier, boolean direction, class_243 lookAngle, int entityId) {
        this.trainId = trainId;
        this.pos = pos;
        this.hoveredBezier = hoveredBezier;
        this.direction = direction;
        this.lookAngle = lookAngle;
        this.entityId = entityId;
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.trainId);
        buffer.method_10807(this.pos);
        VecHelper.write(this.lookAngle, buffer);
        buffer.writeInt(this.entityId);
        buffer.writeBoolean(this.direction);
        buffer.writeBoolean(this.hoveredBezier != null);
        if (this.hoveredBezier != null) {
            buffer.method_10807(this.hoveredBezier.curveTarget());
            buffer.writeInt(this.hoveredBezier.segment());
        }
    }

    @Override
    public void handle(Supplier<SimplePacketBase.Context> context) {
        SimplePacketBase.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            class_3222 sender = ctx.getSender();
            Train train = Create.RAILWAYS.trains.get(this.trainId);
            class_1297 entity = sender.field_6002.method_8469(this.entityId);
            String messagePrefix = sender.method_5477().getString() + " could not relocate Train ";
            if (train == null || !(entity instanceof CarriageContraptionEntity)) {
                Create.LOGGER.warn(messagePrefix + train.id.toString().substring(0, 5) + ": not present on server");
                return;
            }
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            if (!train.id.equals(cce.trainId)) {
                return;
            }
            int verifyDistance = (Integer)AllConfigs.SERVER.trains.maxTrackPlacementLength.get() * 2;
            if (!sender.method_19538().method_24802((class_2374)class_243.method_24953((class_2382)this.pos), (double)verifyDistance)) {
                Create.LOGGER.warn(messagePrefix + train.name.getString() + ": player too far from clicked pos");
                return;
            }
            if (!sender.method_19538().method_24802((class_2374)cce.method_19538(), (double)verifyDistance + cce.method_5829().method_17939() / 2.0)) {
                Create.LOGGER.warn(messagePrefix + train.name.getString() + ": player too far from carriage entity");
                return;
            }
            if (TrainRelocator.relocate(train, sender.field_6002, this.pos, this.hoveredBezier, this.direction, this.lookAngle, false)) {
                sender.method_7353((class_2561)Lang.translateDirect("train.relocate.success", new Object[0]).method_27692(class_124.field_1060), true);
                train.carriages.forEach(c -> c.forEachPresentEntity(e -> {
                    e.nonDamageTicks = 10;
                    AllPackets.channel.sendToClientsTracking((S2CPacket)new ContraptionRelocationPacket(e.method_5628()), (class_1297)e);
                }));
                return;
            }
            Create.LOGGER.warn(messagePrefix + train.name.getString() + ": relocation failed server-side");
        });
        ctx.setPacketHandled(true);
    }
}

