/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.entity.TravellingPoint;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgeData;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgePointType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalBlock;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalBoundary;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalEdgeGroup;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.TrackEdgePoint;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public class Navigation {
    public Train train;
    public GlobalStation destination;
    public double distanceToDestination;
    public double distanceStartedAt;
    public boolean destinationBehindTrain;
    public boolean announceArrival;
    List<Couple<TrackNode>> currentPath;
    private TravellingPoint signalScout;
    public Pair<UUID, Boolean> waitingForSignal;
    private Map<UUID, Pair<SignalBoundary, Boolean>> waitingForChainedGroups;
    public double distanceToSignal;
    public int ticksWaitingForSignal;

    public Navigation(Train train) {
        this.train = train;
        this.currentPath = new ArrayList<Couple<TrackNode>>();
        this.signalScout = new TravellingPoint();
        this.waitingForChainedGroups = new HashMap<UUID, Pair<SignalBoundary, Boolean>>();
    }

    public void tick(class_1937 level) {
        double targetSpeed;
        double target;
        if (this.destination == null) {
            return;
        }
        if (!this.train.runtime.paused) {
            boolean frontDriver = this.train.hasForwardConductor();
            boolean backDriver = this.train.hasBackwardConductor();
            if (this.destinationBehindTrain && !backDriver) {
                if (frontDriver) {
                    this.train.status.missingCorrectConductor();
                } else {
                    this.train.status.missingConductor();
                }
                this.cancelNavigation();
                return;
            }
            if (!this.destinationBehindTrain && !frontDriver) {
                this.train.status.missingConductor();
                this.cancelNavigation();
                return;
            }
            this.train.status.foundConductor();
        }
        this.destination.reserveFor(this.train);
        double acceleration = this.train.acceleration();
        double brakingDistance = this.train.speed * this.train.speed / (2.0 * acceleration);
        double speedMod = this.destinationBehindTrain ? -1.0 : 1.0;
        double preDepartureLookAhead = this.train.getCurrentStation() != null ? 4.5 : 0.0;
        double distanceToNextCurve = -1.0;
        if (this.train.graph != null) {
            TravellingPoint leadingPoint;
            if (this.waitingForSignal != null && this.currentSignalResolved()) {
                UUID signalId = this.waitingForSignal.getFirst();
                SignalBoundary signal = this.train.graph.getPoint(EdgePointType.SIGNAL, signalId);
                if (signal != null && signal.types.get(this.waitingForSignal.getSecond()) == SignalBlock.SignalType.CROSS_SIGNAL) {
                    this.waitingForChainedGroups.clear();
                }
                this.waitingForSignal = null;
            }
            TravellingPoint travellingPoint = leadingPoint = !this.destinationBehindTrain ? this.train.carriages.get(0).getLeadingPoint() : this.train.carriages.get(this.train.carriages.size() - 1).getTrailingPoint();
            if (this.waitingForSignal == null) {
                this.distanceToSignal = Double.MAX_VALUE;
                this.ticksWaitingForSignal = 0;
            }
            if (this.distanceToSignal > 0.0625) {
                MutableDouble curveDistanceTracker = new MutableDouble(-1.0);
                this.signalScout.node1 = leadingPoint.node1;
                this.signalScout.node2 = leadingPoint.node2;
                this.signalScout.edge = leadingPoint.edge;
                this.signalScout.position = leadingPoint.position;
                double brakingDistanceNoFlicker = brakingDistance + 3.0 - brakingDistance % 3.0;
                double scanDistance = class_3532.method_15350((double)brakingDistanceNoFlicker, (double)preDepartureLookAhead, (double)this.distanceToDestination);
                MutableDouble crossSignalDistanceTracker = new MutableDouble(-1.0);
                MutableObject trackingCrossSignal = new MutableObject(null);
                this.waitingForChainedGroups.clear();
                this.signalScout.travel(this.train.graph, (this.distanceToDestination + 50.0) * speedMod, this.controlSignalScout(), (distance, couple) -> {
                    boolean occupied;
                    boolean crossSignalTracked;
                    boolean bl = crossSignalTracked = trackingCrossSignal.getValue() != null;
                    if (!crossSignalTracked && distance > scanDistance) {
                        return true;
                    }
                    Couple nodes = (Couple)couple.getSecond();
                    TrackEdgePoint boundary = (TrackEdgePoint)couple.getFirst();
                    if (boundary == this.destination && ((GlobalStation)boundary).canApproachFrom((TrackNode)nodes.getSecond())) {
                        return true;
                    }
                    if (!(boundary instanceof SignalBoundary)) {
                        return false;
                    }
                    SignalBoundary signal = (SignalBoundary)boundary;
                    UUID entering = signal.getGroup((TrackNode)nodes.getSecond());
                    SignalEdgeGroup signalEdgeGroup = Create.RAILWAYS.signalEdgeGroups.get(entering);
                    if (signalEdgeGroup == null) {
                        return false;
                    }
                    boolean primary = entering.equals(signal.groups.getFirst());
                    boolean crossSignal = signal.types.get(primary) == SignalBlock.SignalType.CROSS_SIGNAL;
                    boolean bl2 = occupied = !this.train.manualTick && (signal.isForcedRed((TrackNode)nodes.getSecond()) || signalEdgeGroup.isOccupiedUnless(this.train));
                    if (!crossSignalTracked) {
                        if (crossSignal) {
                            trackingCrossSignal.setValue(Pair.of(boundary.id, primary));
                            crossSignalDistanceTracker.setValue((Number)distance);
                            this.waitingForChainedGroups.put(entering, Pair.of(signal, primary));
                        }
                        if (occupied) {
                            this.waitingForSignal = Pair.of(boundary.id, primary);
                            this.distanceToSignal = distance;
                            if (!crossSignal) {
                                return true;
                            }
                        }
                        if (!occupied && !crossSignal && distance < this.distanceToSignal + 0.25 && distance < brakingDistanceNoFlicker) {
                            signalEdgeGroup.reserved = signal;
                        }
                        return false;
                    }
                    if (crossSignalTracked) {
                        this.waitingForChainedGroups.put(entering, Pair.of(signal, primary));
                        if (occupied) {
                            this.waitingForSignal = (Pair)trackingCrossSignal.getValue();
                            this.distanceToSignal = crossSignalDistanceTracker.doubleValue();
                            if (!crossSignal) {
                                return true;
                            }
                        }
                        if (!crossSignal) {
                            if (distance < this.distanceToSignal + 0.25) {
                                trackingCrossSignal.setValue(null);
                                this.reserveChain();
                                return false;
                            }
                            return true;
                        }
                    }
                    return false;
                }, (distance, edge) -> {
                    float current = curveDistanceTracker.floatValue();
                    if (current == -1.0f || distance < (double)current) {
                        curveDistanceTracker.setValue((Number)distance);
                    }
                });
                if (trackingCrossSignal.getValue() != null && this.waitingForSignal == null) {
                    this.reserveChain();
                }
                distanceToNextCurve = curveDistanceTracker.floatValue();
            } else {
                ++this.ticksWaitingForSignal;
            }
        }
        double targetDistance = this.waitingForSignal != null ? this.distanceToSignal : this.distanceToDestination;
        if ((targetDistance += 0.25) > 0.03125 && this.train.getCurrentStation() != null) {
            if (this.waitingForSignal != null && this.distanceToSignal < preDepartureLookAhead) {
                ++this.ticksWaitingForSignal;
                return;
            }
            this.train.leaveStation();
        }
        this.train.currentlyBackwards = this.destinationBehindTrain;
        if (targetDistance < -10.0) {
            this.cancelNavigation();
            return;
        }
        if (targetDistance - Math.abs(this.train.speed) < 0.03125) {
            this.train.speed = Math.max(targetDistance, 0.03125) * speedMod;
            return;
        }
        this.train.burnFuel();
        double topSpeed = this.train.maxSpeed();
        if (targetDistance < 10.0 && (target = topSpeed * (targetDistance / 10.0)) < Math.abs(this.train.speed)) {
            this.train.speed += (target - Math.abs(this.train.speed)) * 0.5 * speedMod;
            return;
        }
        double turnTopSpeed = Math.min(topSpeed *= this.train.throttle, (double)this.train.maxTurnSpeed());
        double d = targetSpeed = targetDistance > brakingDistance ? topSpeed * speedMod : 0.0;
        if (distanceToNextCurve != -1.0) {
            double targetTurnSpeed;
            double slowingDistance = brakingDistance - turnTopSpeed * turnTopSpeed / (2.0 * acceleration);
            double d2 = targetTurnSpeed = distanceToNextCurve > slowingDistance ? topSpeed * speedMod : turnTopSpeed * speedMod;
            if (Math.abs(targetTurnSpeed) < Math.abs(targetSpeed)) {
                targetSpeed = targetTurnSpeed;
            }
        }
        this.train.targetSpeed = targetSpeed;
        this.train.approachTargetSpeed(1.0f);
    }

    private void reserveChain() {
        this.train.reservedSignalBlocks.addAll(this.waitingForChainedGroups.keySet());
        this.waitingForChainedGroups.forEach((groupId, boundary) -> {
            SignalEdgeGroup signalEdgeGroup = Create.RAILWAYS.signalEdgeGroups.get(groupId);
            if (signalEdgeGroup != null) {
                signalEdgeGroup.reserved = (SignalBoundary)boundary.getFirst();
            }
        });
        this.waitingForChainedGroups.clear();
    }

    private boolean currentSignalResolved() {
        if (this.train.manualTick) {
            return true;
        }
        if (this.distanceToDestination < 0.5) {
            return true;
        }
        SignalBoundary signal = this.train.graph.getPoint(EdgePointType.SIGNAL, this.waitingForSignal.getFirst());
        if (signal == null) {
            return true;
        }
        if (signal.types.get(this.waitingForSignal.getSecond()) == SignalBlock.SignalType.CROSS_SIGNAL) {
            for (Map.Entry<UUID, Pair<SignalBoundary, Boolean>> entry : this.waitingForChainedGroups.entrySet()) {
                Pair<SignalBoundary, Boolean> boundary = entry.getValue();
                SignalEdgeGroup signalEdgeGroup = Create.RAILWAYS.signalEdgeGroups.get(entry.getKey());
                if (signalEdgeGroup == null) {
                    this.waitingForSignal.setFirst(null);
                    return true;
                }
                if (boundary.getFirst().isForcedRed(boundary.getSecond())) {
                    this.train.reservedSignalBlocks.clear();
                    return false;
                }
                if (!signalEdgeGroup.isOccupiedUnless(this.train)) continue;
                return false;
            }
            return true;
        }
        UUID groupId = signal.groups.get(this.waitingForSignal.getSecond());
        if (groupId == null) {
            return true;
        }
        SignalEdgeGroup signalEdgeGroup = Create.RAILWAYS.signalEdgeGroups.get(groupId);
        if (signalEdgeGroup == null) {
            return true;
        }
        return !signalEdgeGroup.isOccupiedUnless(this.train);
    }

    public boolean isActive() {
        return this.destination != null;
    }

    public TravellingPoint.ITrackSelector control(TravellingPoint mp) {
        if (this.destination == null) {
            return mp.steer(this.train.manualSteer, new class_243(0.0, 1.0, 0.0));
        }
        return (graph, pair) -> this.navigateOptions(this.currentPath, (TrackGraph)graph, (List)pair.getSecond());
    }

    public TravellingPoint.ITrackSelector controlSignalScout() {
        if (this.destination == null) {
            return this.signalScout.steer(this.train.manualSteer, new class_243(0.0, 1.0, 0.0));
        }
        ArrayList<Couple<TrackNode>> pathCopy = new ArrayList<Couple<TrackNode>>(this.currentPath);
        return (graph, pair) -> this.navigateOptions((List<Couple<TrackNode>>)pathCopy, (TrackGraph)graph, (List)pair.getSecond());
    }

    private Map.Entry<TrackNode, TrackEdge> navigateOptions(List<Couple<TrackNode>> path, TrackGraph graph, List<Map.Entry<TrackNode, TrackEdge>> options) {
        if (path.isEmpty()) {
            return options.get(0);
        }
        Couple<TrackNode> nodes = path.get(0);
        TrackEdge targetEdge = graph.getConnection(nodes);
        for (Map.Entry<TrackNode, TrackEdge> entry : options) {
            if (entry.getValue() != targetEdge) continue;
            path.remove(0);
            return entry;
        }
        return options.get(0);
    }

    public void cancelNavigation() {
        this.distanceToDestination = 0.0;
        this.currentPath.clear();
        if (this.destination == null) {
            return;
        }
        this.destination.cancelReservation(this.train);
        this.destination = null;
        this.train.runtime.transitInterrupted();
        this.train.reservedSignalBlocks.clear();
    }

    public double startNavigation(GlobalStation destination, double maxCost, boolean simulate) {
        double cost;
        DiscoveredPath pathTo = this.findPathTo(destination, maxCost);
        boolean noneFound = pathTo == null;
        double distance = noneFound ? -1.0 : Math.abs(pathTo.distance);
        double d = cost = noneFound ? -1.0 : pathTo.cost;
        if (simulate) {
            return cost;
        }
        this.distanceToDestination = distance;
        if (noneFound) {
            this.distanceStartedAt = 0.0;
            this.distanceToDestination = 0.0;
            this.currentPath = new ArrayList<Couple<TrackNode>>();
            if (this.destination != null) {
                this.cancelNavigation();
            }
            return -1.0;
        }
        if (Math.abs(this.distanceToDestination) > 100.0) {
            this.announceArrival = true;
        }
        this.currentPath = pathTo.path;
        this.destinationBehindTrain = pathTo.distance < 0.0;
        this.train.reservedSignalBlocks.clear();
        this.train.navigation.waitingForSignal = null;
        if (this.destination == null && !simulate) {
            this.distanceStartedAt = distance;
        }
        if (this.destination == destination) {
            return 0.0;
        }
        if (!this.train.runtime.paused) {
            boolean frontDriver = this.train.hasForwardConductor();
            boolean backDriver = this.train.hasBackwardConductor();
            if (this.destinationBehindTrain && !backDriver) {
                if (frontDriver) {
                    this.train.status.missingCorrectConductor();
                } else {
                    this.train.status.missingConductor();
                }
                return -1.0;
            }
            if (!this.destinationBehindTrain && !frontDriver) {
                if (backDriver) {
                    this.train.status.missingCorrectConductor();
                } else {
                    this.train.status.missingConductor();
                }
                return -1.0;
            }
            this.train.status.foundConductor();
        }
        this.destination = destination;
        return cost;
    }

    @Nullable
    private DiscoveredPath findPathTo(GlobalStation destination, double maxCost) {
        boolean canDriveBackward;
        TrackGraph graph = this.train.graph;
        if (graph == null) {
            return null;
        }
        Couple<Object> results = Couple.create(null, null);
        for (boolean forward : Iterate.trueAndFalse) {
            if (this.destination != null && this.destinationBehindTrain == forward) continue;
            TravellingPoint initialPoint = forward ? this.train.carriages.get(0).getLeadingPoint() : this.train.carriages.get(this.train.carriages.size() - 1).getTrailingPoint();
            TrackEdge initialEdge = forward ? initialPoint.edge : graph.getConnectionsFrom(initialPoint.node2).get(initialPoint.node1);
            this.search(Double.MAX_VALUE, maxCost, forward, (distance, cost, reachedVia, currentEntry, globalStation) -> {
                if (globalStation != destination) {
                    return false;
                }
                TrackEdge edge = (TrackEdge)currentEntry.getSecond();
                TrackNode node1 = (TrackNode)((Couple)currentEntry.getFirst()).getFirst();
                TrackNode node2 = (TrackNode)((Couple)currentEntry.getFirst()).getSecond();
                ArrayList<Couple<TrackNode>> currentPath = new ArrayList<Couple<TrackNode>>();
                Pair backTrack = (Pair)reachedVia.get(edge);
                Couple toReach = Couple.create(node1, node2);
                TrackEdge edgeReached = edge;
                while (backTrack != null && edgeReached != initialEdge) {
                    if (((Boolean)backTrack.getFirst()).booleanValue()) {
                        currentPath.add(0, toReach);
                    }
                    toReach = (Couple)backTrack.getSecond();
                    edgeReached = graph.getConnection(toReach);
                    backTrack = (Pair)reachedVia.get(edgeReached);
                }
                double position = edge.getLength() - destination.getLocationOn(edge);
                double distanceToDestination = distance - position;
                results.set(forward, new DiscoveredPath((double)(forward ? 1 : -1) * distanceToDestination, cost, currentPath));
                return true;
            });
        }
        DiscoveredPath front = (DiscoveredPath)results.getFirst();
        DiscoveredPath back = (DiscoveredPath)results.getSecond();
        boolean frontEmpty = front == null;
        boolean backEmpty = back == null;
        boolean canDriveForward = this.train.hasForwardConductor() || this.train.runtime.paused;
        boolean bl = canDriveBackward = this.train.doubleEnded && this.train.hasBackwardConductor() || this.train.runtime.paused;
        if (backEmpty || !canDriveBackward) {
            return canDriveForward ? front : null;
        }
        if (frontEmpty || !canDriveForward) {
            return canDriveBackward ? back : null;
        }
        boolean frontBetter = maxCost == -1.0 ? -back.distance > front.distance : back.cost > front.cost;
        return frontBetter ? front : back;
    }

    public GlobalStation findNearestApproachable(boolean forward) {
        TrackGraph graph = this.train.graph;
        if (graph == null) {
            return null;
        }
        MutableObject result = new MutableObject(null);
        double acceleration = this.train.acceleration();
        double minDistance = 0.75 * (this.train.speed * this.train.speed) / (2.0 * acceleration);
        double maxDistance = Math.max(32.0, 1.5 * (this.train.speed * this.train.speed) / (2.0 * acceleration));
        this.search(maxDistance, forward, (distance, cost, reachedVia, currentEntry, globalStation) -> {
            if (distance < minDistance) {
                return false;
            }
            TrackEdge edge = (TrackEdge)currentEntry.getSecond();
            double position = edge.getLength() - globalStation.getLocationOn(edge);
            if (distance - position < minDistance) {
                return false;
            }
            Train presentTrain = globalStation.getPresentTrain();
            if (presentTrain != null && presentTrain != this.train) {
                return false;
            }
            result.setValue((Object)globalStation);
            return true;
        });
        return (GlobalStation)result.getValue();
    }

    public void search(double maxDistance, boolean forward, StationTest stationTest) {
        this.search(maxDistance, -1.0, forward, stationTest);
    }

    public void search(double maxDistance, double maxCost, boolean forward, StationTest stationTest) {
        boolean costRelevant;
        TrackGraph graph = this.train.graph;
        if (graph == null) {
            return;
        }
        IdentityHashMap penalties = new IdentityHashMap();
        boolean bl = costRelevant = maxCost >= 0.0;
        if (costRelevant) {
            for (Train otherTrain : Create.RAILWAYS.trains.values()) {
                if (otherTrain.graph != graph || otherTrain == this.train) continue;
                int navigationPenalty = otherTrain.getNavigationPenalty();
                otherTrain.getEndpointEdges().forEach(nodes -> {
                    if (nodes.either(Objects::isNull)) {
                        return;
                    }
                    for (boolean flip : Iterate.trueAndFalse) {
                        TrackEdge e = graph.getConnection((Couple<TrackNode>)(flip ? nodes.swap() : nodes));
                        if (e == null) continue;
                        int existing = penalties.getOrDefault(e, 0);
                        penalties.put(e, existing + navigationPenalty / 2);
                    }
                });
            }
        }
        TravellingPoint startingPoint = forward ? this.train.carriages.get(0).getLeadingPoint() : this.train.carriages.get(this.train.carriages.size() - 1).getTrailingPoint();
        HashSet<TrackEdge> visited = new HashSet<TrackEdge>();
        IdentityHashMap<TrackEdge, Pair<Boolean, Couple<TrackNode>>> reachedVia = new IdentityHashMap<TrackEdge, Pair<Boolean, Couple<TrackNode>>>();
        PriorityQueue<FrontierEntry> frontier = new PriorityQueue<FrontierEntry>();
        TrackNode initialNode1 = forward ? startingPoint.node1 : startingPoint.node2;
        TrackNode initialNode2 = forward ? startingPoint.node2 : startingPoint.node1;
        TrackEdge initialEdge = graph.getConnectionsFrom(initialNode1).get(initialNode2);
        if (initialEdge == null) {
            return;
        }
        double distanceToNode2 = forward ? initialEdge.getLength() - startingPoint.position : startingPoint.position;
        frontier.add(new FrontierEntry(distanceToNode2, 0, initialNode1, initialNode2, initialEdge));
        int signalWeight = class_3532.method_15340((int)(this.ticksWaitingForSignal * 2), (int)25, (int)200);
        block1: while (!frontier.isEmpty()) {
            TrackNode newNode;
            EdgeData signalData;
            FrontierEntry entry = (FrontierEntry)frontier.poll();
            if (!visited.add(entry.edge)) continue;
            double distance = entry.distance;
            int penalty = entry.penalty;
            if (distance > maxDistance) continue;
            TrackEdge edge = entry.edge;
            TrackNode node1 = entry.node1;
            TrackNode node2 = entry.node2;
            if (costRelevant) {
                penalty += penalties.getOrDefault(edge, 0).intValue();
            }
            if ((signalData = edge.getEdgeData()).hasPoints()) {
                for (TrackEdgePoint point : signalData.getPoints()) {
                    boolean isOwnStation;
                    if (node1 == initialNode1 && point.getLocationOn(edge) < edge.getLength() - distanceToNode2) continue;
                    if (costRelevant && distance + (double)penalty > maxCost || !point.canNavigateVia(node2)) continue block1;
                    if (point instanceof SignalBoundary) {
                        SignalEdgeGroup signalEdgeGroup;
                        SignalBoundary signal = (SignalBoundary)point;
                        if (signal.isForcedRed(node2)) {
                            penalty += 400;
                            continue;
                        }
                        UUID group = signal.getGroup(node2);
                        if (group == null || (signalEdgeGroup = Create.RAILWAYS.signalEdgeGroups.get(group)) == null) continue;
                        if (signalEdgeGroup.isOccupiedUnless(signal)) {
                            penalty += signalWeight;
                            signalWeight /= 2;
                        }
                    }
                    if (!(point instanceof GlobalStation)) continue;
                    GlobalStation station = (GlobalStation)point;
                    Train presentTrain = station.getPresentTrain();
                    boolean bl2 = isOwnStation = presentTrain == this.train;
                    if (presentTrain != null && !isOwnStation) {
                        penalty += 300;
                    }
                    if (station.canApproachFrom(node2) && stationTest.test(distance, distance + (double)penalty, reachedVia, Pair.of(Couple.create(node1, node2), edge), station)) {
                        return;
                    }
                    if (isOwnStation) continue;
                    penalty += 200;
                }
            }
            if (costRelevant && distance + (double)penalty > maxCost) continue;
            ArrayList<Map.Entry<TrackNode, TrackEdge>> validTargets = new ArrayList<Map.Entry<TrackNode, TrackEdge>>();
            Map<TrackNode, TrackEdge> connectionsFrom = graph.getConnectionsFrom(node2);
            for (Map.Entry<TrackNode, TrackEdge> connection : connectionsFrom.entrySet()) {
                newNode = connection.getKey();
                if (newNode == node1 || !edge.canTravelTo(connection.getValue())) continue;
                validTargets.add(connection);
            }
            if (validTargets.isEmpty()) continue;
            for (Map.Entry<TrackNode, TrackEdge> target : validTargets) {
                newNode = target.getKey();
                TrackEdge newEdge = target.getValue();
                double newDistance = newEdge.getLength() + distance;
                int newPenalty = penalty;
                reachedVia.putIfAbsent(newEdge, Pair.of(validTargets.size() > 1, Couple.create(node1, node2)));
                frontier.add(new FrontierEntry(newDistance, newPenalty, node2, newNode, newEdge));
            }
        }
    }

    public class_2487 write(DimensionPalette dimensions) {
        class_2487 tag = new class_2487();
        if (this.destination == null) {
            return tag;
        }
        tag.method_25927("Destination", this.destination.id);
        tag.method_10549("DistanceToDestination", this.distanceToDestination);
        tag.method_10549("DistanceStartedAt", this.distanceStartedAt);
        tag.method_10556("BehindTrain", this.destinationBehindTrain);
        tag.method_10556("AnnounceArrival", this.announceArrival);
        tag.method_10566("Path", (class_2520)NBTHelper.writeCompoundList(this.currentPath, c -> {
            class_2487 nbt = new class_2487();
            nbt.method_10566("Nodes", (class_2520)c.map(TrackNode::getLocation).serializeEach(loc -> loc.write(dimensions)));
            return nbt;
        }));
        if (this.waitingForSignal == null) {
            return tag;
        }
        tag.method_25927("BlockingSignal", this.waitingForSignal.getFirst());
        tag.method_10556("BlockingSignalSide", this.waitingForSignal.getSecond().booleanValue());
        tag.method_10549("DistanceToSignal", this.distanceToSignal);
        tag.method_10569("TicksWaitingForSignal", this.ticksWaitingForSignal);
        return tag;
    }

    public void read(class_2487 tag, TrackGraph graph, DimensionPalette dimensions) {
        GlobalStation globalStation = this.destination = graph != null && tag.method_10545("Destination") ? graph.getPoint(EdgePointType.STATION, tag.method_25926("Destination")) : null;
        if (this.destination == null) {
            return;
        }
        this.distanceToDestination = tag.method_10574("DistanceToDestination");
        this.distanceStartedAt = tag.method_10574("DistanceStartedAt");
        this.destinationBehindTrain = tag.method_10577("BehindTrain");
        this.announceArrival = tag.method_10577("AnnounceArrival");
        this.currentPath.clear();
        NBTHelper.iterateCompoundList(tag.method_10554("Path", 10), c -> this.currentPath.add(Couple.deserializeEach(c.method_10554("Nodes", 10), c2 -> TrackNodeLocation.read(c2, dimensions)).map(graph::locateNode)));
        Pair<UUID, Boolean> pair = this.waitingForSignal = tag.method_10545("BlockingSignal") ? Pair.of(tag.method_25926("BlockingSignal"), tag.method_10577("BlockingSignalSide")) : null;
        if (this.waitingForSignal == null) {
            return;
        }
        this.distanceToSignal = tag.method_10574("DistanceToSignal");
        this.ticksWaitingForSignal = tag.method_10550("TicksWaitingForSignal");
    }

    public class DiscoveredPath {
        List<Couple<TrackNode>> path;
        double distance;
        double cost;

        public DiscoveredPath(double distance, double cost, List<Couple<TrackNode>> path) {
            this.distance = distance;
            this.cost = cost;
            this.path = path;
        }
    }

    @FunctionalInterface
    public static interface StationTest {
        public boolean test(double var1, double var3, Map<TrackEdge, Pair<Boolean, Couple<TrackNode>>> var5, Pair<Couple<TrackNode>, TrackEdge> var6, GlobalStation var7);
    }

    private class FrontierEntry
    implements Comparable<FrontierEntry> {
        double distance;
        int penalty;
        TrackNode node1;
        TrackNode node2;
        TrackEdge edge;

        public FrontierEntry(double distance, int penalty, TrackNode node1, TrackNode node2, TrackEdge edge) {
            this.distance = distance;
            this.penalty = penalty;
            this.node1 = node1;
            this.node2 = node2;
            this.edge = edge;
        }

        @Override
        public int compareTo(FrontierEntry o) {
            return Double.compare(this.distance + (double)this.penalty, o.distance + (double)o.penalty);
        }
    }
}

