/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.google.common.base.Strings;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionBlockChangedPacket;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.controls.ControlsBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.controls.TrainHUDUpdatePacket;
import com.simibubi.create.content.contraptions.particle.CubeParticleData;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageBogey;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraption;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionInstance;
import com.simibubi.create.content.logistics.trains.entity.CarriageDataUpdatePacket;
import com.simibubi.create.content.logistics.trains.entity.CarriageParticles;
import com.simibubi.create.content.logistics.trains.entity.CarriageSounds;
import com.simibubi.create.content.logistics.trains.entity.CarriageSyncData;
import com.simibubi.create.content.logistics.trains.entity.Navigation;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.entity.TrainPromptPacket;
import com.simibubi.create.content.logistics.trains.entity.TravellingPoint;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class CarriageContraptionEntity
extends OrientedContraptionEntity {
    private static final class_2940<Optional<UUID>> TRACK_GRAPH = class_2945.method_12791(CarriageContraptionEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Boolean> SCHEDULED = class_2945.method_12791(CarriageContraptionEntity.class, (class_2941)class_2943.field_13323);
    public UUID trainId;
    public int carriageIndex;
    private Carriage carriage;
    public boolean validForRender = false;
    public boolean movingBackwards;
    public boolean leftTickingChunks;
    public boolean firstPositionUpdate = true;
    private boolean arrivalSoundPlaying;
    private boolean arrivalSoundReversed;
    private int arrivalSoundTicks;
    private class_243 serverPrevPos;
    @Environment(value=EnvType.CLIENT)
    public CarriageSounds sounds;
    @Environment(value=EnvType.CLIENT)
    public CarriageParticles particles;
    public CarriageSyncData carriageData = new CarriageSyncData();
    class_243 derailParticleOffset;
    private Set<class_2338> particleSlice = new HashSet<class_2338>();
    private float particleAvgY = 0.0f;
    double navDistanceTotal = 0.0;
    int hudPacketCooldown = 0;
    boolean stationMessage = false;
    @Environment(value=EnvType.CLIENT)
    private WeakReference<CarriageContraptionInstance> instanceHolder;

    public CarriageContraptionEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.arrivalSoundTicks = Integer.MIN_VALUE;
        this.derailParticleOffset = VecHelper.offsetRandomly(class_243.field_1353, world.field_9229, 1.5f).method_18805(1.0, 0.25, 1.0);
    }

    public boolean method_5787() {
        return true;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TRACK_GRAPH, Optional.empty());
        this.field_6011.method_12784(SCHEDULED, (Object)false);
    }

    public void syncCarriage() {
        CarriageSyncData carriageData = this.getCarriageData();
        if (carriageData == null) {
            return;
        }
        if (this.carriage == null) {
            return;
        }
        carriageData.update(this, this.carriage);
    }

    @Override
    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (!this.field_6002.field_9236) {
            return;
        }
        this.bindCarriage();
        if (TRACK_GRAPH.equals(key)) {
            this.updateTrackGraph();
        }
    }

    public void onCarriageDataUpdate(CarriageSyncData newData) {
        this.carriageData = newData;
        if (this.carriage == null) {
            return;
        }
        this.carriageData.apply(this, this.carriage);
    }

    public void sendCarriageDataUpdate() {
        AllPackets.channel.sendToClientsTracking((S2CPacket)new CarriageDataUpdatePacket(this), (class_1297)this);
    }

    public CarriageSyncData getCarriageData() {
        return this.carriageData;
    }

    public boolean hasSchedule() {
        return (Boolean)this.field_6011.method_12789(SCHEDULED);
    }

    public void setServerSidePrevPosition() {
        this.serverPrevPos = this.method_19538();
    }

    @Override
    public class_243 getPrevPositionVec() {
        if (!this.field_6002.method_8608() && this.serverPrevPos != null) {
            return this.serverPrevPos;
        }
        return super.getPrevPositionVec();
    }

    public boolean isLocalCoordWithin(class_2338 localPos, int min, int max) {
        Contraption contraption = this.getContraption();
        if (!(contraption instanceof CarriageContraption)) {
            return false;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        class_2350 facing = cc.getAssemblyDirection();
        class_2350.class_2351 axis = facing.method_10170().method_10166();
        int coord = axis.method_10173(localPos.method_10260(), localPos.method_10264(), localPos.method_10263()) * -facing.method_10171().method_10181();
        return coord >= min && coord <= max;
    }

    public static CarriageContraptionEntity create(class_1937 world, CarriageContraption contraption) {
        CarriageContraptionEntity entity = new CarriageContraptionEntity((class_1299)AllEntityTypes.CARRIAGE_CONTRAPTION.get(), world);
        entity.setContraption(contraption);
        entity.setInitialOrientation(contraption.getAssemblyDirection().method_10170());
        entity.startAtInitialYaw();
        return entity;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        Contraption contraption = this.contraption;
        if (contraption instanceof CarriageContraption) {
            CarriageContraption cc = (CarriageContraption)contraption;
            for (class_1297 entity : this.method_5685()) {
                class_2338 seatOf;
                if (entity instanceof class_1657 || (seatOf = cc.getSeatOf(entity.method_5667())) == null || cc.conductorSeats.get(seatOf) == null) continue;
                this.alignPassenger(entity);
            }
        }
    }

    @Override
    public void setBlock(class_2338 localPos, class_3499.class_3501 newInfo) {
        if (this.carriage == null) {
            return;
        }
        this.carriage.forEachPresentEntity(cce -> {
            cce.contraption.getBlocks().put(localPos, newInfo);
            AllPackets.channel.sendToClientsTracking((S2CPacket)new ContraptionBlockChangedPacket(cce.method_5628(), localPos, newInfo.field_15596), (class_1297)cce);
        });
    }

    @Override
    protected void tickContraption() {
        boolean isStalled;
        Contraption contraption;
        if (this.nonDamageTicks > 0) {
            --this.nonDamageTicks;
        }
        if (!((contraption = this.contraption) instanceof CarriageContraption)) {
            return;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        if (this.carriage == null) {
            if (this.field_6002.field_9236) {
                this.bindCarriage();
            } else {
                this.method_31472();
            }
            return;
        }
        if (!Create.RAILWAYS.sided((class_1936)this.field_6002).trains.containsKey(this.carriage.train.id)) {
            this.method_31472();
            return;
        }
        this.tickActors();
        this.carriage.stalled = isStalled = this.isStalled();
        CarriageSyncData carriageData = this.getCarriageData();
        if (!this.field_6002.field_9236) {
            this.field_6011.method_12778(SCHEDULED, (Object)(this.carriage.train.runtime.getSchedule() != null ? 1 : 0));
            boolean shouldCarriageSyncThisTick = this.carriage.train.shouldCarriageSyncThisTick(this.field_6002.method_8510(), this.method_5864().method_18388());
            if (shouldCarriageSyncThisTick && carriageData.isDirty()) {
                this.sendCarriageDataUpdate();
                carriageData.setDirty(false);
            }
            Navigation navigation = this.carriage.train.navigation;
            if (navigation.announceArrival && Math.abs(navigation.distanceToDestination) < 60.0 && this.carriageIndex == (this.carriage.train.speed < 0.0 ? this.carriage.train.carriages.size() - 1 : 0)) {
                navigation.announceArrival = false;
                this.arrivalSoundPlaying = true;
                this.arrivalSoundReversed = this.carriage.train.speed < 0.0;
                this.arrivalSoundTicks = Integer.MIN_VALUE;
            }
            if (this.arrivalSoundPlaying) {
                this.tickArrivalSound(cc);
            }
            this.field_6011.method_12778(TRACK_GRAPH, Optional.ofNullable(this.carriage.train.graph).map(g -> g.id));
            return;
        }
        Carriage.DimensionalCarriageEntity dce = this.carriage.getDimensional(this.field_6002);
        if (this.field_6012 % 10 == 0) {
            this.updateTrackGraph();
        }
        if (!dce.pointsInitialised) {
            return;
        }
        carriageData.approach(this, this.carriage, 1.0f / (float)this.method_5864().method_18388());
        if (!this.carriage.train.derailed) {
            this.carriage.updateContraptionAnchors();
        }
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        dce.alignEntity(this);
        if (this.sounds == null) {
            this.sounds = new CarriageSounds(this);
        }
        this.sounds.tick(dce);
        if (this.particles == null) {
            this.particles = new CarriageParticles(this);
        }
        this.particles.tick(dce);
        double distanceTo = 0.0;
        if (!this.firstPositionUpdate) {
            class_243 diff = this.method_19538().method_1023(this.field_6014, this.field_6036, this.field_5969);
            class_243 relativeDiff = VecHelper.rotate(diff, this.yaw, class_2350.class_2351.field_11052);
            double signum = Math.signum(-relativeDiff.field_1352);
            distanceTo = diff.method_1033() * signum;
            this.movingBackwards = signum < 0.0;
        }
        ((CarriageBogey)this.carriage.bogeys.getFirst()).updateAngles(this, distanceTo);
        if (this.carriage.isOnTwoBogeys()) {
            ((CarriageBogey)this.carriage.bogeys.getSecond()).updateAngles(this, distanceTo);
        }
        if (this.carriage.train.derailed) {
            this.spawnDerailParticles(this.carriage);
        }
        if (dce.pivot != null) {
            this.spawnPortalParticles(dce);
        }
        this.firstPositionUpdate = false;
        this.validForRender = true;
    }

    private void bindCarriage() {
        if (this.carriage != null) {
            return;
        }
        Train train = Create.RAILWAYS.sided((class_1936)this.field_6002).trains.get(this.trainId);
        if (train == null || train.carriages.size() <= this.carriageIndex) {
            return;
        }
        this.carriage = train.carriages.get(this.carriageIndex);
        if (this.carriage != null) {
            Carriage.DimensionalCarriageEntity dimensional = this.carriage.getDimensional(this.field_6002);
            dimensional.entity = new WeakReference<CarriageContraptionEntity>(this);
            dimensional.pivot = null;
            this.carriage.updateContraptionAnchors();
            dimensional.updateRenderedCutoff();
        }
        this.updateTrackGraph();
    }

    private void tickArrivalSound(CarriageContraption cc) {
        List<Carriage> carriages = this.carriage.train.carriages;
        if (this.arrivalSoundTicks == Integer.MIN_VALUE) {
            int carriageCount = carriages.size();
            Integer tick = null;
            for (int index = 0; index < carriageCount; ++index) {
                Contraption contraption;
                int i = this.arrivalSoundReversed ? carriageCount - 1 - index : index;
                Carriage carriage = carriages.get(i);
                CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)carriage.getDimensional((class_1937)this.field_6002).entity.get());
                if (entity == null || !((contraption = entity.contraption) instanceof CarriageContraption)) break;
                CarriageContraption otherCC = (CarriageContraption)contraption;
                Integer n = tick = this.arrivalSoundReversed ? otherCC.soundQueue.lastTick() : otherCC.soundQueue.firstTick();
                if (tick != null) break;
            }
            if (tick == null) {
                this.arrivalSoundPlaying = false;
                return;
            }
            this.arrivalSoundTicks = tick;
        }
        if (this.field_6012 % 2 == 0) {
            return;
        }
        boolean keepTicking = false;
        for (Carriage c : carriages) {
            Contraption contraption;
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)c.getDimensional((class_1937)this.field_6002).entity.get());
            if (entity == null || !((contraption = entity.contraption) instanceof CarriageContraption)) continue;
            CarriageContraption otherCC = (CarriageContraption)contraption;
            keepTicking |= otherCC.soundQueue.tick(entity, this.arrivalSoundTicks, this.arrivalSoundReversed);
        }
        if (!keepTicking) {
            this.arrivalSoundPlaying = false;
            return;
        }
        this.arrivalSoundTicks += this.arrivalSoundReversed ? -1 : 1;
    }

    @Override
    public void tickActors() {
        super.tickActors();
    }

    @Override
    protected boolean isActorActive(MovementContext context, MovementBehaviour actor) {
        Contraption contraption = this.contraption;
        if (!(contraption instanceof CarriageContraption)) {
            return false;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        if (!super.isActorActive(context, actor)) {
            return false;
        }
        return cc.notInPortal() || this.field_6002.method_8608();
    }

    @Override
    protected void handleStallInformation(double x, double y, double z, float angle) {
    }

    private void spawnDerailParticles(Carriage carriage) {
        if (this.field_5974.method_43057() < 0.05f) {
            class_243 v = this.method_19538().method_1019(this.derailParticleOffset);
            this.field_6002.method_8406((class_2394)class_2398.field_17430, v.field_1352, v.field_1351, v.field_1350, 0.0, 0.04, 0.0);
        }
    }

    protected void method_5627(class_1297 pPassenger) {
        super.method_5627(pPassenger);
        if (!(pPassenger instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)pPassenger;
        player.getExtraCustomData().method_10566("ContraptionMountLocation", (class_2520)VecHelper.writeNBT(player.method_19538()));
    }

    private void spawnPortalParticles(Carriage.DimensionalCarriageEntity dce) {
        class_243 pivot = dce.pivot.getLocation().method_1031(0.0, 1.5, 0.0);
        if (this.particleSlice.isEmpty()) {
            return;
        }
        boolean alongX = class_3532.method_20390((double)pivot.field_1352, (double)Math.round(pivot.field_1352));
        int extraFlip = class_2350.method_10150((double)this.yaw).method_10171().method_10181();
        class_243 emitter = pivot.method_1031(0.0, (double)this.particleAvgY, 0.0);
        double speed = this.method_19538().method_1022(this.getPrevPositionVec());
        int size = (int)((double)this.particleSlice.size() * class_3532.method_15350((double)(4.0 - speed * 4.0), (double)0.0, (double)4.0));
        for (class_2338 pos : this.particleSlice) {
            if (size != 0 && this.field_5974.method_43048(size) != 0) continue;
            if (alongX) {
                pos = new class_2338(0, pos.method_10264(), pos.method_10263());
            }
            class_243 v = pivot.method_1031((double)(pos.method_10263() * extraFlip), (double)pos.method_10264(), (double)(pos.method_10260() * extraFlip));
            CubeParticleData data = new CubeParticleData(0.25f, 0.0f, 0.5f, 0.65f + (this.field_5974.method_43057() - 0.5f) * 0.25f, 4, false);
            class_243 m = v.method_1020(emitter).method_1029().method_1021((double)0.325f);
            m = VecHelper.rotate(m, this.field_5974.method_43057() * 360.0f, alongX ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051);
            m = m.method_1019(VecHelper.offsetRandomly(class_243.field_1353, this.field_5974, 0.25f));
            this.field_6002.method_8406((class_2394)data, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    public void method_36209() {
        super.method_36209();
        this.carriageData = new CarriageSyncData();
        if (this.carriage != null) {
            Carriage.DimensionalCarriageEntity dce = this.carriage.getDimensional(this.field_6002);
            dce.pointsInitialised = false;
            this.carriage.leadingBogey().couplingAnchors = Couple.create(null, null);
            this.carriage.trailingBogey().couplingAnchors = Couple.create(null, null);
        }
        this.firstPositionUpdate = true;
        if (this.sounds != null) {
            this.sounds.stop();
        }
    }

    @Override
    protected void writeAdditional(class_2487 compound, boolean spawnPacket) {
        super.writeAdditional(compound, spawnPacket);
        compound.method_25927("TrainId", this.trainId);
        compound.method_10569("CarriageIndex", this.carriageIndex);
    }

    @Override
    protected void readAdditional(class_2487 compound, boolean spawnPacket) {
        super.readAdditional(compound, spawnPacket);
        this.trainId = compound.method_25926("TrainId");
        this.carriageIndex = compound.method_10550("CarriageIndex");
        if (spawnPacket) {
            this.field_6038 = this.method_23317();
            this.field_5971 = this.method_23318();
            this.field_5989 = this.method_23321();
        }
    }

    @Override
    public class_2561 getContraptionName() {
        if (this.carriage != null) {
            return this.carriage.train.name;
        }
        class_2561 contraptionName = super.getContraptionName();
        return contraptionName;
    }

    public Couple<Boolean> checkConductors() {
        Couple<Boolean> sides = Couple.create(false, false);
        Contraption contraption = this.contraption;
        if (!(contraption instanceof CarriageContraption)) {
            return sides;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        sides.setFirst((Boolean)cc.blazeBurnerConductors.getFirst());
        sides.setSecond((Boolean)cc.blazeBurnerConductors.getSecond());
        for (class_1297 entity : this.method_5685()) {
            Couple<Boolean> validSides;
            class_2338 seatOf;
            if (entity instanceof class_1657 || (seatOf = cc.getSeatOf(entity.method_5667())) == null || (validSides = cc.conductorSeats.get(seatOf)) == null) continue;
            sides.setFirst((Boolean)sides.getFirst() != false || (Boolean)validSides.getFirst() != false);
            sides.setSecond((Boolean)sides.getSecond() != false || (Boolean)validSides.getSecond() != false);
        }
        return sides;
    }

    @Override
    public boolean startControlling(class_2338 controlsLocalPos, class_1657 player) {
        if (player == null || player.method_7325()) {
            return false;
        }
        if (this.carriage == null) {
            return false;
        }
        if (this.carriage.train.derailed) {
            return false;
        }
        Train train = this.carriage.train;
        if (train.runtime.getSchedule() != null && !train.runtime.paused) {
            train.status.manualControls();
        }
        train.navigation.cancelNavigation();
        train.runtime.paused = true;
        train.navigation.waitingForSignal = null;
        return true;
    }

    public class_2561 method_5476() {
        if (this.carriage == null) {
            return Lang.translateDirect("train", new Object[0]);
        }
        return this.carriage.train.name;
    }

    @Override
    public boolean control(class_2338 controlsLocalPos, Collection<Integer> heldControls, class_1657 player) {
        boolean counteringAcceleration;
        if (this.carriage == null) {
            return false;
        }
        if (this.carriage.train.derailed) {
            return false;
        }
        if (this.field_6002.field_9236) {
            return true;
        }
        if (player.method_7325()) {
            return false;
        }
        if (!this.toGlobalVector(VecHelper.getCenterOf((class_2382)controlsLocalPos), 1.0f).method_24802((class_2374)player.method_19538(), 8.0)) {
            return false;
        }
        if (heldControls.contains(5)) {
            return false;
        }
        class_3499.class_3501 info = this.contraption.getBlocks().get(controlsLocalPos);
        class_2350 initialOrientation = this.getInitialOrientation().method_10160();
        boolean inverted = false;
        if (info != null && info.field_15596.method_28498((class_2769)ControlsBlock.field_11177)) {
            boolean bl = inverted = !((class_2350)info.field_15596.method_11654((class_2769)ControlsBlock.field_11177)).equals((Object)initialOrientation);
        }
        if (this.hudPacketCooldown-- <= 0 && player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            AllPackets.channel.sendToClient((S2CPacket)new TrainHUDUpdatePacket(this.carriage.train), sp);
            this.hudPacketCooldown = 5;
        }
        int targetSpeed = 0;
        if (heldControls.contains(0)) {
            ++targetSpeed;
        }
        if (heldControls.contains(1)) {
            --targetSpeed;
        }
        int targetSteer = 0;
        if (heldControls.contains(2)) {
            ++targetSteer;
        }
        if (heldControls.contains(3)) {
            --targetSteer;
        }
        if (inverted) {
            targetSpeed *= -1;
            targetSteer *= -1;
        }
        if (targetSpeed != 0) {
            this.carriage.train.burnFuel();
        }
        boolean slow = inverted ^ targetSpeed < 0;
        boolean spaceDown = heldControls.contains(4);
        GlobalStation currentStation = this.carriage.train.getCurrentStation();
        if (currentStation != null && spaceDown) {
            this.sendPrompt(player, Lang.translateDirect("train.arrived_at", Components.literal(currentStation.name).method_27694(s -> s.method_36139(7358000))), false);
            return true;
        }
        if (this.carriage.train.speedBeforeStall != null && targetSpeed != 0 && Math.signum(this.carriage.train.speedBeforeStall) != (double)Math.signum(targetSpeed)) {
            this.carriage.train.cancelStall();
        }
        if (currentStation != null && targetSpeed != 0) {
            this.stationMessage = false;
            this.sendPrompt(player, Lang.translateDirect("train.departing_from", Components.literal(currentStation.name).method_27694(s -> s.method_36139(7358000))), false);
        }
        if (currentStation == null) {
            double directedSpeed;
            Navigation nav = this.carriage.train.navigation;
            if (nav.destination != null) {
                if (!spaceDown) {
                    nav.cancelNavigation();
                }
                if (spaceDown) {
                    double f = nav.distanceToDestination / this.navDistanceTotal;
                    int progress = (int)(class_3532.method_15350((double)(1.0 - (1.0 - f) * (1.0 - f)), (double)0.0, (double)1.0) * 30.0);
                    boolean arrived = progress == 0;
                    class_5250 whiteComponent = Components.literal(Strings.repeat((String)"|", (int)progress));
                    class_5250 greenComponent = Components.literal(Strings.repeat((String)"|", (int)(30 - progress)));
                    int fromColor = 16761412;
                    int toColor = 5413141;
                    int mixedColor = Color.mixColors(toColor, fromColor, (float)progress / 30.0f);
                    int targetColor = arrived ? toColor : 0x544D45;
                    class_5250 component = greenComponent.method_27694(st -> st.method_36139(mixedColor)).method_10852((class_2561)whiteComponent.method_27694(st -> st.method_36139(targetColor)));
                    this.sendPrompt(player, component, true);
                    this.carriage.train.manualTick = true;
                    return true;
                }
            }
            double d = directedSpeed = targetSpeed != 0 ? (double)targetSpeed : this.carriage.train.speed;
            GlobalStation lookAhead = nav.findNearestApproachable(!this.carriage.train.doubleEnded || (directedSpeed != 0.0 ? directedSpeed > 0.0 : !inverted));
            if (lookAhead != null) {
                if (spaceDown) {
                    this.carriage.train.manualTick = true;
                    nav.startNavigation(lookAhead, -1.0, false);
                    this.carriage.train.manualTick = false;
                    this.navDistanceTotal = nav.distanceToDestination;
                    return true;
                }
                this.displayApproachStationMessage(player, lookAhead);
            } else {
                this.cleanUpApproachStationMessage(player);
            }
        }
        this.carriage.train.manualSteer = targetSteer < 0 ? TravellingPoint.SteerDirection.RIGHT : (targetSteer > 0 ? TravellingPoint.SteerDirection.LEFT : TravellingPoint.SteerDirection.NONE);
        double topSpeed = this.carriage.train.maxSpeed() * AllConfigs.SERVER.trains.manualTrainSpeedModifier.getF();
        double cappedTopSpeed = topSpeed * this.carriage.train.throttle;
        if (this.carriage.getLeadingPoint().edge != null && this.carriage.getLeadingPoint().edge.isTurn() || this.carriage.getTrailingPoint().edge != null && this.carriage.getTrailingPoint().edge.isTurn()) {
            topSpeed = this.carriage.train.maxTurnSpeed();
        }
        if (slow) {
            topSpeed /= 4.0;
        }
        this.carriage.train.targetSpeed = Math.min(topSpeed, cappedTopSpeed) * (double)targetSpeed;
        boolean bl = counteringAcceleration = Math.abs((double)Math.signum(targetSpeed) - Math.signum(this.carriage.train.speed)) > 1.5;
        if (slow && !counteringAcceleration) {
            this.carriage.train.backwardsDriver = player;
        }
        this.carriage.train.manualTick = true;
        this.carriage.train.approachTargetSpeed(counteringAcceleration ? 2.0f : 1.0f);
        return true;
    }

    private void sendPrompt(class_1657 player, class_5250 component, boolean shadow) {
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            AllPackets.channel.sendToClient((S2CPacket)new TrainPromptPacket((class_2561)component, shadow), sp);
        }
    }

    private void displayApproachStationMessage(class_1657 player, GlobalStation station) {
        this.sendPrompt(player, Lang.translateDirect("contraption.controls.approach_station", Components.keybind("key.jump"), station.name), false);
        this.stationMessage = true;
    }

    private void cleanUpApproachStationMessage(class_1657 player) {
        if (!this.stationMessage) {
            return;
        }
        player.method_7353(Components.immutableEmpty(), true);
        this.stationMessage = false;
    }

    private void updateTrackGraph() {
        if (this.carriage == null) {
            return;
        }
        Optional optional = (Optional)this.field_6011.method_12789(TRACK_GRAPH);
        if (optional.isEmpty()) {
            this.carriage.train.graph = null;
            this.carriage.train.derailed = true;
            return;
        }
        TrackGraph graph = CreateClient.RAILWAYS.sided((class_1936)this.field_6002).trackNetworks.get(optional.get());
        if (graph == null) {
            return;
        }
        this.carriage.train.graph = graph;
        this.carriage.train.derailed = false;
    }

    public boolean method_31746() {
        return false;
    }

    public Carriage getCarriage() {
        return this.carriage;
    }

    public void setCarriage(Carriage carriage) {
        this.carriage = carriage;
        this.trainId = carriage.train.id;
        this.carriageIndex = carriage.train.carriages.indexOf(carriage);
        Contraption contraption = this.contraption;
        if (contraption instanceof CarriageContraption) {
            CarriageContraption cc = (CarriageContraption)contraption;
            cc.swapStorageAfterAssembly(this);
        }
        if (carriage.train.graph != null) {
            this.field_6011.method_12778(TRACK_GRAPH, Optional.of(carriage.train.graph.id));
        }
        Carriage.DimensionalCarriageEntity dimensional = carriage.getDimensional(this.field_6002);
        dimensional.pivot = null;
        carriage.updateContraptionAnchors();
        dimensional.updateRenderedCutoff();
    }

    @Environment(value=EnvType.CLIENT)
    public void bindInstance(CarriageContraptionInstance instance) {
        this.instanceHolder = new WeakReference<CarriageContraptionInstance>(instance);
        this.updateRenderedPortalCutoff();
    }

    @Environment(value=EnvType.CLIENT)
    public void updateRenderedPortalCutoff() {
        if (this.carriage == null) {
            return;
        }
        this.particleSlice.clear();
        this.particleAvgY = 0.0f;
        Contraption contraption = this.contraption;
        if (contraption instanceof CarriageContraption) {
            CarriageContraption cc = (CarriageContraption)contraption;
            class_2350 forward = cc.getAssemblyDirection().method_10170();
            class_2350.class_2351 axis = forward.method_10166();
            boolean x = axis == class_2350.class_2351.field_11048;
            boolean flip = true;
            for (class_2338 pos : this.contraption.getBlocks().keySet()) {
                if (!cc.atSeam(pos)) continue;
                int pX = x ? pos.method_10263() : pos.method_10260();
                pos = new class_2338(pX *= forward.method_10171().method_10181() * (flip ? 1 : -1), pos.method_10264(), 0);
                this.particleSlice.add(pos);
                this.particleAvgY += (float)pos.method_10264();
            }
        }
        if (this.particleSlice.size() > 0) {
            this.particleAvgY /= (float)this.particleSlice.size();
        }
        if (this.instanceHolder == null) {
            return;
        }
        CarriageContraptionInstance instance = (CarriageContraptionInstance)((Object)this.instanceHolder.get());
        if (instance == null) {
            return;
        }
        int bogeySpacing = this.carriage.bogeySpacing;
        Couple<Boolean> bogeyVisibility = this.carriage.bogeys.map(bogey -> {
            if (bogey == null) {
                return null;
            }
            class_2338 bogeyPos = bogey.isLeading ? class_2338.field_10980 : class_2338.field_10980.method_10079(this.getInitialOrientation().method_10160(), bogeySpacing);
            return !this.contraption.isHiddenInPortal(bogeyPos);
        });
        for (boolean first : Iterate.trueAndFalse) {
            Boolean visible = bogeyVisibility.get(first);
            if (visible == null) continue;
            instance.setBogeyVisibility(first, visible);
        }
    }
}

