/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.content.logistics.trains.GlobalRailwayManager;
import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackGraphPacket;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgeData;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgePointType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.TrackEdgePoint;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_2540;

public class TrackGraphSyncPacket
extends TrackGraphPacket {
    Map<Integer, Pair<TrackNodeLocation, class_243>> addedNodes;
    List<Pair<Couple<Integer>, BezierConnection>> addedEdges;
    List<Integer> removedNodes;
    List<TrackEdgePoint> addedEdgePoints;
    List<UUID> removedEdgePoints;
    Map<Integer, Pair<Integer, UUID>> splitSubGraphs;
    Map<Couple<Integer>, Pair<Integer, List<UUID>>> updatedEdgeData;
    boolean fullWipe;
    static final int NULL_GROUP = 0;
    static final int PASSIVE_GROUP = 1;
    static final int GROUP = 2;

    public TrackGraphSyncPacket(UUID graphId, int netId) {
        this.graphId = graphId;
        this.netId = netId;
        this.addedNodes = new HashMap<Integer, Pair<TrackNodeLocation, class_243>>();
        this.addedEdges = new ArrayList<Pair<Couple<Integer>, BezierConnection>>();
        this.removedNodes = new ArrayList<Integer>();
        this.addedEdgePoints = new ArrayList<TrackEdgePoint>();
        this.removedEdgePoints = new ArrayList<UUID>();
        this.updatedEdgeData = new HashMap<Couple<Integer>, Pair<Integer, List<UUID>>>();
        this.splitSubGraphs = new HashMap<Integer, Pair<Integer, UUID>>();
        this.packetDeletesGraph = false;
    }

    public TrackGraphSyncPacket(class_2540 buffer) {
        int i;
        this.graphId = buffer.method_10790();
        this.netId = buffer.readInt();
        this.packetDeletesGraph = buffer.readBoolean();
        this.fullWipe = buffer.readBoolean();
        if (this.packetDeletesGraph) {
            return;
        }
        DimensionPalette dimensions = DimensionPalette.receive(buffer);
        this.addedNodes = new HashMap<Integer, Pair<TrackNodeLocation, class_243>>();
        this.addedEdges = new ArrayList<Pair<Couple<Integer>, BezierConnection>>();
        this.addedEdgePoints = new ArrayList<TrackEdgePoint>();
        this.removedEdgePoints = new ArrayList<UUID>();
        this.removedNodes = new ArrayList<Integer>();
        this.splitSubGraphs = new HashMap<Integer, Pair<Integer, UUID>>();
        this.updatedEdgeData = new HashMap<Couple<Integer>, Pair<Integer, List<UUID>>>();
        int size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            this.removedNodes.add(buffer.method_10816());
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            this.addedNodes.put(buffer.method_10816(), Pair.of(TrackNodeLocation.receive(buffer, dimensions), VecHelper.read(buffer)));
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            this.addedEdges.add(Pair.of(Couple.create(() -> ((class_2540)buffer).method_10816()), buffer.readBoolean() ? new BezierConnection(buffer) : null));
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            this.addedEdgePoints.add(EdgePointType.read(buffer, dimensions));
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            this.removedEdgePoints.add(buffer.method_10790());
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            ArrayList<UUID> list = new ArrayList<UUID>();
            Couple<Integer> key = Couple.create(() -> ((class_2540)buffer).readInt());
            Pair entry = Pair.of(buffer.method_10816(), list);
            int size2 = buffer.method_10816();
            for (int j = 0; j < size2; ++j) {
                list.add(buffer.method_10790());
            }
            this.updatedEdgeData.put(key, entry);
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            this.splitSubGraphs.put(buffer.method_10816(), Pair.of(buffer.readInt(), buffer.method_10790()));
        }
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.graphId);
        buffer.writeInt(this.netId);
        buffer.writeBoolean(this.packetDeletesGraph);
        buffer.writeBoolean(this.fullWipe);
        if (this.packetDeletesGraph) {
            return;
        }
        DimensionPalette dimensions = new DimensionPalette();
        this.addedNodes.forEach((node, loc) -> dimensions.encode(((TrackNodeLocation)((Object)((Object)loc.getFirst()))).dimension));
        this.addedEdgePoints.forEach(ep -> ep.edgeLocation.forEach(loc -> dimensions.encode(loc.dimension)));
        dimensions.send(buffer);
        buffer.method_10804(this.removedNodes.size());
        this.removedNodes.forEach(arg_0 -> ((class_2540)buffer).method_10804(arg_0));
        buffer.method_10804(this.addedNodes.size());
        this.addedNodes.forEach((node, loc) -> {
            buffer.method_10804(node.intValue());
            ((TrackNodeLocation)((Object)((Object)loc.getFirst()))).send(buffer, dimensions);
            VecHelper.write((class_243)loc.getSecond(), buffer);
        });
        buffer.method_10804(this.addedEdges.size());
        this.addedEdges.forEach(pair -> {
            ((Couple)pair.getFirst()).forEach(arg_0 -> ((class_2540)buffer).method_10804(arg_0));
            BezierConnection turn = (BezierConnection)pair.getSecond();
            buffer.writeBoolean(turn != null);
            if (turn != null) {
                turn.write(buffer);
            }
        });
        buffer.method_10804(this.addedEdgePoints.size());
        this.addedEdgePoints.forEach(ep -> ep.write(buffer, dimensions));
        buffer.method_10804(this.removedEdgePoints.size());
        this.removedEdgePoints.forEach(arg_0 -> ((class_2540)buffer).method_10797(arg_0));
        buffer.method_10804(this.updatedEdgeData.size());
        for (Map.Entry<Couple<Integer>, Pair<Integer, List<UUID>>> entry : this.updatedEdgeData.entrySet()) {
            entry.getKey().forEach(arg_0 -> ((class_2540)buffer).writeInt(arg_0));
            Pair<Integer, List<UUID>> pair2 = entry.getValue();
            buffer.method_10804(pair2.getFirst().intValue());
            List<UUID> list = pair2.getSecond();
            buffer.method_10804(list.size());
            list.forEach(arg_0 -> ((class_2540)buffer).method_10797(arg_0));
        }
        buffer.method_10804(this.splitSubGraphs.size());
        this.splitSubGraphs.forEach((node, p) -> {
            buffer.method_10804(node.intValue());
            buffer.writeInt(((Integer)p.getFirst()).intValue());
            buffer.method_10797((UUID)p.getSecond());
        });
    }

    @Override
    protected void handle(GlobalRailwayManager manager, TrackGraph graph) {
        if (this.packetDeletesGraph) {
            manager.removeGraph(graph);
            return;
        }
        if (this.fullWipe) {
            manager.removeGraph(graph);
            graph = Create.RAILWAYS.sided(null).getOrCreateGraph(this.graphId, this.netId);
        }
        Iterator<Object> iterator = this.removedNodes.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            TrackNode node = graph.getNode(n);
            if (node == null) continue;
            graph.removeNode(null, node.getLocation());
        }
        for (Map.Entry entry : this.addedNodes.entrySet()) {
            Integer nodeId = (Integer)entry.getKey();
            Pair nodeLocation = (Pair)entry.getValue();
            graph.loadNode((TrackNodeLocation)((Object)nodeLocation.getFirst()), nodeId, (class_243)nodeLocation.getSecond());
        }
        for (Pair pair : this.addedEdges) {
            Couple<TrackNode> nodes = ((Couple)pair.getFirst()).map(graph::getNode);
            TrackNode node1 = (TrackNode)nodes.getFirst();
            TrackNode node2 = (TrackNode)nodes.getSecond();
            if (node1 == null || node2 == null) continue;
            graph.putConnection(node1, node2, new TrackEdge(node1, node2, (BezierConnection)pair.getSecond()));
        }
        for (TrackEdgePoint trackEdgePoint : this.addedEdgePoints) {
            graph.edgePoints.put(trackEdgePoint.getType(), trackEdgePoint);
        }
        for (UUID uUID : this.removedEdgePoints) {
            for (EdgePointType<?> type : EdgePointType.TYPES.values()) {
                graph.edgePoints.remove(type, uUID);
            }
        }
        this.handleEdgeData(manager, graph);
        if (!this.splitSubGraphs.isEmpty()) {
            graph.findDisconnectedGraphs(null, this.splitSubGraphs).forEach(manager::putGraph);
        }
    }

    protected void handleEdgeData(GlobalRailwayManager manager, TrackGraph graph) {
        for (Map.Entry<Couple<Integer>, Pair<Integer, List<UUID>>> entry : this.updatedEdgeData.entrySet()) {
            int i;
            TrackEdge edge;
            List<UUID> idList = entry.getValue().getSecond();
            int groupType = entry.getValue().getFirst();
            Couple<TrackNode> nodes = entry.getKey().map(graph::getNode);
            if (nodes.either(Objects::isNull) || (edge = graph.getConnectionsFrom((TrackNode)nodes.getFirst()).get(nodes.getSecond())) == null) continue;
            EdgeData edgeData = new EdgeData(edge);
            if (groupType == 0) {
                edgeData.setSingleSignalGroup(null, null);
            } else if (groupType == 1) {
                edgeData.setSingleSignalGroup(null, EdgeData.passiveGroup);
            } else {
                edgeData.setSingleSignalGroup(null, idList.get(0));
            }
            List<TrackEdgePoint> points = edgeData.getPoints();
            edge.edgeData = edgeData;
            int n = i = groupType == 2 ? 1 : 0;
            while (i < idList.size()) {
                UUID uuid = idList.get(i);
                for (EdgePointType<?> type : EdgePointType.TYPES.values()) {
                    Object point = graph.edgePoints.get(type, uuid);
                    if (point == null) continue;
                    points.add((TrackEdgePoint)point);
                    break;
                }
                ++i;
            }
        }
    }

    public void syncEdgeData(TrackNode node1, TrackNode node2, TrackEdge edge) {
        int groupType;
        Couple<Integer> key = Couple.create(node1.getNetId(), node2.getNetId());
        ArrayList<UUID> list = new ArrayList<UUID>();
        EdgeData edgeData = edge.getEdgeData();
        int n = edgeData.hasSignalBoundaries() ? 0 : (groupType = EdgeData.passiveGroup.equals(edgeData.getSingleSignalGroup()) ? 1 : 2);
        if (groupType == 2) {
            list.add(edgeData.getSingleSignalGroup());
        }
        for (TrackEdgePoint point : edgeData.getPoints()) {
            list.add(point.getId());
        }
        this.updatedEdgeData.put(key, Pair.of(groupType, list));
    }
}

