/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1843;
import net.minecraft.class_2487;

public class BookCopyAttribute
implements ItemAttribute {
    int generation;

    public BookCopyAttribute(int generation) {
        this.generation = generation;
    }

    @Override
    public boolean appliesTo(class_1799 itemStack) {
        return this.extractGeneration(itemStack) == this.generation;
    }

    @Override
    public List<ItemAttribute> listAttributesOf(class_1799 itemStack) {
        int generation = this.extractGeneration(itemStack);
        ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
        if (generation >= 0) {
            atts.add(new BookCopyAttribute(generation));
        }
        return atts;
    }

    @Override
    public String getTranslationKey() {
        switch (this.generation) {
            case 0: {
                return "book_copy_original";
            }
            case 1: {
                return "book_copy_first";
            }
            case 2: {
                return "book_copy_second";
            }
        }
        return "book_copy_tattered";
    }

    @Override
    public void writeNBT(class_2487 nbt) {
        nbt.method_10569("generation", this.generation);
    }

    @Override
    public ItemAttribute readNBT(class_2487 nbt) {
        return new BookCopyAttribute(nbt.method_10550("generation"));
    }

    @Override
    public String getNBTKey() {
        return "book_copy";
    }

    private int extractGeneration(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null && stack.method_7909() instanceof class_1843) {
            return nbt.method_10550("generation");
        }
        return -1;
    }
}

