/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.content.logistics.block.display.DisplayLinkBlock;
import com.simibubi.create.content.logistics.block.redstone.NixieTubeBlock;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalTileEntity;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.DynamicComponent;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5250;

public class NixieTubeTileEntity
extends SmartTileEntity {
    private static final Couple<String> EMPTY = Couple.create("", "");
    private int redstoneStrength = 0;
    private Optional<DynamicComponent> customText = Optional.empty();
    private int nixieIndex;
    private Couple<String> displayedStrings;
    private WeakReference<SignalTileEntity> cachedSignalTE = new WeakReference<Object>(null);
    public SignalTileEntity.SignalState signalState;

    public NixieTubeTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.field_11863.field_9236) {
            return;
        }
        this.signalState = null;
        SignalTileEntity signalTileEntity = (SignalTileEntity)this.cachedSignalTE.get();
        if (signalTileEntity == null || signalTileEntity.method_11015()) {
            class_2350 facing = NixieTubeBlock.getFacing(this.method_11010());
            class_2586 blockEntity = this.field_11863.method_8321(this.field_11867.method_10093(facing.method_10153()));
            if (blockEntity instanceof SignalTileEntity) {
                SignalTileEntity signal = (SignalTileEntity)blockEntity;
                this.signalState = signal.getState();
                this.cachedSignalTE = new WeakReference<SignalTileEntity>(signal);
            }
            return;
        }
        this.signalState = signalTileEntity.getState();
    }

    @Override
    public void initialize() {
        if (this.field_11863.field_9236) {
            this.updateDisplayedStrings();
        }
    }

    public boolean reactsToRedstone() {
        return this.customText.isEmpty();
    }

    public Couple<String> getDisplayedStrings() {
        if (this.displayedStrings == null) {
            return EMPTY;
        }
        return this.displayedStrings;
    }

    public class_5250 getFullText() {
        return this.customText.map(DynamicComponent::get).orElse(Components.literal("" + this.redstoneStrength));
    }

    public void updateRedstoneStrength(int signalStrength) {
        this.clearCustomText();
        this.redstoneStrength = signalStrength;
        DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
        this.notifyUpdate();
    }

    public void displayCustomText(String tagElement, int nixiePositionInRow) {
        if (tagElement == null) {
            return;
        }
        if (this.customText.filter(d -> d.sameAs(tagElement)).isPresent()) {
            return;
        }
        DynamicComponent component = this.customText.orElseGet(DynamicComponent::new);
        component.displayCustomText(this.field_11863, this.field_11867, tagElement);
        this.customText = Optional.of(component);
        this.nixieIndex = nixiePositionInRow;
        DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
        this.notifyUpdate();
    }

    public void updateDisplayedStrings() {
        if (this.signalState != null) {
            return;
        }
        this.customText.map(DynamicComponent::resolve).ifPresentOrElse(fullText -> {
            this.displayedStrings = Couple.create(this.charOrEmpty((String)fullText, this.nixieIndex * 2), this.charOrEmpty((String)fullText, this.nixieIndex * 2 + 1));
        }, () -> {
            this.displayedStrings = Couple.create(this.redstoneStrength < 10 ? "0" : "1", String.valueOf(this.redstoneStrength % 10));
        });
    }

    public void clearCustomText() {
        this.nixieIndex = 0;
        this.customText = Optional.empty();
    }

    @Override
    protected void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (nbt.method_10545("CustomText")) {
            DynamicComponent component = this.customText.orElseGet(DynamicComponent::new);
            component.read(this.field_11863, this.field_11867, nbt);
            if (component.isValid()) {
                this.customText = Optional.of(component);
                this.nixieIndex = nbt.method_10550("CustomTextIndex");
            } else {
                this.customText = Optional.empty();
                this.nixieIndex = 0;
            }
        }
        if (this.customText.isEmpty()) {
            this.redstoneStrength = nbt.method_10550("RedstoneStrength");
        }
        if (clientPacket) {
            this.updateDisplayedStrings();
        }
    }

    @Override
    protected void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (this.customText.isPresent()) {
            nbt.method_10569("CustomTextIndex", this.nixieIndex);
            this.customText.get().write(nbt);
        } else {
            nbt.method_10569("RedstoneStrength", this.redstoneStrength);
        }
    }

    private String charOrEmpty(String string, int index) {
        return string.length() <= index ? " " : string.substring(index, index + 1);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }
}

