/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.inventories;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerSnapshot;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public class BottomlessItemHandler
extends ItemStackHandler
implements SingleSlotStorage<ItemVariant> {
    private Supplier<class_1799> suppliedItemStack;
    private List<? extends StorageView<ItemVariant>> self;

    public BottomlessItemHandler(Supplier<class_1799> suppliedItemStack) {
        this.suppliedItemStack = suppliedItemStack;
        this.self = List.of(this);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        return maxAmount;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        class_1799 stack = this.suppliedItemStack.get();
        if (stack == null || !resource.matches(stack)) {
            return 0L;
        }
        if (!stack.method_7960()) {
            return Math.min((long)stack.method_7914(), maxAmount);
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public ItemVariant getResource() {
        class_1799 stack = this.suppliedItemStack.get();
        return stack == null || stack.method_7960() ? ItemVariant.blank() : ItemVariant.of((class_1799)stack);
    }

    public long getAmount() {
        return Long.MAX_VALUE;
    }

    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        return super.iterator();
    }

    public Iterator<? extends StorageView<ItemVariant>> nonEmptyViews() {
        return this.isResourceBlank() ? Collections.emptyIterator() : this.self.iterator();
    }

    public void setStackInSlot(int slot, class_1799 stack) {
    }

    public class_1799 getStackInSlot(int slot) {
        class_1799 stack = this.suppliedItemStack.get();
        if (stack == null) {
            return class_1799.field_8037;
        }
        if (!stack.method_7960()) {
            return ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)stack.method_7914());
        }
        return stack;
    }

    protected ItemStackHandlerSnapshot createSnapshot() {
        return BottomlessSnapshotData.INSTANCE;
    }

    public static class BottomlessSnapshotData
    implements ItemStackHandlerSnapshot {
        public static final BottomlessSnapshotData INSTANCE = new BottomlessSnapshotData();

        private BottomlessSnapshotData() {
        }

        public void apply(ItemStackHandler handler) {
        }
    }
}

