/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.block.flap.FlapData;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.ArrayList;
import net.minecraft.class_1944;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public class FunnelInstance
extends BlockEntityInstance<FunnelTileEntity>
implements DynamicInstance {
    private final ArrayList<FlapData> flaps = new ArrayList(4);

    public FunnelInstance(MaterialManager modelManager, FunnelTileEntity tile) {
        super(modelManager, (class_2586)tile);
        if (!tile.hasFlap()) {
            return;
        }
        PartialModel flapPartial = this.blockState.method_26204() instanceof FunnelBlock ? AllBlockPartials.FUNNEL_FLAP : AllBlockPartials.BELT_FUNNEL_FLAP;
        Instancer model = modelManager.defaultSolid().material(AllMaterialSpecs.FLAPS).getModel(flapPartial, this.blockState);
        int blockLight = this.world.method_8314(class_1944.field_9282, this.pos);
        int skyLight = this.world.method_8314(class_1944.field_9284, this.pos);
        class_2350 direction = FunnelBlock.getFunnelFacing(this.blockState);
        float flapness = tile.flap.getValue(AnimationTickHolder.getPartialTicks());
        float horizontalAngle = direction.method_10153().method_10144();
        for (int segment = 0; segment <= 3; ++segment) {
            float intensity = segment == 3 ? 1.5f : (float)(segment + 1);
            float segmentOffset = -0.1875f * (float)segment;
            FlapData key = (FlapData)model.createInstance();
            key.setPosition(this.getInstancePosition()).setSegmentOffset(segmentOffset, 0.0f, -tile.getFlapOffset()).setBlockLight(blockLight).setSkyLight(skyLight).setHorizontalAngle(horizontalAngle).setFlapness(flapness).setFlapScale(-1.0f).setPivotVoxelSpace(0.0f, 10.0f, 9.5f).setIntensity(intensity);
            this.flaps.add(key);
        }
    }

    public void beginFrame() {
        if (this.flaps == null) {
            return;
        }
        float flapness = ((FunnelTileEntity)this.blockEntity).flap.getValue(AnimationTickHolder.getPartialTicks());
        for (FlapData flap : this.flaps) {
            flap.setFlapness(flapness);
        }
    }

    public void updateLight() {
        if (this.flaps != null) {
            this.relight(this.pos, this.flaps.stream());
        }
    }

    public void remove() {
        if (this.flaps == null) {
            return;
        }
        this.flaps.forEach(InstanceData::delete);
    }
}

