/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.diodes;

import com.simibubi.create.content.logistics.block.diodes.BrassDiodeBlock;
import com.simibubi.create.content.logistics.block.diodes.BrassDiodeScrollSlot;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public abstract class BrassDiodeTileEntity
extends SmartTileEntity {
    protected int state;
    ScrollValueBehaviour maxState;

    public BrassDiodeTileEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.maxState = new ScrollValueBehaviour((class_2561)Lang.translateDirect("generic.delay", new Object[0]), this, new BrassDiodeScrollSlot()).between(2, 36000);
        this.maxState.withStepFunction(this::step);
        this.maxState.withFormatter(this::format);
        this.maxState.withUnit(this::getUnit);
        this.maxState.withCallback(this::onMaxDelayChanged);
        behaviours.add(this.maxState);
    }

    public float getProgress() {
        int max = Math.max(2, this.maxState.getValue());
        return (float)class_3532.method_15340((int)this.state, (int)0, (int)max) / (float)max;
    }

    public boolean isIdle() {
        return this.state == 0;
    }

    @Override
    public void tick() {
        super.tick();
        boolean powered = (Boolean)this.method_11010().method_11654((class_2769)class_2312.field_10911);
        boolean powering = (Boolean)this.method_11010().method_11654((class_2769)BrassDiodeBlock.POWERING);
        boolean atMax = this.state >= this.maxState.getValue();
        boolean atMin = this.state <= 0;
        this.updateState(powered, powering, atMax, atMin);
    }

    protected abstract void updateState(boolean var1, boolean var2, boolean var3, boolean var4);

    private void onMaxDelayChanged(int newMax) {
        this.state = class_3532.method_15340((int)this.state, (int)0, (int)newMax);
        this.sendData();
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.state = compound.method_10550("State");
        super.read(compound, clientPacket);
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("State", this.state);
        super.write(compound, clientPacket);
    }

    private int step(ScrollValueBehaviour.StepContext context) {
        int value = context.currentValue;
        if (!context.forward) {
            --value;
        }
        if (value < 20) {
            return 1;
        }
        if (value < 1200) {
            return 20;
        }
        return 1200;
    }

    private String format(int value) {
        if (value < 20) {
            return value + "t";
        }
        if (value < 1200) {
            return value / 20 + "s";
        }
        return value / 20 / 60 + "m";
    }

    private class_2561 getUnit(int value) {
        if (value < 20) {
            return Lang.translateDirect("generic.unit.ticks", new Object[0]);
        }
        if (value < 1200) {
            return Lang.translateDirect("generic.unit.seconds", new Object[0]);
        }
        return Lang.translateDirect("generic.unit.minutes", new Object[0]);
    }
}

